/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Information to a installment plan.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstallmentPlan extends com.google.api.client.json.GenericJson {

  /**
   * Total number of payments the user is initially committed for.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer initialCommittedPaymentsCount;

  /**
   * If present, this installment plan is pending to be canceled. The cancellation will happen only
   * after the user finished all committed payments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PendingCancellation pendingCancellation;

  /**
   * Total number of committed payments remaining to be paid for in this renewal cycle.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer remainingCommittedPaymentsCount;

  /**
   * Total number of payments the user will be committed for after each commitment period. Empty
   * means the installment plan will fall back to a normal auto-renew subscription after initial
   * commitment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer subsequentCommittedPaymentsCount;

  /**
   * Total number of payments the user is initially committed for.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getInitialCommittedPaymentsCount() {
    return initialCommittedPaymentsCount;
  }

  /**
   * Total number of payments the user is initially committed for.
   * @param initialCommittedPaymentsCount initialCommittedPaymentsCount or {@code null} for none
   */
  public InstallmentPlan setInitialCommittedPaymentsCount(java.lang.Integer initialCommittedPaymentsCount) {
    this.initialCommittedPaymentsCount = initialCommittedPaymentsCount;
    return this;
  }

  /**
   * If present, this installment plan is pending to be canceled. The cancellation will happen only
   * after the user finished all committed payments.
   * @return value or {@code null} for none
   */
  public PendingCancellation getPendingCancellation() {
    return pendingCancellation;
  }

  /**
   * If present, this installment plan is pending to be canceled. The cancellation will happen only
   * after the user finished all committed payments.
   * @param pendingCancellation pendingCancellation or {@code null} for none
   */
  public InstallmentPlan setPendingCancellation(PendingCancellation pendingCancellation) {
    this.pendingCancellation = pendingCancellation;
    return this;
  }

  /**
   * Total number of committed payments remaining to be paid for in this renewal cycle.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRemainingCommittedPaymentsCount() {
    return remainingCommittedPaymentsCount;
  }

  /**
   * Total number of committed payments remaining to be paid for in this renewal cycle.
   * @param remainingCommittedPaymentsCount remainingCommittedPaymentsCount or {@code null} for none
   */
  public InstallmentPlan setRemainingCommittedPaymentsCount(java.lang.Integer remainingCommittedPaymentsCount) {
    this.remainingCommittedPaymentsCount = remainingCommittedPaymentsCount;
    return this;
  }

  /**
   * Total number of payments the user will be committed for after each commitment period. Empty
   * means the installment plan will fall back to a normal auto-renew subscription after initial
   * commitment.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSubsequentCommittedPaymentsCount() {
    return subsequentCommittedPaymentsCount;
  }

  /**
   * Total number of payments the user will be committed for after each commitment period. Empty
   * means the installment plan will fall back to a normal auto-renew subscription after initial
   * commitment.
   * @param subsequentCommittedPaymentsCount subsequentCommittedPaymentsCount or {@code null} for none
   */
  public InstallmentPlan setSubsequentCommittedPaymentsCount(java.lang.Integer subsequentCommittedPaymentsCount) {
    this.subsequentCommittedPaymentsCount = subsequentCommittedPaymentsCount;
    return this;
  }

  @Override
  public InstallmentPlan set(String fieldName, Object value) {
    return (InstallmentPlan) super.set(fieldName, value);
  }

  @Override
  public InstallmentPlan clone() {
    return (InstallmentPlan) super.clone();
  }

}
