/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Object representation for Remote in-app update action type.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RemoteInAppUpdate extends com.google.api.client.json.GenericJson {

  /**
   * Required. Set to true if Remote In-App Update action type is needed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isRemoteInAppUpdateRequested;

  /**
   * Required. Set to true if Remote In-App Update action type is needed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsRemoteInAppUpdateRequested() {
    return isRemoteInAppUpdateRequested;
  }

  /**
   * Required. Set to true if Remote In-App Update action type is needed.
   * @param isRemoteInAppUpdateRequested isRemoteInAppUpdateRequested or {@code null} for none
   */
  public RemoteInAppUpdate setIsRemoteInAppUpdateRequested(java.lang.Boolean isRemoteInAppUpdateRequested) {
    this.isRemoteInAppUpdateRequested = isRemoteInAppUpdateRequested;
    return this;
  }

  @Override
  public RemoteInAppUpdate set(String fieldName, Object value) {
    return (RemoteInAppUpdate) super.set(fieldName, value);
  }

  @Override
  public RemoteInAppUpdate clone() {
    return (RemoteInAppUpdate) super.clone();
  }

}
