/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Details about taxation, Google Play policy and legal compliance for subscription products.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionTaxAndComplianceSettings extends com.google.api.client.json.GenericJson {

  /**
   * Digital content or service classification for products distributed to users in the European
   * Economic Area (EEA). The withdrawal regime under EEA consumer laws depends on this
   * classification. Refer to the [Help Center
   * article](https://support.google.com/googleplay/android-developer/answer/10463498) for more
   * information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eeaWithdrawalRightType;

  /**
   * Whether this subscription is declared as a product representing a tokenized digital asset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isTokenizedDigitalAsset;

  /**
   * A mapping from region code to tax rate details. The keys are region codes as defined by
   * Unicode's "CLDR".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, RegionalTaxRateInfo> taxRateInfoByRegionCode;

  static {
    // hack to force ProGuard to consider RegionalTaxRateInfo used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(RegionalTaxRateInfo.class);
  }

  /**
   * Digital content or service classification for products distributed to users in the European
   * Economic Area (EEA). The withdrawal regime under EEA consumer laws depends on this
   * classification. Refer to the [Help Center
   * article](https://support.google.com/googleplay/android-developer/answer/10463498) for more
   * information.
   * @return value or {@code null} for none
   */
  public java.lang.String getEeaWithdrawalRightType() {
    return eeaWithdrawalRightType;
  }

  /**
   * Digital content or service classification for products distributed to users in the European
   * Economic Area (EEA). The withdrawal regime under EEA consumer laws depends on this
   * classification. Refer to the [Help Center
   * article](https://support.google.com/googleplay/android-developer/answer/10463498) for more
   * information.
   * @param eeaWithdrawalRightType eeaWithdrawalRightType or {@code null} for none
   */
  public SubscriptionTaxAndComplianceSettings setEeaWithdrawalRightType(java.lang.String eeaWithdrawalRightType) {
    this.eeaWithdrawalRightType = eeaWithdrawalRightType;
    return this;
  }

  /**
   * Whether this subscription is declared as a product representing a tokenized digital asset.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsTokenizedDigitalAsset() {
    return isTokenizedDigitalAsset;
  }

  /**
   * Whether this subscription is declared as a product representing a tokenized digital asset.
   * @param isTokenizedDigitalAsset isTokenizedDigitalAsset or {@code null} for none
   */
  public SubscriptionTaxAndComplianceSettings setIsTokenizedDigitalAsset(java.lang.Boolean isTokenizedDigitalAsset) {
    this.isTokenizedDigitalAsset = isTokenizedDigitalAsset;
    return this;
  }

  /**
   * A mapping from region code to tax rate details. The keys are region codes as defined by
   * Unicode's "CLDR".
   * @return value or {@code null} for none
   */
  public java.util.Map<String, RegionalTaxRateInfo> getTaxRateInfoByRegionCode() {
    return taxRateInfoByRegionCode;
  }

  /**
   * A mapping from region code to tax rate details. The keys are region codes as defined by
   * Unicode's "CLDR".
   * @param taxRateInfoByRegionCode taxRateInfoByRegionCode or {@code null} for none
   */
  public SubscriptionTaxAndComplianceSettings setTaxRateInfoByRegionCode(java.util.Map<String, RegionalTaxRateInfo> taxRateInfoByRegionCode) {
    this.taxRateInfoByRegionCode = taxRateInfoByRegionCode;
    return this;
  }

  @Override
  public SubscriptionTaxAndComplianceSettings set(String fieldName, Object value) {
    return (SubscriptionTaxAndComplianceSettings) super.set(fieldName, value);
  }

  @Override
  public SubscriptionTaxAndComplianceSettings clone() {
    return (SubscriptionTaxAndComplianceSettings) super.clone();
  }

}
