/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Set of asset slices belonging to a single asset module.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AssetSliceSet extends com.google.api.client.json.GenericJson {

  /**
   * Asset slices.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ApkDescription> apkDescription;

  static {
    // hack to force ProGuard to consider ApkDescription used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ApkDescription.class);
  }

  /**
   * Module level metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AssetModuleMetadata assetModuleMetadata;

  /**
   * Asset slices.
   * @return value or {@code null} for none
   */
  public java.util.List<ApkDescription> getApkDescription() {
    return apkDescription;
  }

  /**
   * Asset slices.
   * @param apkDescription apkDescription or {@code null} for none
   */
  public AssetSliceSet setApkDescription(java.util.List<ApkDescription> apkDescription) {
    this.apkDescription = apkDescription;
    return this;
  }

  /**
   * Module level metadata.
   * @return value or {@code null} for none
   */
  public AssetModuleMetadata getAssetModuleMetadata() {
    return assetModuleMetadata;
  }

  /**
   * Module level metadata.
   * @param assetModuleMetadata assetModuleMetadata or {@code null} for none
   */
  public AssetSliceSet setAssetModuleMetadata(AssetModuleMetadata assetModuleMetadata) {
    this.assetModuleMetadata = assetModuleMetadata;
    return this;
  }

  @Override
  public AssetSliceSet set(String fieldName, Object value) {
    return (AssetSliceSet) super.set(fieldName, value);
  }

  @Override
  public AssetSliceSet clone() {
    return (AssetSliceSet) super.clone();
  }

}
