/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Metadata of a module.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ModuleMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Indicates the delivery type (e.g. on-demand) of the module.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deliveryType;

  /**
   * Names of the modules that this module directly depends on. Each module implicitly depends on
   * the base module.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> dependencies;

  /**
   * Indicates the type of this feature module.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String moduleType;

  /**
   * Module name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The targeting that makes a conditional module installed. Relevant only for Split APKs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ModuleTargeting targeting;

  /**
   * Indicates the delivery type (e.g. on-demand) of the module.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeliveryType() {
    return deliveryType;
  }

  /**
   * Indicates the delivery type (e.g. on-demand) of the module.
   * @param deliveryType deliveryType or {@code null} for none
   */
  public ModuleMetadata setDeliveryType(java.lang.String deliveryType) {
    this.deliveryType = deliveryType;
    return this;
  }

  /**
   * Names of the modules that this module directly depends on. Each module implicitly depends on
   * the base module.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDependencies() {
    return dependencies;
  }

  /**
   * Names of the modules that this module directly depends on. Each module implicitly depends on
   * the base module.
   * @param dependencies dependencies or {@code null} for none
   */
  public ModuleMetadata setDependencies(java.util.List<java.lang.String> dependencies) {
    this.dependencies = dependencies;
    return this;
  }

  /**
   * Indicates the type of this feature module.
   * @return value or {@code null} for none
   */
  public java.lang.String getModuleType() {
    return moduleType;
  }

  /**
   * Indicates the type of this feature module.
   * @param moduleType moduleType or {@code null} for none
   */
  public ModuleMetadata setModuleType(java.lang.String moduleType) {
    this.moduleType = moduleType;
    return this;
  }

  /**
   * Module name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Module name.
   * @param name name or {@code null} for none
   */
  public ModuleMetadata setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The targeting that makes a conditional module installed. Relevant only for Split APKs.
   * @return value or {@code null} for none
   */
  public ModuleTargeting getTargeting() {
    return targeting;
  }

  /**
   * The targeting that makes a conditional module installed. Relevant only for Split APKs.
   * @param targeting targeting or {@code null} for none
   */
  public ModuleMetadata setTargeting(ModuleTargeting targeting) {
    this.targeting = targeting;
    return this;
  }

  @Override
  public ModuleMetadata set(String fieldName, Object value) {
    return (ModuleMetadata) super.set(fieldName, value);
  }

  @Override
  public ModuleMetadata clone() {
    return (ModuleMetadata) super.clone();
  }

}
