/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Information about the current page. List operations that supports paging return only one "page"
 * of results. This protocol buffer message describes the page that has been returned.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PageInfo extends com.google.api.client.json.GenericJson {

  /**
   * Maximum number of results returned in one page. ! The number of results included in the API
   * response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer resultPerPage;

  /**
   * Index of the first result returned in the current page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startIndex;

  /**
   * Total number of results available on the backend ! The total number of results in the result
   * set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalResults;

  /**
   * Maximum number of results returned in one page. ! The number of results included in the API
   * response.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getResultPerPage() {
    return resultPerPage;
  }

  /**
   * Maximum number of results returned in one page. ! The number of results included in the API
   * response.
   * @param resultPerPage resultPerPage or {@code null} for none
   */
  public PageInfo setResultPerPage(java.lang.Integer resultPerPage) {
    this.resultPerPage = resultPerPage;
    return this;
  }

  /**
   * Index of the first result returned in the current page.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartIndex() {
    return startIndex;
  }

  /**
   * Index of the first result returned in the current page.
   * @param startIndex startIndex or {@code null} for none
   */
  public PageInfo setStartIndex(java.lang.Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  /**
   * Total number of results available on the backend ! The total number of results in the result
   * set.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalResults() {
    return totalResults;
  }

  /**
   * Total number of results available on the backend ! The total number of results in the result
   * set.
   * @param totalResults totalResults or {@code null} for none
   */
  public PageInfo setTotalResults(java.lang.Integer totalResults) {
    this.totalResults = totalResults;
    return this;
  }

  @Override
  public PageInfo set(String fieldName, Object value) {
    return (PageInfo) super.set(fieldName, value);
  }

  @Override
  public PageInfo clone() {
    return (PageInfo) super.clone();
  }

}
