/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Region targeting data for app recovery action targeting.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Regions extends com.google.api.client.json.GenericJson {

  /**
   * Regions targeted by the recovery action. Region codes are ISO 3166 Alpha-2 country codes. For
   * example, US stands for United States of America. See https://www.iso.org/iso-3166-country-
   * codes.html for the complete list of country codes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> regionCode;

  /**
   * Regions targeted by the recovery action. Region codes are ISO 3166 Alpha-2 country codes. For
   * example, US stands for United States of America. See https://www.iso.org/iso-3166-country-
   * codes.html for the complete list of country codes.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRegionCode() {
    return regionCode;
  }

  /**
   * Regions targeted by the recovery action. Region codes are ISO 3166 Alpha-2 country codes. For
   * example, US stands for United States of America. See https://www.iso.org/iso-3166-country-
   * codes.html for the complete list of country codes.
   * @param regionCode regionCode or {@code null} for none
   */
  public Regions setRegionCode(java.util.List<java.lang.String> regionCode) {
    this.regionCode = regionCode;
    return this;
  }

  @Override
  public Regions set(String fieldName, Object value) {
    return (Regions) super.set(fieldName, value);
  }

  @Override
  public Regions clone() {
    return (Regions) super.clone();
  }

}
