/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Data related to the recovery action at bundle level.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RemoteInAppUpdateDataPerBundle extends com.google.api.client.json.GenericJson {

  /**
   * Total number of devices which have been rescued.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long recoveredDeviceCount;

  /**
   * Total number of devices affected by this recovery action associated with bundle of the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalDeviceCount;

  /**
   * Version Code corresponding to the target bundle.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long versionCode;

  /**
   * Total number of devices which have been rescued.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRecoveredDeviceCount() {
    return recoveredDeviceCount;
  }

  /**
   * Total number of devices which have been rescued.
   * @param recoveredDeviceCount recoveredDeviceCount or {@code null} for none
   */
  public RemoteInAppUpdateDataPerBundle setRecoveredDeviceCount(java.lang.Long recoveredDeviceCount) {
    this.recoveredDeviceCount = recoveredDeviceCount;
    return this;
  }

  /**
   * Total number of devices affected by this recovery action associated with bundle of the app.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalDeviceCount() {
    return totalDeviceCount;
  }

  /**
   * Total number of devices affected by this recovery action associated with bundle of the app.
   * @param totalDeviceCount totalDeviceCount or {@code null} for none
   */
  public RemoteInAppUpdateDataPerBundle setTotalDeviceCount(java.lang.Long totalDeviceCount) {
    this.totalDeviceCount = totalDeviceCount;
    return this;
  }

  /**
   * Version Code corresponding to the target bundle.
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersionCode() {
    return versionCode;
  }

  /**
   * Version Code corresponding to the target bundle.
   * @param versionCode versionCode or {@code null} for none
   */
  public RemoteInAppUpdateDataPerBundle setVersionCode(java.lang.Long versionCode) {
    this.versionCode = versionCode;
    return this;
  }

  @Override
  public RemoteInAppUpdateDataPerBundle set(String fieldName, Object value) {
    return (RemoteInAppUpdateDataPerBundle) super.set(fieldName, value);
  }

  @Override
  public RemoteInAppUpdateDataPerBundle clone() {
    return (RemoteInAppUpdateDataPerBundle) super.clone();
  }

}
