/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Options for system APKs.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SystemApkOptions extends com.google.api.client.json.GenericJson {

  /**
   * Whether to use the rotated key for signing the system APK.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean rotated;

  /**
   * Whether system APK was generated with uncompressed dex files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean uncompressedDexFiles;

  /**
   * Whether system APK was generated with uncompressed native libraries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean uncompressedNativeLibraries;

  /**
   * Whether to use the rotated key for signing the system APK.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRotated() {
    return rotated;
  }

  /**
   * Whether to use the rotated key for signing the system APK.
   * @param rotated rotated or {@code null} for none
   */
  public SystemApkOptions setRotated(java.lang.Boolean rotated) {
    this.rotated = rotated;
    return this;
  }

  /**
   * Whether system APK was generated with uncompressed dex files.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUncompressedDexFiles() {
    return uncompressedDexFiles;
  }

  /**
   * Whether system APK was generated with uncompressed dex files.
   * @param uncompressedDexFiles uncompressedDexFiles or {@code null} for none
   */
  public SystemApkOptions setUncompressedDexFiles(java.lang.Boolean uncompressedDexFiles) {
    this.uncompressedDexFiles = uncompressedDexFiles;
    return this;
  }

  /**
   * Whether system APK was generated with uncompressed native libraries.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUncompressedNativeLibraries() {
    return uncompressedNativeLibraries;
  }

  /**
   * Whether system APK was generated with uncompressed native libraries.
   * @param uncompressedNativeLibraries uncompressedNativeLibraries or {@code null} for none
   */
  public SystemApkOptions setUncompressedNativeLibraries(java.lang.Boolean uncompressedNativeLibraries) {
    this.uncompressedNativeLibraries = uncompressedNativeLibraries;
    return this;
  }

  @Override
  public SystemApkOptions set(String fieldName, Object value) {
    return (SystemApkOptions) super.set(fieldName, value);
  }

  @Override
  public SystemApkOptions clone() {
    return (SystemApkOptions) super.clone();
  }

}
