/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Request message for UpdateSubscriptionOffer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateSubscriptionOfferRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. If set to true, and the subscription offer with the given package_name, product_id,
   * base_plan_id and offer_id doesn't exist, an offer will be created. If a new offer is created,
   * update_mask is ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowMissing;

  /**
   * Optional. The latency tolerance for the propagation of this product update. Defaults to
   * latency-sensitive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String latencyTolerance;

  /**
   * Required. The version of the available regions being used for the subscription_offer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RegionsVersion regionsVersion;

  /**
   * Required. The subscription offer to update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubscriptionOffer subscriptionOffer;

  /**
   * Required. The list of fields to be updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateMask;

  /**
   * Optional. If set to true, and the subscription offer with the given package_name, product_id,
   * base_plan_id and offer_id doesn't exist, an offer will be created. If a new offer is created,
   * update_mask is ignored.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowMissing() {
    return allowMissing;
  }

  /**
   * Optional. If set to true, and the subscription offer with the given package_name, product_id,
   * base_plan_id and offer_id doesn't exist, an offer will be created. If a new offer is created,
   * update_mask is ignored.
   * @param allowMissing allowMissing or {@code null} for none
   */
  public UpdateSubscriptionOfferRequest setAllowMissing(java.lang.Boolean allowMissing) {
    this.allowMissing = allowMissing;
    return this;
  }

  /**
   * Optional. The latency tolerance for the propagation of this product update. Defaults to
   * latency-sensitive.
   * @return value or {@code null} for none
   */
  public java.lang.String getLatencyTolerance() {
    return latencyTolerance;
  }

  /**
   * Optional. The latency tolerance for the propagation of this product update. Defaults to
   * latency-sensitive.
   * @param latencyTolerance latencyTolerance or {@code null} for none
   */
  public UpdateSubscriptionOfferRequest setLatencyTolerance(java.lang.String latencyTolerance) {
    this.latencyTolerance = latencyTolerance;
    return this;
  }

  /**
   * Required. The version of the available regions being used for the subscription_offer.
   * @return value or {@code null} for none
   */
  public RegionsVersion getRegionsVersion() {
    return regionsVersion;
  }

  /**
   * Required. The version of the available regions being used for the subscription_offer.
   * @param regionsVersion regionsVersion or {@code null} for none
   */
  public UpdateSubscriptionOfferRequest setRegionsVersion(RegionsVersion regionsVersion) {
    this.regionsVersion = regionsVersion;
    return this;
  }

  /**
   * Required. The subscription offer to update.
   * @return value or {@code null} for none
   */
  public SubscriptionOffer getSubscriptionOffer() {
    return subscriptionOffer;
  }

  /**
   * Required. The subscription offer to update.
   * @param subscriptionOffer subscriptionOffer or {@code null} for none
   */
  public UpdateSubscriptionOfferRequest setSubscriptionOffer(SubscriptionOffer subscriptionOffer) {
    this.subscriptionOffer = subscriptionOffer;
    return this;
  }

  /**
   * Required. The list of fields to be updated.
   * @return value or {@code null} for none
   */
  public String getUpdateMask() {
    return updateMask;
  }

  /**
   * Required. The list of fields to be updated.
   * @param updateMask updateMask or {@code null} for none
   */
  public UpdateSubscriptionOfferRequest setUpdateMask(String updateMask) {
    this.updateMask = updateMask;
    return this;
  }

  @Override
  public UpdateSubscriptionOfferRequest set(String fieldName, Object value) {
    return (UpdateSubscriptionOfferRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateSubscriptionOfferRequest clone() {
    return (UpdateSubscriptionOfferRequest) super.clone();
  }

}
