/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Represents a set of apk-level targetings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ApkTargeting extends com.google.api.client.json.GenericJson {

  /**
   * The abi that the apk targets
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AbiTargeting abiTargeting;

  /**
   * The language that the apk targets
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LanguageTargeting languageTargeting;

  /**
   * Multi-api-level targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MultiAbiTargeting multiAbiTargeting;

  /**
   * The screen density that this apk supports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ScreenDensityTargeting screenDensityTargeting;

  /**
   * The sdk version that the apk targets
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SdkVersionTargeting sdkVersionTargeting;

  /**
   * Texture-compression-format-level targeting
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextureCompressionFormatTargeting textureCompressionFormatTargeting;

  /**
   * The abi that the apk targets
   * @return value or {@code null} for none
   */
  public AbiTargeting getAbiTargeting() {
    return abiTargeting;
  }

  /**
   * The abi that the apk targets
   * @param abiTargeting abiTargeting or {@code null} for none
   */
  public ApkTargeting setAbiTargeting(AbiTargeting abiTargeting) {
    this.abiTargeting = abiTargeting;
    return this;
  }

  /**
   * The language that the apk targets
   * @return value or {@code null} for none
   */
  public LanguageTargeting getLanguageTargeting() {
    return languageTargeting;
  }

  /**
   * The language that the apk targets
   * @param languageTargeting languageTargeting or {@code null} for none
   */
  public ApkTargeting setLanguageTargeting(LanguageTargeting languageTargeting) {
    this.languageTargeting = languageTargeting;
    return this;
  }

  /**
   * Multi-api-level targeting.
   * @return value or {@code null} for none
   */
  public MultiAbiTargeting getMultiAbiTargeting() {
    return multiAbiTargeting;
  }

  /**
   * Multi-api-level targeting.
   * @param multiAbiTargeting multiAbiTargeting or {@code null} for none
   */
  public ApkTargeting setMultiAbiTargeting(MultiAbiTargeting multiAbiTargeting) {
    this.multiAbiTargeting = multiAbiTargeting;
    return this;
  }

  /**
   * The screen density that this apk supports.
   * @return value or {@code null} for none
   */
  public ScreenDensityTargeting getScreenDensityTargeting() {
    return screenDensityTargeting;
  }

  /**
   * The screen density that this apk supports.
   * @param screenDensityTargeting screenDensityTargeting or {@code null} for none
   */
  public ApkTargeting setScreenDensityTargeting(ScreenDensityTargeting screenDensityTargeting) {
    this.screenDensityTargeting = screenDensityTargeting;
    return this;
  }

  /**
   * The sdk version that the apk targets
   * @return value or {@code null} for none
   */
  public SdkVersionTargeting getSdkVersionTargeting() {
    return sdkVersionTargeting;
  }

  /**
   * The sdk version that the apk targets
   * @param sdkVersionTargeting sdkVersionTargeting or {@code null} for none
   */
  public ApkTargeting setSdkVersionTargeting(SdkVersionTargeting sdkVersionTargeting) {
    this.sdkVersionTargeting = sdkVersionTargeting;
    return this;
  }

  /**
   * Texture-compression-format-level targeting
   * @return value or {@code null} for none
   */
  public TextureCompressionFormatTargeting getTextureCompressionFormatTargeting() {
    return textureCompressionFormatTargeting;
  }

  /**
   * Texture-compression-format-level targeting
   * @param textureCompressionFormatTargeting textureCompressionFormatTargeting or {@code null} for none
   */
  public ApkTargeting setTextureCompressionFormatTargeting(TextureCompressionFormatTargeting textureCompressionFormatTargeting) {
    this.textureCompressionFormatTargeting = textureCompressionFormatTargeting;
    return this;
  }

  @Override
  public ApkTargeting set(String fieldName, Object value) {
    return (ApkTargeting) super.set(fieldName, value);
  }

  @Override
  public ApkTargeting clone() {
    return (ApkTargeting) super.clone();
  }

}
