/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Price change related information of a subscription item.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionItemPriceChangeDetails extends com.google.api.client.json.GenericJson {

  /**
   * The renewal time at which the price change will become effective for the user. This is subject
   * to change(to a future time) due to cases where the renewal time shifts like pause. This field
   * is only populated if the price change has not taken effect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expectedNewPriceChargeTime;

  /**
   * New recurring price for the subscription item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money newPrice;

  /**
   * Price change mode specifies how the subscription item price is changing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String priceChangeMode;

  /**
   * State the price change is currently in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String priceChangeState;

  /**
   * The renewal time at which the price change will become effective for the user. This is subject
   * to change(to a future time) due to cases where the renewal time shifts like pause. This field
   * is only populated if the price change has not taken effect.
   * @return value or {@code null} for none
   */
  public String getExpectedNewPriceChargeTime() {
    return expectedNewPriceChargeTime;
  }

  /**
   * The renewal time at which the price change will become effective for the user. This is subject
   * to change(to a future time) due to cases where the renewal time shifts like pause. This field
   * is only populated if the price change has not taken effect.
   * @param expectedNewPriceChargeTime expectedNewPriceChargeTime or {@code null} for none
   */
  public SubscriptionItemPriceChangeDetails setExpectedNewPriceChargeTime(String expectedNewPriceChargeTime) {
    this.expectedNewPriceChargeTime = expectedNewPriceChargeTime;
    return this;
  }

  /**
   * New recurring price for the subscription item.
   * @return value or {@code null} for none
   */
  public Money getNewPrice() {
    return newPrice;
  }

  /**
   * New recurring price for the subscription item.
   * @param newPrice newPrice or {@code null} for none
   */
  public SubscriptionItemPriceChangeDetails setNewPrice(Money newPrice) {
    this.newPrice = newPrice;
    return this;
  }

  /**
   * Price change mode specifies how the subscription item price is changing.
   * @return value or {@code null} for none
   */
  public java.lang.String getPriceChangeMode() {
    return priceChangeMode;
  }

  /**
   * Price change mode specifies how the subscription item price is changing.
   * @param priceChangeMode priceChangeMode or {@code null} for none
   */
  public SubscriptionItemPriceChangeDetails setPriceChangeMode(java.lang.String priceChangeMode) {
    this.priceChangeMode = priceChangeMode;
    return this;
  }

  /**
   * State the price change is currently in.
   * @return value or {@code null} for none
   */
  public java.lang.String getPriceChangeState() {
    return priceChangeState;
  }

  /**
   * State the price change is currently in.
   * @param priceChangeState priceChangeState or {@code null} for none
   */
  public SubscriptionItemPriceChangeDetails setPriceChangeState(java.lang.String priceChangeState) {
    this.priceChangeState = priceChangeState;
    return this;
  }

  @Override
  public SubscriptionItemPriceChangeDetails set(String fieldName, Object value) {
    return (SubscriptionItemPriceChangeDetails) super.set(fieldName, value);
  }

  @Override
  public SubscriptionItemPriceChangeDetails clone() {
    return (SubscriptionItemPriceChangeDetails) super.clone();
  }

}
