/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Details about the first time a user/device completed a transaction using external offers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExternalOfferInitialAcquisitionDetails extends com.google.api.client.json.GenericJson {

  /**
   * Required. The external transaction id of the first completed purchase made by the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalTransactionId;

  /**
   * Required. The external transaction id of the first completed purchase made by the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalTransactionId() {
    return externalTransactionId;
  }

  /**
   * Required. The external transaction id of the first completed purchase made by the user.
   * @param externalTransactionId externalTransactionId or {@code null} for none
   */
  public ExternalOfferInitialAcquisitionDetails setExternalTransactionId(java.lang.String externalTransactionId) {
    this.externalTransactionId = externalTransactionId;
    return this;
  }

  @Override
  public ExternalOfferInitialAcquisitionDetails set(String fieldName, Object value) {
    return (ExternalOfferInitialAcquisitionDetails) super.set(fieldName, value);
  }

  @Override
  public ExternalOfferInitialAcquisitionDetails clone() {
    return (ExternalOfferInitialAcquisitionDetails) super.clone();
  }

}
