/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Variant is a group of APKs that covers a part of the device configuration space. APKs from
 * multiple variants are never combined on one device.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SplitApkVariant extends com.google.api.client.json.GenericJson {

  /**
   * Set of APKs, one set per module.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ApkSet> apkSet;

  static {
    // hack to force ProGuard to consider ApkSet used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ApkSet.class);
  }

  /**
   * Variant-level targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VariantTargeting targeting;

  /**
   * Number of the variant, starting at 0 (unless overridden). A device will receive APKs from the
   * first variant that matches the device configuration, with higher variant numbers having
   * priority over lower variant numbers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer variantNumber;

  /**
   * Set of APKs, one set per module.
   * @return value or {@code null} for none
   */
  public java.util.List<ApkSet> getApkSet() {
    return apkSet;
  }

  /**
   * Set of APKs, one set per module.
   * @param apkSet apkSet or {@code null} for none
   */
  public SplitApkVariant setApkSet(java.util.List<ApkSet> apkSet) {
    this.apkSet = apkSet;
    return this;
  }

  /**
   * Variant-level targeting.
   * @return value or {@code null} for none
   */
  public VariantTargeting getTargeting() {
    return targeting;
  }

  /**
   * Variant-level targeting.
   * @param targeting targeting or {@code null} for none
   */
  public SplitApkVariant setTargeting(VariantTargeting targeting) {
    this.targeting = targeting;
    return this;
  }

  /**
   * Number of the variant, starting at 0 (unless overridden). A device will receive APKs from the
   * first variant that matches the device configuration, with higher variant numbers having
   * priority over lower variant numbers.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVariantNumber() {
    return variantNumber;
  }

  /**
   * Number of the variant, starting at 0 (unless overridden). A device will receive APKs from the
   * first variant that matches the device configuration, with higher variant numbers having
   * priority over lower variant numbers.
   * @param variantNumber variantNumber or {@code null} for none
   */
  public SplitApkVariant setVariantNumber(java.lang.Integer variantNumber) {
    this.variantNumber = variantNumber;
    return this;
  }

  @Override
  public SplitApkVariant set(String fieldName, Object value) {
    return (SplitApkVariant) super.set(fieldName, value);
  }

  @Override
  public SplitApkVariant clone() {
    return (SplitApkVariant) super.clone();
  }

}
