/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.androidpublisher;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UriTemplate;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.androidpublisher.AndroidPublisherRequest;
import com.google.api.services.androidpublisher.AndroidPublisherRequestInitializer;
import com.google.api.services.androidpublisher.model.ActivateBasePlanRequest;
import com.google.api.services.androidpublisher.model.ActivateSubscriptionOfferRequest;
import com.google.api.services.androidpublisher.model.AddTargetingRequest;
import com.google.api.services.androidpublisher.model.AddTargetingResponse;
import com.google.api.services.androidpublisher.model.Apk;
import com.google.api.services.androidpublisher.model.ApksAddExternallyHostedRequest;
import com.google.api.services.androidpublisher.model.ApksAddExternallyHostedResponse;
import com.google.api.services.androidpublisher.model.ApksListResponse;
import com.google.api.services.androidpublisher.model.AppDetails;
import com.google.api.services.androidpublisher.model.AppEdit;
import com.google.api.services.androidpublisher.model.AppRecoveryAction;
import com.google.api.services.androidpublisher.model.ArchiveSubscriptionRequest;
import com.google.api.services.androidpublisher.model.BatchGetSubscriptionOffersRequest;
import com.google.api.services.androidpublisher.model.BatchGetSubscriptionOffersResponse;
import com.google.api.services.androidpublisher.model.BatchGetSubscriptionsResponse;
import com.google.api.services.androidpublisher.model.BatchMigrateBasePlanPricesRequest;
import com.google.api.services.androidpublisher.model.BatchMigrateBasePlanPricesResponse;
import com.google.api.services.androidpublisher.model.BatchUpdateBasePlanStatesRequest;
import com.google.api.services.androidpublisher.model.BatchUpdateBasePlanStatesResponse;
import com.google.api.services.androidpublisher.model.BatchUpdateSubscriptionOfferStatesRequest;
import com.google.api.services.androidpublisher.model.BatchUpdateSubscriptionOfferStatesResponse;
import com.google.api.services.androidpublisher.model.BatchUpdateSubscriptionOffersRequest;
import com.google.api.services.androidpublisher.model.BatchUpdateSubscriptionOffersResponse;
import com.google.api.services.androidpublisher.model.BatchUpdateSubscriptionsRequest;
import com.google.api.services.androidpublisher.model.BatchUpdateSubscriptionsResponse;
import com.google.api.services.androidpublisher.model.Bundle;
import com.google.api.services.androidpublisher.model.BundlesListResponse;
import com.google.api.services.androidpublisher.model.CancelAppRecoveryRequest;
import com.google.api.services.androidpublisher.model.CancelAppRecoveryResponse;
import com.google.api.services.androidpublisher.model.ConvertRegionPricesRequest;
import com.google.api.services.androidpublisher.model.ConvertRegionPricesResponse;
import com.google.api.services.androidpublisher.model.CreateDraftAppRecoveryRequest;
import com.google.api.services.androidpublisher.model.DeactivateBasePlanRequest;
import com.google.api.services.androidpublisher.model.DeactivateSubscriptionOfferRequest;
import com.google.api.services.androidpublisher.model.DeobfuscationFilesUploadResponse;
import com.google.api.services.androidpublisher.model.DeployAppRecoveryRequest;
import com.google.api.services.androidpublisher.model.DeployAppRecoveryResponse;
import com.google.api.services.androidpublisher.model.DeviceTierConfig;
import com.google.api.services.androidpublisher.model.ExpansionFile;
import com.google.api.services.androidpublisher.model.ExpansionFilesUploadResponse;
import com.google.api.services.androidpublisher.model.ExternalTransaction;
import com.google.api.services.androidpublisher.model.GeneratedApksListResponse;
import com.google.api.services.androidpublisher.model.Grant;
import com.google.api.services.androidpublisher.model.ImagesDeleteAllResponse;
import com.google.api.services.androidpublisher.model.ImagesListResponse;
import com.google.api.services.androidpublisher.model.ImagesUploadResponse;
import com.google.api.services.androidpublisher.model.InAppProduct;
import com.google.api.services.androidpublisher.model.InappproductsBatchDeleteRequest;
import com.google.api.services.androidpublisher.model.InappproductsBatchGetResponse;
import com.google.api.services.androidpublisher.model.InappproductsBatchUpdateRequest;
import com.google.api.services.androidpublisher.model.InappproductsBatchUpdateResponse;
import com.google.api.services.androidpublisher.model.InappproductsListResponse;
import com.google.api.services.androidpublisher.model.InternalAppSharingArtifact;
import com.google.api.services.androidpublisher.model.ListAppRecoveriesResponse;
import com.google.api.services.androidpublisher.model.ListDeviceTierConfigsResponse;
import com.google.api.services.androidpublisher.model.ListSubscriptionOffersResponse;
import com.google.api.services.androidpublisher.model.ListSubscriptionsResponse;
import com.google.api.services.androidpublisher.model.ListUsersResponse;
import com.google.api.services.androidpublisher.model.Listing;
import com.google.api.services.androidpublisher.model.ListingsListResponse;
import com.google.api.services.androidpublisher.model.MigrateBasePlanPricesRequest;
import com.google.api.services.androidpublisher.model.MigrateBasePlanPricesResponse;
import com.google.api.services.androidpublisher.model.ProductPurchase;
import com.google.api.services.androidpublisher.model.ProductPurchasesAcknowledgeRequest;
import com.google.api.services.androidpublisher.model.RefundExternalTransactionRequest;
import com.google.api.services.androidpublisher.model.Review;
import com.google.api.services.androidpublisher.model.ReviewsListResponse;
import com.google.api.services.androidpublisher.model.ReviewsReplyRequest;
import com.google.api.services.androidpublisher.model.ReviewsReplyResponse;
import com.google.api.services.androidpublisher.model.RevokeSubscriptionPurchaseRequest;
import com.google.api.services.androidpublisher.model.RevokeSubscriptionPurchaseResponse;
import com.google.api.services.androidpublisher.model.SafetyLabelsUpdateRequest;
import com.google.api.services.androidpublisher.model.SafetyLabelsUpdateResponse;
import com.google.api.services.androidpublisher.model.Subscription;
import com.google.api.services.androidpublisher.model.SubscriptionOffer;
import com.google.api.services.androidpublisher.model.SubscriptionPurchase;
import com.google.api.services.androidpublisher.model.SubscriptionPurchaseV2;
import com.google.api.services.androidpublisher.model.SubscriptionPurchasesAcknowledgeRequest;
import com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferRequest;
import com.google.api.services.androidpublisher.model.SubscriptionPurchasesDeferResponse;
import com.google.api.services.androidpublisher.model.SystemApksListResponse;
import com.google.api.services.androidpublisher.model.Testers;
import com.google.api.services.androidpublisher.model.Track;
import com.google.api.services.androidpublisher.model.TrackConfig;
import com.google.api.services.androidpublisher.model.TrackCountryAvailability;
import com.google.api.services.androidpublisher.model.TracksListResponse;
import com.google.api.services.androidpublisher.model.User;
import com.google.api.services.androidpublisher.model.Variant;
import com.google.api.services.androidpublisher.model.VoidedPurchasesListResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Pattern;

public class AndroidPublisher
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://androidpublisher.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://androidpublisher.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://androidpublisher.googleapis.com/";

    public AndroidPublisher(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    AndroidPublisher(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Applications applications() {
        return new Applications();
    }

    public Apprecovery apprecovery() {
        return new Apprecovery();
    }

    public Edits edits() {
        return new Edits();
    }

    public Externaltransactions externaltransactions() {
        return new Externaltransactions();
    }

    public Generatedapks generatedapks() {
        return new Generatedapks();
    }

    public Grants grants() {
        return new Grants();
    }

    public Inappproducts inappproducts() {
        return new Inappproducts();
    }

    public Internalappsharingartifacts internalappsharingartifacts() {
        return new Internalappsharingartifacts();
    }

    public Monetization monetization() {
        return new Monetization();
    }

    public Orders orders() {
        return new Orders();
    }

    public Purchases purchases() {
        return new Purchases();
    }

    public Reviews reviews() {
        return new Reviews();
    }

    public Systemapks systemapks() {
        return new Systemapks();
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Google Play Android Developer API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return AndroidPublisher.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://androidpublisher.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), AndroidPublisher.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(AndroidPublisher.DEFAULT_BATCH_PATH);
        }

        public AndroidPublisher build() {
            return new AndroidPublisher(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setAndroidPublisherRequestInitializer(AndroidPublisherRequestInitializer androidpublisherRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)androidpublisherRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Users {
        public Create create(String parent, User content) throws IOException {
            Create result = new Create(parent, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String parent) throws IOException {
            List result = new List(parent);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, User content) throws IOException {
            Patch result = new Patch(name, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends AndroidPublisherRequest<User> {
            private static final String REST_PATH = "androidpublisher/v3/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected Patch(String name, User content) {
                super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, User.class);
                this.NAME_PATTERN = Pattern.compile("^developers/[^/]+/users/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^developers/[^/]+/users/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^developers/[^/]+/users/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends AndroidPublisherRequest<ListUsersResponse> {
            private static final String REST_PATH = "androidpublisher/v3/{+parent}/users";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String parent) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, ListUsersResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^developers/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^developers/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^developers/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Delete
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "androidpublisher/v3/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                this.NAME_PATTERN = Pattern.compile("^developers/[^/]+/users/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^developers/[^/]+/users/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^developers/[^/]+/users/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends AndroidPublisherRequest<User> {
            private static final String REST_PATH = "androidpublisher/v3/{+parent}/users";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected Create(String parent, User content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, User.class);
                this.PARENT_PATTERN = Pattern.compile("^developers/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^developers/[^/]+$");
                }
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public Create setParent(String parent) {
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^developers/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Systemapks {
        public Variants variants() {
            return new Variants();
        }

        public class Variants {
            public Create create(String packageName, Long versionCode, Variant content) throws IOException {
                Create result = new Create(packageName, versionCode, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Download download(String packageName, Long versionCode, Long variantId) throws IOException {
                Download result = new Download(packageName, versionCode, variantId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String packageName, Long versionCode, Long variantId) throws IOException {
                Get result = new Get(packageName, versionCode, variantId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String packageName, Long versionCode) throws IOException {
                List result = new List(packageName, versionCode);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AndroidPublisherRequest<SystemApksListResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/systemApks/{versionCode}/variants";
                @Key
                private String packageName;
                @Key
                private Long versionCode;

                protected List(String packageName, Long versionCode) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, SystemApksListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.versionCode = (Long)Preconditions.checkNotNull((Object)versionCode, (Object)"Required parameter versionCode must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public Long getVersionCode() {
                    return this.versionCode;
                }

                public List setVersionCode(Long versionCode) {
                    this.versionCode = versionCode;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<Variant> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/systemApks/{versionCode}/variants/{variantId}";
                @Key
                private String packageName;
                @Key
                private Long versionCode;
                @Key
                private Long variantId;

                protected Get(String packageName, Long versionCode, Long variantId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, Variant.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.versionCode = (Long)Preconditions.checkNotNull((Object)versionCode, (Object)"Required parameter versionCode must be specified.");
                    this.variantId = (Long)Preconditions.checkNotNull((Object)variantId, (Object)"Required parameter variantId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public Long getVersionCode() {
                    return this.versionCode;
                }

                public Get setVersionCode(Long versionCode) {
                    this.versionCode = versionCode;
                    return this;
                }

                public Long getVariantId() {
                    return this.variantId;
                }

                public Get setVariantId(Long variantId) {
                    this.variantId = variantId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Download
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/systemApks/{versionCode}/variants/{variantId}:download";
                @Key
                private String packageName;
                @Key
                private Long versionCode;
                @Key
                private Long variantId;

                protected Download(String packageName, Long versionCode, Long variantId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.versionCode = (Long)Preconditions.checkNotNull((Object)versionCode, (Object)"Required parameter versionCode must be specified.");
                    this.variantId = (Long)Preconditions.checkNotNull((Object)variantId, (Object)"Required parameter variantId must be specified.");
                    this.initializeMediaDownload();
                }

                public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                    super.executeMediaAndDownloadTo(outputStream);
                }

                public InputStream executeMediaAsInputStream() throws IOException {
                    return super.executeMediaAsInputStream();
                }

                public HttpResponse executeMedia() throws IOException {
                    return super.executeMedia();
                }

                public GenericUrl buildHttpRequestUrl() {
                    String baseUrl = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? AndroidPublisher.this.getRootUrl() + "download/" + AndroidPublisher.this.getServicePath() : AndroidPublisher.this.getBaseUrl();
                    return new GenericUrl(UriTemplate.expand((String)baseUrl, (String)this.getUriTemplate(), (Object)((Object)this), (boolean)true));
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Download set$Xgafv(String $Xgafv) {
                    return (Download)super.set$Xgafv($Xgafv);
                }

                public Download setAccessToken(String accessToken) {
                    return (Download)super.setAccessToken(accessToken);
                }

                public Download setAlt(String alt) {
                    return (Download)super.setAlt(alt);
                }

                public Download setCallback(String callback) {
                    return (Download)super.setCallback(callback);
                }

                public Download setFields(String fields) {
                    return (Download)super.setFields(fields);
                }

                public Download setKey(String key) {
                    return (Download)super.setKey(key);
                }

                public Download setOauthToken(String oauthToken) {
                    return (Download)super.setOauthToken(oauthToken);
                }

                public Download setPrettyPrint(Boolean prettyPrint) {
                    return (Download)super.setPrettyPrint(prettyPrint);
                }

                public Download setQuotaUser(String quotaUser) {
                    return (Download)super.setQuotaUser(quotaUser);
                }

                public Download setUploadType(String uploadType) {
                    return (Download)super.setUploadType(uploadType);
                }

                public Download setUploadProtocol(String uploadProtocol) {
                    return (Download)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Download setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public Long getVersionCode() {
                    return this.versionCode;
                }

                public Download setVersionCode(Long versionCode) {
                    this.versionCode = versionCode;
                    return this;
                }

                public Long getVariantId() {
                    return this.variantId;
                }

                public Download setVariantId(Long variantId) {
                    this.variantId = variantId;
                    return this;
                }

                @Override
                public Download set(String parameterName, Object value) {
                    return (Download)super.set(parameterName, value);
                }
            }

            public class Create
            extends AndroidPublisherRequest<Variant> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/systemApks/{versionCode}/variants";
                @Key
                private String packageName;
                @Key
                private Long versionCode;

                protected Create(String packageName, Long versionCode, Variant content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, Variant.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.versionCode = (Long)Preconditions.checkNotNull((Object)versionCode, (Object)"Required parameter versionCode must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Create setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public Long getVersionCode() {
                    return this.versionCode;
                }

                public Create setVersionCode(Long versionCode) {
                    this.versionCode = versionCode;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }
    }

    public class Reviews {
        public Get get(String packageName, String reviewId) throws IOException {
            Get result = new Get(packageName, reviewId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String packageName) throws IOException {
            List result = new List(packageName);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Reply reply(String packageName, String reviewId, ReviewsReplyRequest content) throws IOException {
            Reply result = new Reply(packageName, reviewId, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Reply
        extends AndroidPublisherRequest<ReviewsReplyResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/reviews/{reviewId}:reply";
            @Key
            private String packageName;
            @Key
            private String reviewId;

            protected Reply(String packageName, String reviewId, ReviewsReplyRequest content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, ReviewsReplyResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.reviewId = (String)Preconditions.checkNotNull((Object)reviewId, (Object)"Required parameter reviewId must be specified.");
            }

            public Reply set$Xgafv(String $Xgafv) {
                return (Reply)super.set$Xgafv($Xgafv);
            }

            public Reply setAccessToken(String accessToken) {
                return (Reply)super.setAccessToken(accessToken);
            }

            public Reply setAlt(String alt) {
                return (Reply)super.setAlt(alt);
            }

            public Reply setCallback(String callback) {
                return (Reply)super.setCallback(callback);
            }

            public Reply setFields(String fields) {
                return (Reply)super.setFields(fields);
            }

            public Reply setKey(String key) {
                return (Reply)super.setKey(key);
            }

            public Reply setOauthToken(String oauthToken) {
                return (Reply)super.setOauthToken(oauthToken);
            }

            public Reply setPrettyPrint(Boolean prettyPrint) {
                return (Reply)super.setPrettyPrint(prettyPrint);
            }

            public Reply setQuotaUser(String quotaUser) {
                return (Reply)super.setQuotaUser(quotaUser);
            }

            public Reply setUploadType(String uploadType) {
                return (Reply)super.setUploadType(uploadType);
            }

            public Reply setUploadProtocol(String uploadProtocol) {
                return (Reply)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Reply setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getReviewId() {
                return this.reviewId;
            }

            public Reply setReviewId(String reviewId) {
                this.reviewId = reviewId;
                return this;
            }

            @Override
            public Reply set(String parameterName, Object value) {
                return (Reply)super.set(parameterName, value);
            }
        }

        public class List
        extends AndroidPublisherRequest<ReviewsListResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/reviews";
            @Key
            private String packageName;
            @Key
            private Long maxResults;
            @Key
            private Long startIndex;
            @Key
            private String token;
            @Key
            private String translationLanguage;

            protected List(String packageName) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, ReviewsListResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public List setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Long getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(Long startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            public String getToken() {
                return this.token;
            }

            public List setToken(String token) {
                this.token = token;
                return this;
            }

            public String getTranslationLanguage() {
                return this.translationLanguage;
            }

            public List setTranslationLanguage(String translationLanguage) {
                this.translationLanguage = translationLanguage;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends AndroidPublisherRequest<Review> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/reviews/{reviewId}";
            @Key
            private String packageName;
            @Key
            private String reviewId;
            @Key
            private String translationLanguage;

            protected Get(String packageName, String reviewId) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, Review.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.reviewId = (String)Preconditions.checkNotNull((Object)reviewId, (Object)"Required parameter reviewId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getReviewId() {
                return this.reviewId;
            }

            public Get setReviewId(String reviewId) {
                this.reviewId = reviewId;
                return this;
            }

            public String getTranslationLanguage() {
                return this.translationLanguage;
            }

            public Get setTranslationLanguage(String translationLanguage) {
                this.translationLanguage = translationLanguage;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Purchases {
        public Products products() {
            return new Products();
        }

        public Subscriptions subscriptions() {
            return new Subscriptions();
        }

        public Subscriptionsv2 subscriptionsv2() {
            return new Subscriptionsv2();
        }

        public Voidedpurchases voidedpurchases() {
            return new Voidedpurchases();
        }

        public class Voidedpurchases {
            public List list(String packageName) throws IOException {
                List result = new List(packageName);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AndroidPublisherRequest<VoidedPurchasesListResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/voidedpurchases";
                @Key
                private String packageName;
                @Key
                private Long endTime;
                @Key
                private Boolean includeQuantityBasedPartialRefund;
                @Key
                private Long maxResults;
                @Key
                private Long startIndex;
                @Key
                private Long startTime;
                @Key
                private String token;
                @Key
                private Integer type;

                protected List(String packageName) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, VoidedPurchasesListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public Long getEndTime() {
                    return this.endTime;
                }

                public List setEndTime(Long endTime) {
                    this.endTime = endTime;
                    return this;
                }

                public Boolean getIncludeQuantityBasedPartialRefund() {
                    return this.includeQuantityBasedPartialRefund;
                }

                public List setIncludeQuantityBasedPartialRefund(Boolean includeQuantityBasedPartialRefund) {
                    this.includeQuantityBasedPartialRefund = includeQuantityBasedPartialRefund;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Long getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Long startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                public Long getStartTime() {
                    return this.startTime;
                }

                public List setStartTime(Long startTime) {
                    this.startTime = startTime;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public List setToken(String token) {
                    this.token = token;
                    return this;
                }

                public Integer getType() {
                    return this.type;
                }

                public List setType(Integer type) {
                    this.type = type;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Subscriptionsv2 {
            public Get get(String packageName, String token) throws IOException {
                Get result = new Get(packageName, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Revoke revoke(String packageName, String token, RevokeSubscriptionPurchaseRequest content) throws IOException {
                Revoke result = new Revoke(packageName, token, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Revoke
            extends AndroidPublisherRequest<RevokeSubscriptionPurchaseResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptionsv2/tokens/{token}:revoke";
                @Key
                private String packageName;
                @Key
                private String token;

                protected Revoke(String packageName, String token, RevokeSubscriptionPurchaseRequest content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, RevokeSubscriptionPurchaseResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Revoke set$Xgafv(String $Xgafv) {
                    return (Revoke)super.set$Xgafv($Xgafv);
                }

                public Revoke setAccessToken(String accessToken) {
                    return (Revoke)super.setAccessToken(accessToken);
                }

                public Revoke setAlt(String alt) {
                    return (Revoke)super.setAlt(alt);
                }

                public Revoke setCallback(String callback) {
                    return (Revoke)super.setCallback(callback);
                }

                public Revoke setFields(String fields) {
                    return (Revoke)super.setFields(fields);
                }

                public Revoke setKey(String key) {
                    return (Revoke)super.setKey(key);
                }

                public Revoke setOauthToken(String oauthToken) {
                    return (Revoke)super.setOauthToken(oauthToken);
                }

                public Revoke setPrettyPrint(Boolean prettyPrint) {
                    return (Revoke)super.setPrettyPrint(prettyPrint);
                }

                public Revoke setQuotaUser(String quotaUser) {
                    return (Revoke)super.setQuotaUser(quotaUser);
                }

                public Revoke setUploadType(String uploadType) {
                    return (Revoke)super.setUploadType(uploadType);
                }

                public Revoke setUploadProtocol(String uploadProtocol) {
                    return (Revoke)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Revoke setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Revoke setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Revoke set(String parameterName, Object value) {
                    return (Revoke)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<SubscriptionPurchaseV2> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptionsv2/tokens/{token}";
                @Key
                private String packageName;
                @Key
                private String token;

                protected Get(String packageName, String token) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, SubscriptionPurchaseV2.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Get setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Subscriptions {
            public Acknowledge acknowledge(String packageName, String subscriptionId, String token, SubscriptionPurchasesAcknowledgeRequest content) throws IOException {
                Acknowledge result = new Acknowledge(packageName, subscriptionId, token, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Cancel cancel(String packageName, String subscriptionId, String token) throws IOException {
                Cancel result = new Cancel(packageName, subscriptionId, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Defer defer(String packageName, String subscriptionId, String token, SubscriptionPurchasesDeferRequest content) throws IOException {
                Defer result = new Defer(packageName, subscriptionId, token, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String packageName, String subscriptionId, String token) throws IOException {
                Get result = new Get(packageName, subscriptionId, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Refund refund(String packageName, String subscriptionId, String token) throws IOException {
                Refund result = new Refund(packageName, subscriptionId, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Revoke revoke(String packageName, String subscriptionId, String token) throws IOException {
                Revoke result = new Revoke(packageName, subscriptionId, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Revoke
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:revoke";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Revoke(String packageName, String subscriptionId, String token) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Revoke set$Xgafv(String $Xgafv) {
                    return (Revoke)super.set$Xgafv($Xgafv);
                }

                public Revoke setAccessToken(String accessToken) {
                    return (Revoke)super.setAccessToken(accessToken);
                }

                public Revoke setAlt(String alt) {
                    return (Revoke)super.setAlt(alt);
                }

                public Revoke setCallback(String callback) {
                    return (Revoke)super.setCallback(callback);
                }

                public Revoke setFields(String fields) {
                    return (Revoke)super.setFields(fields);
                }

                public Revoke setKey(String key) {
                    return (Revoke)super.setKey(key);
                }

                public Revoke setOauthToken(String oauthToken) {
                    return (Revoke)super.setOauthToken(oauthToken);
                }

                public Revoke setPrettyPrint(Boolean prettyPrint) {
                    return (Revoke)super.setPrettyPrint(prettyPrint);
                }

                public Revoke setQuotaUser(String quotaUser) {
                    return (Revoke)super.setQuotaUser(quotaUser);
                }

                public Revoke setUploadType(String uploadType) {
                    return (Revoke)super.setUploadType(uploadType);
                }

                public Revoke setUploadProtocol(String uploadProtocol) {
                    return (Revoke)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Revoke setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Revoke setSubscriptionId(String subscriptionId) {
                    this.subscriptionId = subscriptionId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Revoke setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Revoke set(String parameterName, Object value) {
                    return (Revoke)super.set(parameterName, value);
                }
            }

            public class Refund
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:refund";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Refund(String packageName, String subscriptionId, String token) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Refund set$Xgafv(String $Xgafv) {
                    return (Refund)super.set$Xgafv($Xgafv);
                }

                public Refund setAccessToken(String accessToken) {
                    return (Refund)super.setAccessToken(accessToken);
                }

                public Refund setAlt(String alt) {
                    return (Refund)super.setAlt(alt);
                }

                public Refund setCallback(String callback) {
                    return (Refund)super.setCallback(callback);
                }

                public Refund setFields(String fields) {
                    return (Refund)super.setFields(fields);
                }

                public Refund setKey(String key) {
                    return (Refund)super.setKey(key);
                }

                public Refund setOauthToken(String oauthToken) {
                    return (Refund)super.setOauthToken(oauthToken);
                }

                public Refund setPrettyPrint(Boolean prettyPrint) {
                    return (Refund)super.setPrettyPrint(prettyPrint);
                }

                public Refund setQuotaUser(String quotaUser) {
                    return (Refund)super.setQuotaUser(quotaUser);
                }

                public Refund setUploadType(String uploadType) {
                    return (Refund)super.setUploadType(uploadType);
                }

                public Refund setUploadProtocol(String uploadProtocol) {
                    return (Refund)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Refund setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Refund setSubscriptionId(String subscriptionId) {
                    this.subscriptionId = subscriptionId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Refund setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Refund set(String parameterName, Object value) {
                    return (Refund)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<SubscriptionPurchase> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Get(String packageName, String subscriptionId, String token) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, SubscriptionPurchase.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Get setSubscriptionId(String subscriptionId) {
                    this.subscriptionId = subscriptionId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Get setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Defer
            extends AndroidPublisherRequest<SubscriptionPurchasesDeferResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:defer";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Defer(String packageName, String subscriptionId, String token, SubscriptionPurchasesDeferRequest content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, SubscriptionPurchasesDeferResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Defer set$Xgafv(String $Xgafv) {
                    return (Defer)super.set$Xgafv($Xgafv);
                }

                public Defer setAccessToken(String accessToken) {
                    return (Defer)super.setAccessToken(accessToken);
                }

                public Defer setAlt(String alt) {
                    return (Defer)super.setAlt(alt);
                }

                public Defer setCallback(String callback) {
                    return (Defer)super.setCallback(callback);
                }

                public Defer setFields(String fields) {
                    return (Defer)super.setFields(fields);
                }

                public Defer setKey(String key) {
                    return (Defer)super.setKey(key);
                }

                public Defer setOauthToken(String oauthToken) {
                    return (Defer)super.setOauthToken(oauthToken);
                }

                public Defer setPrettyPrint(Boolean prettyPrint) {
                    return (Defer)super.setPrettyPrint(prettyPrint);
                }

                public Defer setQuotaUser(String quotaUser) {
                    return (Defer)super.setQuotaUser(quotaUser);
                }

                public Defer setUploadType(String uploadType) {
                    return (Defer)super.setUploadType(uploadType);
                }

                public Defer setUploadProtocol(String uploadProtocol) {
                    return (Defer)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Defer setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Defer setSubscriptionId(String subscriptionId) {
                    this.subscriptionId = subscriptionId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Defer setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Defer set(String parameterName, Object value) {
                    return (Defer)super.set(parameterName, value);
                }
            }

            public class Cancel
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:cancel";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Cancel(String packageName, String subscriptionId, String token) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Cancel set$Xgafv(String $Xgafv) {
                    return (Cancel)super.set$Xgafv($Xgafv);
                }

                public Cancel setAccessToken(String accessToken) {
                    return (Cancel)super.setAccessToken(accessToken);
                }

                public Cancel setAlt(String alt) {
                    return (Cancel)super.setAlt(alt);
                }

                public Cancel setCallback(String callback) {
                    return (Cancel)super.setCallback(callback);
                }

                public Cancel setFields(String fields) {
                    return (Cancel)super.setFields(fields);
                }

                public Cancel setKey(String key) {
                    return (Cancel)super.setKey(key);
                }

                public Cancel setOauthToken(String oauthToken) {
                    return (Cancel)super.setOauthToken(oauthToken);
                }

                public Cancel setPrettyPrint(Boolean prettyPrint) {
                    return (Cancel)super.setPrettyPrint(prettyPrint);
                }

                public Cancel setQuotaUser(String quotaUser) {
                    return (Cancel)super.setQuotaUser(quotaUser);
                }

                public Cancel setUploadType(String uploadType) {
                    return (Cancel)super.setUploadType(uploadType);
                }

                public Cancel setUploadProtocol(String uploadProtocol) {
                    return (Cancel)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Cancel setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Cancel setSubscriptionId(String subscriptionId) {
                    this.subscriptionId = subscriptionId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Cancel setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Cancel set(String parameterName, Object value) {
                    return (Cancel)super.set(parameterName, value);
                }
            }

            public class Acknowledge
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:acknowledge";
                @Key
                private String packageName;
                @Key
                private String subscriptionId;
                @Key
                private String token;

                protected Acknowledge(String packageName, String subscriptionId, String token, SubscriptionPurchasesAcknowledgeRequest content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.subscriptionId = (String)Preconditions.checkNotNull((Object)subscriptionId, (Object)"Required parameter subscriptionId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Acknowledge set$Xgafv(String $Xgafv) {
                    return (Acknowledge)super.set$Xgafv($Xgafv);
                }

                public Acknowledge setAccessToken(String accessToken) {
                    return (Acknowledge)super.setAccessToken(accessToken);
                }

                public Acknowledge setAlt(String alt) {
                    return (Acknowledge)super.setAlt(alt);
                }

                public Acknowledge setCallback(String callback) {
                    return (Acknowledge)super.setCallback(callback);
                }

                public Acknowledge setFields(String fields) {
                    return (Acknowledge)super.setFields(fields);
                }

                public Acknowledge setKey(String key) {
                    return (Acknowledge)super.setKey(key);
                }

                public Acknowledge setOauthToken(String oauthToken) {
                    return (Acknowledge)super.setOauthToken(oauthToken);
                }

                public Acknowledge setPrettyPrint(Boolean prettyPrint) {
                    return (Acknowledge)super.setPrettyPrint(prettyPrint);
                }

                public Acknowledge setQuotaUser(String quotaUser) {
                    return (Acknowledge)super.setQuotaUser(quotaUser);
                }

                public Acknowledge setUploadType(String uploadType) {
                    return (Acknowledge)super.setUploadType(uploadType);
                }

                public Acknowledge setUploadProtocol(String uploadProtocol) {
                    return (Acknowledge)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Acknowledge setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getSubscriptionId() {
                    return this.subscriptionId;
                }

                public Acknowledge setSubscriptionId(String subscriptionId) {
                    this.subscriptionId = subscriptionId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Acknowledge setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Acknowledge set(String parameterName, Object value) {
                    return (Acknowledge)super.set(parameterName, value);
                }
            }
        }

        public class Products {
            public Acknowledge acknowledge(String packageName, String productId, String token, ProductPurchasesAcknowledgeRequest content) throws IOException {
                Acknowledge result = new Acknowledge(packageName, productId, token, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Consume consume(String packageName, String productId, String token) throws IOException {
                Consume result = new Consume(packageName, productId, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String packageName, String productId, String token) throws IOException {
                Get result = new Get(packageName, productId, token);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends AndroidPublisherRequest<ProductPurchase> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}";
                @Key
                private String packageName;
                @Key
                private String productId;
                @Key
                private String token;

                protected Get(String packageName, String productId, String token) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ProductPurchase.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public Get setProductId(String productId) {
                    this.productId = productId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Get setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Consume
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}:consume";
                @Key
                private String packageName;
                @Key
                private String productId;
                @Key
                private String token;

                protected Consume(String packageName, String productId, String token) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Consume set$Xgafv(String $Xgafv) {
                    return (Consume)super.set$Xgafv($Xgafv);
                }

                public Consume setAccessToken(String accessToken) {
                    return (Consume)super.setAccessToken(accessToken);
                }

                public Consume setAlt(String alt) {
                    return (Consume)super.setAlt(alt);
                }

                public Consume setCallback(String callback) {
                    return (Consume)super.setCallback(callback);
                }

                public Consume setFields(String fields) {
                    return (Consume)super.setFields(fields);
                }

                public Consume setKey(String key) {
                    return (Consume)super.setKey(key);
                }

                public Consume setOauthToken(String oauthToken) {
                    return (Consume)super.setOauthToken(oauthToken);
                }

                public Consume setPrettyPrint(Boolean prettyPrint) {
                    return (Consume)super.setPrettyPrint(prettyPrint);
                }

                public Consume setQuotaUser(String quotaUser) {
                    return (Consume)super.setQuotaUser(quotaUser);
                }

                public Consume setUploadType(String uploadType) {
                    return (Consume)super.setUploadType(uploadType);
                }

                public Consume setUploadProtocol(String uploadProtocol) {
                    return (Consume)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Consume setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public Consume setProductId(String productId) {
                    this.productId = productId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Consume setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Consume set(String parameterName, Object value) {
                    return (Consume)super.set(parameterName, value);
                }
            }

            public class Acknowledge
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}:acknowledge";
                @Key
                private String packageName;
                @Key
                private String productId;
                @Key
                private String token;

                protected Acknowledge(String packageName, String productId, String token, ProductPurchasesAcknowledgeRequest content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                    this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"Required parameter token must be specified.");
                }

                public Acknowledge set$Xgafv(String $Xgafv) {
                    return (Acknowledge)super.set$Xgafv($Xgafv);
                }

                public Acknowledge setAccessToken(String accessToken) {
                    return (Acknowledge)super.setAccessToken(accessToken);
                }

                public Acknowledge setAlt(String alt) {
                    return (Acknowledge)super.setAlt(alt);
                }

                public Acknowledge setCallback(String callback) {
                    return (Acknowledge)super.setCallback(callback);
                }

                public Acknowledge setFields(String fields) {
                    return (Acknowledge)super.setFields(fields);
                }

                public Acknowledge setKey(String key) {
                    return (Acknowledge)super.setKey(key);
                }

                public Acknowledge setOauthToken(String oauthToken) {
                    return (Acknowledge)super.setOauthToken(oauthToken);
                }

                public Acknowledge setPrettyPrint(Boolean prettyPrint) {
                    return (Acknowledge)super.setPrettyPrint(prettyPrint);
                }

                public Acknowledge setQuotaUser(String quotaUser) {
                    return (Acknowledge)super.setQuotaUser(quotaUser);
                }

                public Acknowledge setUploadType(String uploadType) {
                    return (Acknowledge)super.setUploadType(uploadType);
                }

                public Acknowledge setUploadProtocol(String uploadProtocol) {
                    return (Acknowledge)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Acknowledge setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public Acknowledge setProductId(String productId) {
                    this.productId = productId;
                    return this;
                }

                public String getToken() {
                    return this.token;
                }

                public Acknowledge setToken(String token) {
                    this.token = token;
                    return this;
                }

                @Override
                public Acknowledge set(String parameterName, Object value) {
                    return (Acknowledge)super.set(parameterName, value);
                }
            }
        }
    }

    public class Orders {
        public Refund refund(String packageName, String orderId) throws IOException {
            Refund result = new Refund(packageName, orderId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Refund
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/orders/{orderId}:refund";
            @Key
            private String packageName;
            @Key
            private String orderId;
            @Key
            private Boolean revoke;

            protected Refund(String packageName, String orderId) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Refund set$Xgafv(String $Xgafv) {
                return (Refund)super.set$Xgafv($Xgafv);
            }

            public Refund setAccessToken(String accessToken) {
                return (Refund)super.setAccessToken(accessToken);
            }

            public Refund setAlt(String alt) {
                return (Refund)super.setAlt(alt);
            }

            public Refund setCallback(String callback) {
                return (Refund)super.setCallback(callback);
            }

            public Refund setFields(String fields) {
                return (Refund)super.setFields(fields);
            }

            public Refund setKey(String key) {
                return (Refund)super.setKey(key);
            }

            public Refund setOauthToken(String oauthToken) {
                return (Refund)super.setOauthToken(oauthToken);
            }

            public Refund setPrettyPrint(Boolean prettyPrint) {
                return (Refund)super.setPrettyPrint(prettyPrint);
            }

            public Refund setQuotaUser(String quotaUser) {
                return (Refund)super.setQuotaUser(quotaUser);
            }

            public Refund setUploadType(String uploadType) {
                return (Refund)super.setUploadType(uploadType);
            }

            public Refund setUploadProtocol(String uploadProtocol) {
                return (Refund)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Refund setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Refund setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            public Boolean getRevoke() {
                return this.revoke;
            }

            public Refund setRevoke(Boolean revoke) {
                this.revoke = revoke;
                return this;
            }

            @Override
            public Refund set(String parameterName, Object value) {
                return (Refund)super.set(parameterName, value);
            }
        }
    }

    public class Monetization {
        public ConvertRegionPrices convertRegionPrices(String packageName, ConvertRegionPricesRequest content) throws IOException {
            ConvertRegionPrices result = new ConvertRegionPrices(packageName, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Subscriptions subscriptions() {
            return new Subscriptions();
        }

        public class Subscriptions {
            public Archive archive(String packageName, String productId, ArchiveSubscriptionRequest content) throws IOException {
                Archive result = new Archive(packageName, productId, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchGet batchGet(String packageName) throws IOException {
                BatchGet result = new BatchGet(packageName);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchUpdate batchUpdate(String packageName, BatchUpdateSubscriptionsRequest content) throws IOException {
                BatchUpdate result = new BatchUpdate(packageName, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String packageName, Subscription content) throws IOException {
                Create result = new Create(packageName, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String packageName, String productId) throws IOException {
                Delete result = new Delete(packageName, productId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String packageName, String productId) throws IOException {
                Get result = new Get(packageName, productId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String packageName) throws IOException {
                List result = new List(packageName);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String packageName, String productId, Subscription content) throws IOException {
                Patch result = new Patch(packageName, productId, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BasePlans basePlans() {
                return new BasePlans();
            }

            public class BasePlans {
                public Activate activate(String packageName, String productId, String basePlanId, ActivateBasePlanRequest content) throws IOException {
                    Activate result = new Activate(packageName, productId, basePlanId, content);
                    AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public BatchMigratePrices batchMigratePrices(String packageName, String productId, BatchMigrateBasePlanPricesRequest content) throws IOException {
                    BatchMigratePrices result = new BatchMigratePrices(packageName, productId, content);
                    AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public BatchUpdateStates batchUpdateStates(String packageName, String productId, BatchUpdateBasePlanStatesRequest content) throws IOException {
                    BatchUpdateStates result = new BatchUpdateStates(packageName, productId, content);
                    AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Deactivate deactivate(String packageName, String productId, String basePlanId, DeactivateBasePlanRequest content) throws IOException {
                    Deactivate result = new Deactivate(packageName, productId, basePlanId, content);
                    AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String packageName, String productId, String basePlanId) throws IOException {
                    Delete result = new Delete(packageName, productId, basePlanId);
                    AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public MigratePrices migratePrices(String packageName, String productId, String basePlanId, MigrateBasePlanPricesRequest content) throws IOException {
                    MigratePrices result = new MigratePrices(packageName, productId, basePlanId, content);
                    AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Offers offers() {
                    return new Offers();
                }

                public class Offers {
                    public Activate activate(String packageName, String productId, String basePlanId, String offerId, ActivateSubscriptionOfferRequest content) throws IOException {
                        Activate result = new Activate(packageName, productId, basePlanId, offerId, content);
                        AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public BatchGet batchGet(String packageName, String productId, String basePlanId, BatchGetSubscriptionOffersRequest content) throws IOException {
                        BatchGet result = new BatchGet(packageName, productId, basePlanId, content);
                        AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public BatchUpdate batchUpdate(String packageName, String productId, String basePlanId, BatchUpdateSubscriptionOffersRequest content) throws IOException {
                        BatchUpdate result = new BatchUpdate(packageName, productId, basePlanId, content);
                        AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public BatchUpdateStates batchUpdateStates(String packageName, String productId, String basePlanId, BatchUpdateSubscriptionOfferStatesRequest content) throws IOException {
                        BatchUpdateStates result = new BatchUpdateStates(packageName, productId, basePlanId, content);
                        AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Create create(String packageName, String productId, String basePlanId, SubscriptionOffer content) throws IOException {
                        Create result = new Create(packageName, productId, basePlanId, content);
                        AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Deactivate deactivate(String packageName, String productId, String basePlanId, String offerId, DeactivateSubscriptionOfferRequest content) throws IOException {
                        Deactivate result = new Deactivate(packageName, productId, basePlanId, offerId, content);
                        AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String packageName, String productId, String basePlanId, String offerId) throws IOException {
                        Delete result = new Delete(packageName, productId, basePlanId, offerId);
                        AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String packageName, String productId, String basePlanId, String offerId) throws IOException {
                        Get result = new Get(packageName, productId, basePlanId, offerId);
                        AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String packageName, String productId, String basePlanId) throws IOException {
                        List result = new List(packageName, productId, basePlanId);
                        AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String packageName, String productId, String basePlanId, String offerId, SubscriptionOffer content) throws IOException {
                        Patch result = new Patch(packageName, productId, basePlanId, offerId, content);
                        AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Patch
                    extends AndroidPublisherRequest<SubscriptionOffer> {
                        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}";
                        @Key
                        private String packageName;
                        @Key
                        private String productId;
                        @Key
                        private String basePlanId;
                        @Key
                        private String offerId;
                        @Key
                        private Boolean allowMissing;
                        @Key
                        private String latencyTolerance;
                        @Key(value="regionsVersion.version")
                        private String regionsVersionVersion;
                        @Key
                        private String updateMask;

                        protected Patch(String packageName, String productId, String basePlanId, String offerId, SubscriptionOffer content) {
                            super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, SubscriptionOffer.class);
                            this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                            this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                            this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                            this.offerId = (String)Preconditions.checkNotNull((Object)offerId, (Object)"Required parameter offerId must be specified.");
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getPackageName() {
                            return this.packageName;
                        }

                        public Patch setPackageName(String packageName) {
                            this.packageName = packageName;
                            return this;
                        }

                        public String getProductId() {
                            return this.productId;
                        }

                        public Patch setProductId(String productId) {
                            this.productId = productId;
                            return this;
                        }

                        public String getBasePlanId() {
                            return this.basePlanId;
                        }

                        public Patch setBasePlanId(String basePlanId) {
                            this.basePlanId = basePlanId;
                            return this;
                        }

                        public String getOfferId() {
                            return this.offerId;
                        }

                        public Patch setOfferId(String offerId) {
                            this.offerId = offerId;
                            return this;
                        }

                        public Boolean getAllowMissing() {
                            return this.allowMissing;
                        }

                        public Patch setAllowMissing(Boolean allowMissing) {
                            this.allowMissing = allowMissing;
                            return this;
                        }

                        public String getLatencyTolerance() {
                            return this.latencyTolerance;
                        }

                        public Patch setLatencyTolerance(String latencyTolerance) {
                            this.latencyTolerance = latencyTolerance;
                            return this;
                        }

                        public String getRegionsVersionVersion() {
                            return this.regionsVersionVersion;
                        }

                        public Patch setRegionsVersionVersion(String regionsVersionVersion) {
                            this.regionsVersionVersion = regionsVersionVersion;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends AndroidPublisherRequest<ListSubscriptionOffersResponse> {
                        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers";
                        @Key
                        private String packageName;
                        @Key
                        private String productId;
                        @Key
                        private String basePlanId;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String packageName, String productId, String basePlanId) {
                            super(AndroidPublisher.this, "GET", REST_PATH, null, ListSubscriptionOffersResponse.class);
                            this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                            this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                            this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getPackageName() {
                            return this.packageName;
                        }

                        public List setPackageName(String packageName) {
                            this.packageName = packageName;
                            return this;
                        }

                        public String getProductId() {
                            return this.productId;
                        }

                        public List setProductId(String productId) {
                            this.productId = productId;
                            return this;
                        }

                        public String getBasePlanId() {
                            return this.basePlanId;
                        }

                        public List setBasePlanId(String basePlanId) {
                            this.basePlanId = basePlanId;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends AndroidPublisherRequest<SubscriptionOffer> {
                        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}";
                        @Key
                        private String packageName;
                        @Key
                        private String productId;
                        @Key
                        private String basePlanId;
                        @Key
                        private String offerId;

                        protected Get(String packageName, String productId, String basePlanId, String offerId) {
                            super(AndroidPublisher.this, "GET", REST_PATH, null, SubscriptionOffer.class);
                            this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                            this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                            this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                            this.offerId = (String)Preconditions.checkNotNull((Object)offerId, (Object)"Required parameter offerId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getPackageName() {
                            return this.packageName;
                        }

                        public Get setPackageName(String packageName) {
                            this.packageName = packageName;
                            return this;
                        }

                        public String getProductId() {
                            return this.productId;
                        }

                        public Get setProductId(String productId) {
                            this.productId = productId;
                            return this;
                        }

                        public String getBasePlanId() {
                            return this.basePlanId;
                        }

                        public Get setBasePlanId(String basePlanId) {
                            this.basePlanId = basePlanId;
                            return this;
                        }

                        public String getOfferId() {
                            return this.offerId;
                        }

                        public Get setOfferId(String offerId) {
                            this.offerId = offerId;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends AndroidPublisherRequest<Void> {
                        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}";
                        @Key
                        private String packageName;
                        @Key
                        private String productId;
                        @Key
                        private String basePlanId;
                        @Key
                        private String offerId;

                        protected Delete(String packageName, String productId, String basePlanId, String offerId) {
                            super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                            this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                            this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                            this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                            this.offerId = (String)Preconditions.checkNotNull((Object)offerId, (Object)"Required parameter offerId must be specified.");
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getPackageName() {
                            return this.packageName;
                        }

                        public Delete setPackageName(String packageName) {
                            this.packageName = packageName;
                            return this;
                        }

                        public String getProductId() {
                            return this.productId;
                        }

                        public Delete setProductId(String productId) {
                            this.productId = productId;
                            return this;
                        }

                        public String getBasePlanId() {
                            return this.basePlanId;
                        }

                        public Delete setBasePlanId(String basePlanId) {
                            this.basePlanId = basePlanId;
                            return this;
                        }

                        public String getOfferId() {
                            return this.offerId;
                        }

                        public Delete setOfferId(String offerId) {
                            this.offerId = offerId;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Deactivate
                    extends AndroidPublisherRequest<SubscriptionOffer> {
                        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}:deactivate";
                        @Key
                        private String packageName;
                        @Key
                        private String productId;
                        @Key
                        private String basePlanId;
                        @Key
                        private String offerId;

                        protected Deactivate(String packageName, String productId, String basePlanId, String offerId, DeactivateSubscriptionOfferRequest content) {
                            super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, SubscriptionOffer.class);
                            this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                            this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                            this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                            this.offerId = (String)Preconditions.checkNotNull((Object)offerId, (Object)"Required parameter offerId must be specified.");
                        }

                        public Deactivate set$Xgafv(String $Xgafv) {
                            return (Deactivate)super.set$Xgafv($Xgafv);
                        }

                        public Deactivate setAccessToken(String accessToken) {
                            return (Deactivate)super.setAccessToken(accessToken);
                        }

                        public Deactivate setAlt(String alt) {
                            return (Deactivate)super.setAlt(alt);
                        }

                        public Deactivate setCallback(String callback) {
                            return (Deactivate)super.setCallback(callback);
                        }

                        public Deactivate setFields(String fields) {
                            return (Deactivate)super.setFields(fields);
                        }

                        public Deactivate setKey(String key) {
                            return (Deactivate)super.setKey(key);
                        }

                        public Deactivate setOauthToken(String oauthToken) {
                            return (Deactivate)super.setOauthToken(oauthToken);
                        }

                        public Deactivate setPrettyPrint(Boolean prettyPrint) {
                            return (Deactivate)super.setPrettyPrint(prettyPrint);
                        }

                        public Deactivate setQuotaUser(String quotaUser) {
                            return (Deactivate)super.setQuotaUser(quotaUser);
                        }

                        public Deactivate setUploadType(String uploadType) {
                            return (Deactivate)super.setUploadType(uploadType);
                        }

                        public Deactivate setUploadProtocol(String uploadProtocol) {
                            return (Deactivate)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getPackageName() {
                            return this.packageName;
                        }

                        public Deactivate setPackageName(String packageName) {
                            this.packageName = packageName;
                            return this;
                        }

                        public String getProductId() {
                            return this.productId;
                        }

                        public Deactivate setProductId(String productId) {
                            this.productId = productId;
                            return this;
                        }

                        public String getBasePlanId() {
                            return this.basePlanId;
                        }

                        public Deactivate setBasePlanId(String basePlanId) {
                            this.basePlanId = basePlanId;
                            return this;
                        }

                        public String getOfferId() {
                            return this.offerId;
                        }

                        public Deactivate setOfferId(String offerId) {
                            this.offerId = offerId;
                            return this;
                        }

                        @Override
                        public Deactivate set(String parameterName, Object value) {
                            return (Deactivate)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends AndroidPublisherRequest<SubscriptionOffer> {
                        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers";
                        @Key
                        private String packageName;
                        @Key
                        private String productId;
                        @Key
                        private String basePlanId;
                        @Key
                        private String offerId;
                        @Key(value="regionsVersion.version")
                        private String regionsVersionVersion;

                        protected Create(String packageName, String productId, String basePlanId, SubscriptionOffer content) {
                            super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, SubscriptionOffer.class);
                            this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                            this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                            this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getPackageName() {
                            return this.packageName;
                        }

                        public Create setPackageName(String packageName) {
                            this.packageName = packageName;
                            return this;
                        }

                        public String getProductId() {
                            return this.productId;
                        }

                        public Create setProductId(String productId) {
                            this.productId = productId;
                            return this;
                        }

                        public String getBasePlanId() {
                            return this.basePlanId;
                        }

                        public Create setBasePlanId(String basePlanId) {
                            this.basePlanId = basePlanId;
                            return this;
                        }

                        public String getOfferId() {
                            return this.offerId;
                        }

                        public Create setOfferId(String offerId) {
                            this.offerId = offerId;
                            return this;
                        }

                        public String getRegionsVersionVersion() {
                            return this.regionsVersionVersion;
                        }

                        public Create setRegionsVersionVersion(String regionsVersionVersion) {
                            this.regionsVersionVersion = regionsVersionVersion;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }

                    public class BatchUpdateStates
                    extends AndroidPublisherRequest<BatchUpdateSubscriptionOfferStatesResponse> {
                        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchUpdateStates";
                        @Key
                        private String packageName;
                        @Key
                        private String productId;
                        @Key
                        private String basePlanId;

                        protected BatchUpdateStates(String packageName, String productId, String basePlanId, BatchUpdateSubscriptionOfferStatesRequest content) {
                            super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, BatchUpdateSubscriptionOfferStatesResponse.class);
                            this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                            this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                            this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                        }

                        public BatchUpdateStates set$Xgafv(String $Xgafv) {
                            return (BatchUpdateStates)super.set$Xgafv($Xgafv);
                        }

                        public BatchUpdateStates setAccessToken(String accessToken) {
                            return (BatchUpdateStates)super.setAccessToken(accessToken);
                        }

                        public BatchUpdateStates setAlt(String alt) {
                            return (BatchUpdateStates)super.setAlt(alt);
                        }

                        public BatchUpdateStates setCallback(String callback) {
                            return (BatchUpdateStates)super.setCallback(callback);
                        }

                        public BatchUpdateStates setFields(String fields) {
                            return (BatchUpdateStates)super.setFields(fields);
                        }

                        public BatchUpdateStates setKey(String key) {
                            return (BatchUpdateStates)super.setKey(key);
                        }

                        public BatchUpdateStates setOauthToken(String oauthToken) {
                            return (BatchUpdateStates)super.setOauthToken(oauthToken);
                        }

                        public BatchUpdateStates setPrettyPrint(Boolean prettyPrint) {
                            return (BatchUpdateStates)super.setPrettyPrint(prettyPrint);
                        }

                        public BatchUpdateStates setQuotaUser(String quotaUser) {
                            return (BatchUpdateStates)super.setQuotaUser(quotaUser);
                        }

                        public BatchUpdateStates setUploadType(String uploadType) {
                            return (BatchUpdateStates)super.setUploadType(uploadType);
                        }

                        public BatchUpdateStates setUploadProtocol(String uploadProtocol) {
                            return (BatchUpdateStates)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getPackageName() {
                            return this.packageName;
                        }

                        public BatchUpdateStates setPackageName(String packageName) {
                            this.packageName = packageName;
                            return this;
                        }

                        public String getProductId() {
                            return this.productId;
                        }

                        public BatchUpdateStates setProductId(String productId) {
                            this.productId = productId;
                            return this;
                        }

                        public String getBasePlanId() {
                            return this.basePlanId;
                        }

                        public BatchUpdateStates setBasePlanId(String basePlanId) {
                            this.basePlanId = basePlanId;
                            return this;
                        }

                        @Override
                        public BatchUpdateStates set(String parameterName, Object value) {
                            return (BatchUpdateStates)super.set(parameterName, value);
                        }
                    }

                    public class BatchUpdate
                    extends AndroidPublisherRequest<BatchUpdateSubscriptionOffersResponse> {
                        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchUpdate";
                        @Key
                        private String packageName;
                        @Key
                        private String productId;
                        @Key
                        private String basePlanId;

                        protected BatchUpdate(String packageName, String productId, String basePlanId, BatchUpdateSubscriptionOffersRequest content) {
                            super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, BatchUpdateSubscriptionOffersResponse.class);
                            this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                            this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                            this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                        }

                        public BatchUpdate set$Xgafv(String $Xgafv) {
                            return (BatchUpdate)super.set$Xgafv($Xgafv);
                        }

                        public BatchUpdate setAccessToken(String accessToken) {
                            return (BatchUpdate)super.setAccessToken(accessToken);
                        }

                        public BatchUpdate setAlt(String alt) {
                            return (BatchUpdate)super.setAlt(alt);
                        }

                        public BatchUpdate setCallback(String callback) {
                            return (BatchUpdate)super.setCallback(callback);
                        }

                        public BatchUpdate setFields(String fields) {
                            return (BatchUpdate)super.setFields(fields);
                        }

                        public BatchUpdate setKey(String key) {
                            return (BatchUpdate)super.setKey(key);
                        }

                        public BatchUpdate setOauthToken(String oauthToken) {
                            return (BatchUpdate)super.setOauthToken(oauthToken);
                        }

                        public BatchUpdate setPrettyPrint(Boolean prettyPrint) {
                            return (BatchUpdate)super.setPrettyPrint(prettyPrint);
                        }

                        public BatchUpdate setQuotaUser(String quotaUser) {
                            return (BatchUpdate)super.setQuotaUser(quotaUser);
                        }

                        public BatchUpdate setUploadType(String uploadType) {
                            return (BatchUpdate)super.setUploadType(uploadType);
                        }

                        public BatchUpdate setUploadProtocol(String uploadProtocol) {
                            return (BatchUpdate)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getPackageName() {
                            return this.packageName;
                        }

                        public BatchUpdate setPackageName(String packageName) {
                            this.packageName = packageName;
                            return this;
                        }

                        public String getProductId() {
                            return this.productId;
                        }

                        public BatchUpdate setProductId(String productId) {
                            this.productId = productId;
                            return this;
                        }

                        public String getBasePlanId() {
                            return this.basePlanId;
                        }

                        public BatchUpdate setBasePlanId(String basePlanId) {
                            this.basePlanId = basePlanId;
                            return this;
                        }

                        @Override
                        public BatchUpdate set(String parameterName, Object value) {
                            return (BatchUpdate)super.set(parameterName, value);
                        }
                    }

                    public class BatchGet
                    extends AndroidPublisherRequest<BatchGetSubscriptionOffersResponse> {
                        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchGet";
                        @Key
                        private String packageName;
                        @Key
                        private String productId;
                        @Key
                        private String basePlanId;

                        protected BatchGet(String packageName, String productId, String basePlanId, BatchGetSubscriptionOffersRequest content) {
                            super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, BatchGetSubscriptionOffersResponse.class);
                            this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                            this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                            this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                        }

                        public BatchGet set$Xgafv(String $Xgafv) {
                            return (BatchGet)super.set$Xgafv($Xgafv);
                        }

                        public BatchGet setAccessToken(String accessToken) {
                            return (BatchGet)super.setAccessToken(accessToken);
                        }

                        public BatchGet setAlt(String alt) {
                            return (BatchGet)super.setAlt(alt);
                        }

                        public BatchGet setCallback(String callback) {
                            return (BatchGet)super.setCallback(callback);
                        }

                        public BatchGet setFields(String fields) {
                            return (BatchGet)super.setFields(fields);
                        }

                        public BatchGet setKey(String key) {
                            return (BatchGet)super.setKey(key);
                        }

                        public BatchGet setOauthToken(String oauthToken) {
                            return (BatchGet)super.setOauthToken(oauthToken);
                        }

                        public BatchGet setPrettyPrint(Boolean prettyPrint) {
                            return (BatchGet)super.setPrettyPrint(prettyPrint);
                        }

                        public BatchGet setQuotaUser(String quotaUser) {
                            return (BatchGet)super.setQuotaUser(quotaUser);
                        }

                        public BatchGet setUploadType(String uploadType) {
                            return (BatchGet)super.setUploadType(uploadType);
                        }

                        public BatchGet setUploadProtocol(String uploadProtocol) {
                            return (BatchGet)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getPackageName() {
                            return this.packageName;
                        }

                        public BatchGet setPackageName(String packageName) {
                            this.packageName = packageName;
                            return this;
                        }

                        public String getProductId() {
                            return this.productId;
                        }

                        public BatchGet setProductId(String productId) {
                            this.productId = productId;
                            return this;
                        }

                        public String getBasePlanId() {
                            return this.basePlanId;
                        }

                        public BatchGet setBasePlanId(String basePlanId) {
                            this.basePlanId = basePlanId;
                            return this;
                        }

                        @Override
                        public BatchGet set(String parameterName, Object value) {
                            return (BatchGet)super.set(parameterName, value);
                        }
                    }

                    public class Activate
                    extends AndroidPublisherRequest<SubscriptionOffer> {
                        private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}:activate";
                        @Key
                        private String packageName;
                        @Key
                        private String productId;
                        @Key
                        private String basePlanId;
                        @Key
                        private String offerId;

                        protected Activate(String packageName, String productId, String basePlanId, String offerId, ActivateSubscriptionOfferRequest content) {
                            super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, SubscriptionOffer.class);
                            this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                            this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                            this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                            this.offerId = (String)Preconditions.checkNotNull((Object)offerId, (Object)"Required parameter offerId must be specified.");
                        }

                        public Activate set$Xgafv(String $Xgafv) {
                            return (Activate)super.set$Xgafv($Xgafv);
                        }

                        public Activate setAccessToken(String accessToken) {
                            return (Activate)super.setAccessToken(accessToken);
                        }

                        public Activate setAlt(String alt) {
                            return (Activate)super.setAlt(alt);
                        }

                        public Activate setCallback(String callback) {
                            return (Activate)super.setCallback(callback);
                        }

                        public Activate setFields(String fields) {
                            return (Activate)super.setFields(fields);
                        }

                        public Activate setKey(String key) {
                            return (Activate)super.setKey(key);
                        }

                        public Activate setOauthToken(String oauthToken) {
                            return (Activate)super.setOauthToken(oauthToken);
                        }

                        public Activate setPrettyPrint(Boolean prettyPrint) {
                            return (Activate)super.setPrettyPrint(prettyPrint);
                        }

                        public Activate setQuotaUser(String quotaUser) {
                            return (Activate)super.setQuotaUser(quotaUser);
                        }

                        public Activate setUploadType(String uploadType) {
                            return (Activate)super.setUploadType(uploadType);
                        }

                        public Activate setUploadProtocol(String uploadProtocol) {
                            return (Activate)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getPackageName() {
                            return this.packageName;
                        }

                        public Activate setPackageName(String packageName) {
                            this.packageName = packageName;
                            return this;
                        }

                        public String getProductId() {
                            return this.productId;
                        }

                        public Activate setProductId(String productId) {
                            this.productId = productId;
                            return this;
                        }

                        public String getBasePlanId() {
                            return this.basePlanId;
                        }

                        public Activate setBasePlanId(String basePlanId) {
                            this.basePlanId = basePlanId;
                            return this;
                        }

                        public String getOfferId() {
                            return this.offerId;
                        }

                        public Activate setOfferId(String offerId) {
                            this.offerId = offerId;
                            return this;
                        }

                        @Override
                        public Activate set(String parameterName, Object value) {
                            return (Activate)super.set(parameterName, value);
                        }
                    }
                }

                public class MigratePrices
                extends AndroidPublisherRequest<MigrateBasePlanPricesResponse> {
                    private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:migratePrices";
                    @Key
                    private String packageName;
                    @Key
                    private String productId;
                    @Key
                    private String basePlanId;

                    protected MigratePrices(String packageName, String productId, String basePlanId, MigrateBasePlanPricesRequest content) {
                        super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, MigrateBasePlanPricesResponse.class);
                        this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                        this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                        this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                    }

                    public MigratePrices set$Xgafv(String $Xgafv) {
                        return (MigratePrices)super.set$Xgafv($Xgafv);
                    }

                    public MigratePrices setAccessToken(String accessToken) {
                        return (MigratePrices)super.setAccessToken(accessToken);
                    }

                    public MigratePrices setAlt(String alt) {
                        return (MigratePrices)super.setAlt(alt);
                    }

                    public MigratePrices setCallback(String callback) {
                        return (MigratePrices)super.setCallback(callback);
                    }

                    public MigratePrices setFields(String fields) {
                        return (MigratePrices)super.setFields(fields);
                    }

                    public MigratePrices setKey(String key) {
                        return (MigratePrices)super.setKey(key);
                    }

                    public MigratePrices setOauthToken(String oauthToken) {
                        return (MigratePrices)super.setOauthToken(oauthToken);
                    }

                    public MigratePrices setPrettyPrint(Boolean prettyPrint) {
                        return (MigratePrices)super.setPrettyPrint(prettyPrint);
                    }

                    public MigratePrices setQuotaUser(String quotaUser) {
                        return (MigratePrices)super.setQuotaUser(quotaUser);
                    }

                    public MigratePrices setUploadType(String uploadType) {
                        return (MigratePrices)super.setUploadType(uploadType);
                    }

                    public MigratePrices setUploadProtocol(String uploadProtocol) {
                        return (MigratePrices)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getPackageName() {
                        return this.packageName;
                    }

                    public MigratePrices setPackageName(String packageName) {
                        this.packageName = packageName;
                        return this;
                    }

                    public String getProductId() {
                        return this.productId;
                    }

                    public MigratePrices setProductId(String productId) {
                        this.productId = productId;
                        return this;
                    }

                    public String getBasePlanId() {
                        return this.basePlanId;
                    }

                    public MigratePrices setBasePlanId(String basePlanId) {
                        this.basePlanId = basePlanId;
                        return this;
                    }

                    @Override
                    public MigratePrices set(String parameterName, Object value) {
                        return (MigratePrices)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends AndroidPublisherRequest<Void> {
                    private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}";
                    @Key
                    private String packageName;
                    @Key
                    private String productId;
                    @Key
                    private String basePlanId;

                    protected Delete(String packageName, String productId, String basePlanId) {
                        super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                        this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                        this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                        this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getPackageName() {
                        return this.packageName;
                    }

                    public Delete setPackageName(String packageName) {
                        this.packageName = packageName;
                        return this;
                    }

                    public String getProductId() {
                        return this.productId;
                    }

                    public Delete setProductId(String productId) {
                        this.productId = productId;
                        return this;
                    }

                    public String getBasePlanId() {
                        return this.basePlanId;
                    }

                    public Delete setBasePlanId(String basePlanId) {
                        this.basePlanId = basePlanId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Deactivate
                extends AndroidPublisherRequest<Subscription> {
                    private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:deactivate";
                    @Key
                    private String packageName;
                    @Key
                    private String productId;
                    @Key
                    private String basePlanId;

                    protected Deactivate(String packageName, String productId, String basePlanId, DeactivateBasePlanRequest content) {
                        super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, Subscription.class);
                        this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                        this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                        this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                    }

                    public Deactivate set$Xgafv(String $Xgafv) {
                        return (Deactivate)super.set$Xgafv($Xgafv);
                    }

                    public Deactivate setAccessToken(String accessToken) {
                        return (Deactivate)super.setAccessToken(accessToken);
                    }

                    public Deactivate setAlt(String alt) {
                        return (Deactivate)super.setAlt(alt);
                    }

                    public Deactivate setCallback(String callback) {
                        return (Deactivate)super.setCallback(callback);
                    }

                    public Deactivate setFields(String fields) {
                        return (Deactivate)super.setFields(fields);
                    }

                    public Deactivate setKey(String key) {
                        return (Deactivate)super.setKey(key);
                    }

                    public Deactivate setOauthToken(String oauthToken) {
                        return (Deactivate)super.setOauthToken(oauthToken);
                    }

                    public Deactivate setPrettyPrint(Boolean prettyPrint) {
                        return (Deactivate)super.setPrettyPrint(prettyPrint);
                    }

                    public Deactivate setQuotaUser(String quotaUser) {
                        return (Deactivate)super.setQuotaUser(quotaUser);
                    }

                    public Deactivate setUploadType(String uploadType) {
                        return (Deactivate)super.setUploadType(uploadType);
                    }

                    public Deactivate setUploadProtocol(String uploadProtocol) {
                        return (Deactivate)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getPackageName() {
                        return this.packageName;
                    }

                    public Deactivate setPackageName(String packageName) {
                        this.packageName = packageName;
                        return this;
                    }

                    public String getProductId() {
                        return this.productId;
                    }

                    public Deactivate setProductId(String productId) {
                        this.productId = productId;
                        return this;
                    }

                    public String getBasePlanId() {
                        return this.basePlanId;
                    }

                    public Deactivate setBasePlanId(String basePlanId) {
                        this.basePlanId = basePlanId;
                        return this;
                    }

                    @Override
                    public Deactivate set(String parameterName, Object value) {
                        return (Deactivate)super.set(parameterName, value);
                    }
                }

                public class BatchUpdateStates
                extends AndroidPublisherRequest<BatchUpdateBasePlanStatesResponse> {
                    private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans:batchUpdateStates";
                    @Key
                    private String packageName;
                    @Key
                    private String productId;

                    protected BatchUpdateStates(String packageName, String productId, BatchUpdateBasePlanStatesRequest content) {
                        super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, BatchUpdateBasePlanStatesResponse.class);
                        this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                        this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                    }

                    public BatchUpdateStates set$Xgafv(String $Xgafv) {
                        return (BatchUpdateStates)super.set$Xgafv($Xgafv);
                    }

                    public BatchUpdateStates setAccessToken(String accessToken) {
                        return (BatchUpdateStates)super.setAccessToken(accessToken);
                    }

                    public BatchUpdateStates setAlt(String alt) {
                        return (BatchUpdateStates)super.setAlt(alt);
                    }

                    public BatchUpdateStates setCallback(String callback) {
                        return (BatchUpdateStates)super.setCallback(callback);
                    }

                    public BatchUpdateStates setFields(String fields) {
                        return (BatchUpdateStates)super.setFields(fields);
                    }

                    public BatchUpdateStates setKey(String key) {
                        return (BatchUpdateStates)super.setKey(key);
                    }

                    public BatchUpdateStates setOauthToken(String oauthToken) {
                        return (BatchUpdateStates)super.setOauthToken(oauthToken);
                    }

                    public BatchUpdateStates setPrettyPrint(Boolean prettyPrint) {
                        return (BatchUpdateStates)super.setPrettyPrint(prettyPrint);
                    }

                    public BatchUpdateStates setQuotaUser(String quotaUser) {
                        return (BatchUpdateStates)super.setQuotaUser(quotaUser);
                    }

                    public BatchUpdateStates setUploadType(String uploadType) {
                        return (BatchUpdateStates)super.setUploadType(uploadType);
                    }

                    public BatchUpdateStates setUploadProtocol(String uploadProtocol) {
                        return (BatchUpdateStates)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getPackageName() {
                        return this.packageName;
                    }

                    public BatchUpdateStates setPackageName(String packageName) {
                        this.packageName = packageName;
                        return this;
                    }

                    public String getProductId() {
                        return this.productId;
                    }

                    public BatchUpdateStates setProductId(String productId) {
                        this.productId = productId;
                        return this;
                    }

                    @Override
                    public BatchUpdateStates set(String parameterName, Object value) {
                        return (BatchUpdateStates)super.set(parameterName, value);
                    }
                }

                public class BatchMigratePrices
                extends AndroidPublisherRequest<BatchMigrateBasePlanPricesResponse> {
                    private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans:batchMigratePrices";
                    @Key
                    private String packageName;
                    @Key
                    private String productId;

                    protected BatchMigratePrices(String packageName, String productId, BatchMigrateBasePlanPricesRequest content) {
                        super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, BatchMigrateBasePlanPricesResponse.class);
                        this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                        this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                    }

                    public BatchMigratePrices set$Xgafv(String $Xgafv) {
                        return (BatchMigratePrices)super.set$Xgafv($Xgafv);
                    }

                    public BatchMigratePrices setAccessToken(String accessToken) {
                        return (BatchMigratePrices)super.setAccessToken(accessToken);
                    }

                    public BatchMigratePrices setAlt(String alt) {
                        return (BatchMigratePrices)super.setAlt(alt);
                    }

                    public BatchMigratePrices setCallback(String callback) {
                        return (BatchMigratePrices)super.setCallback(callback);
                    }

                    public BatchMigratePrices setFields(String fields) {
                        return (BatchMigratePrices)super.setFields(fields);
                    }

                    public BatchMigratePrices setKey(String key) {
                        return (BatchMigratePrices)super.setKey(key);
                    }

                    public BatchMigratePrices setOauthToken(String oauthToken) {
                        return (BatchMigratePrices)super.setOauthToken(oauthToken);
                    }

                    public BatchMigratePrices setPrettyPrint(Boolean prettyPrint) {
                        return (BatchMigratePrices)super.setPrettyPrint(prettyPrint);
                    }

                    public BatchMigratePrices setQuotaUser(String quotaUser) {
                        return (BatchMigratePrices)super.setQuotaUser(quotaUser);
                    }

                    public BatchMigratePrices setUploadType(String uploadType) {
                        return (BatchMigratePrices)super.setUploadType(uploadType);
                    }

                    public BatchMigratePrices setUploadProtocol(String uploadProtocol) {
                        return (BatchMigratePrices)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getPackageName() {
                        return this.packageName;
                    }

                    public BatchMigratePrices setPackageName(String packageName) {
                        this.packageName = packageName;
                        return this;
                    }

                    public String getProductId() {
                        return this.productId;
                    }

                    public BatchMigratePrices setProductId(String productId) {
                        this.productId = productId;
                        return this;
                    }

                    @Override
                    public BatchMigratePrices set(String parameterName, Object value) {
                        return (BatchMigratePrices)super.set(parameterName, value);
                    }
                }

                public class Activate
                extends AndroidPublisherRequest<Subscription> {
                    private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:activate";
                    @Key
                    private String packageName;
                    @Key
                    private String productId;
                    @Key
                    private String basePlanId;

                    protected Activate(String packageName, String productId, String basePlanId, ActivateBasePlanRequest content) {
                        super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, Subscription.class);
                        this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                        this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                        this.basePlanId = (String)Preconditions.checkNotNull((Object)basePlanId, (Object)"Required parameter basePlanId must be specified.");
                    }

                    public Activate set$Xgafv(String $Xgafv) {
                        return (Activate)super.set$Xgafv($Xgafv);
                    }

                    public Activate setAccessToken(String accessToken) {
                        return (Activate)super.setAccessToken(accessToken);
                    }

                    public Activate setAlt(String alt) {
                        return (Activate)super.setAlt(alt);
                    }

                    public Activate setCallback(String callback) {
                        return (Activate)super.setCallback(callback);
                    }

                    public Activate setFields(String fields) {
                        return (Activate)super.setFields(fields);
                    }

                    public Activate setKey(String key) {
                        return (Activate)super.setKey(key);
                    }

                    public Activate setOauthToken(String oauthToken) {
                        return (Activate)super.setOauthToken(oauthToken);
                    }

                    public Activate setPrettyPrint(Boolean prettyPrint) {
                        return (Activate)super.setPrettyPrint(prettyPrint);
                    }

                    public Activate setQuotaUser(String quotaUser) {
                        return (Activate)super.setQuotaUser(quotaUser);
                    }

                    public Activate setUploadType(String uploadType) {
                        return (Activate)super.setUploadType(uploadType);
                    }

                    public Activate setUploadProtocol(String uploadProtocol) {
                        return (Activate)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getPackageName() {
                        return this.packageName;
                    }

                    public Activate setPackageName(String packageName) {
                        this.packageName = packageName;
                        return this;
                    }

                    public String getProductId() {
                        return this.productId;
                    }

                    public Activate setProductId(String productId) {
                        this.productId = productId;
                        return this;
                    }

                    public String getBasePlanId() {
                        return this.basePlanId;
                    }

                    public Activate setBasePlanId(String basePlanId) {
                        this.basePlanId = basePlanId;
                        return this;
                    }

                    @Override
                    public Activate set(String parameterName, Object value) {
                        return (Activate)super.set(parameterName, value);
                    }
                }
            }

            public class Patch
            extends AndroidPublisherRequest<Subscription> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}";
                @Key
                private String packageName;
                @Key
                private String productId;
                @Key
                private Boolean allowMissing;
                @Key
                private String latencyTolerance;
                @Key(value="regionsVersion.version")
                private String regionsVersionVersion;
                @Key
                private String updateMask;

                protected Patch(String packageName, String productId, Subscription content) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, Subscription.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public Patch setProductId(String productId) {
                    this.productId = productId;
                    return this;
                }

                public Boolean getAllowMissing() {
                    return this.allowMissing;
                }

                public Patch setAllowMissing(Boolean allowMissing) {
                    this.allowMissing = allowMissing;
                    return this;
                }

                public String getLatencyTolerance() {
                    return this.latencyTolerance;
                }

                public Patch setLatencyTolerance(String latencyTolerance) {
                    this.latencyTolerance = latencyTolerance;
                    return this;
                }

                public String getRegionsVersionVersion() {
                    return this.regionsVersionVersion;
                }

                public Patch setRegionsVersionVersion(String regionsVersionVersion) {
                    this.regionsVersionVersion = regionsVersionVersion;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AndroidPublisherRequest<ListSubscriptionsResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions";
                @Key
                private String packageName;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private Boolean showArchived;

                protected List(String packageName) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ListSubscriptionsResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Boolean getShowArchived() {
                    return this.showArchived;
                }

                public List setShowArchived(Boolean showArchived) {
                    this.showArchived = showArchived;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<Subscription> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}";
                @Key
                private String packageName;
                @Key
                private String productId;

                protected Get(String packageName, String productId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, Subscription.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public Get setProductId(String productId) {
                    this.productId = productId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}";
                @Key
                private String packageName;
                @Key
                private String productId;

                protected Delete(String packageName, String productId) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Delete setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public Delete setProductId(String productId) {
                    this.productId = productId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends AndroidPublisherRequest<Subscription> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions";
                @Key
                private String packageName;
                @Key
                private String productId;
                @Key(value="regionsVersion.version")
                private String regionsVersionVersion;

                protected Create(String packageName, Subscription content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, Subscription.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Create setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public Create setProductId(String productId) {
                    this.productId = productId;
                    return this;
                }

                public String getRegionsVersionVersion() {
                    return this.regionsVersionVersion;
                }

                public Create setRegionsVersionVersion(String regionsVersionVersion) {
                    this.regionsVersionVersion = regionsVersionVersion;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class BatchUpdate
            extends AndroidPublisherRequest<BatchUpdateSubscriptionsResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions:batchUpdate";
                @Key
                private String packageName;

                protected BatchUpdate(String packageName, BatchUpdateSubscriptionsRequest content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, BatchUpdateSubscriptionsResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                }

                public BatchUpdate set$Xgafv(String $Xgafv) {
                    return (BatchUpdate)super.set$Xgafv($Xgafv);
                }

                public BatchUpdate setAccessToken(String accessToken) {
                    return (BatchUpdate)super.setAccessToken(accessToken);
                }

                public BatchUpdate setAlt(String alt) {
                    return (BatchUpdate)super.setAlt(alt);
                }

                public BatchUpdate setCallback(String callback) {
                    return (BatchUpdate)super.setCallback(callback);
                }

                public BatchUpdate setFields(String fields) {
                    return (BatchUpdate)super.setFields(fields);
                }

                public BatchUpdate setKey(String key) {
                    return (BatchUpdate)super.setKey(key);
                }

                public BatchUpdate setOauthToken(String oauthToken) {
                    return (BatchUpdate)super.setOauthToken(oauthToken);
                }

                public BatchUpdate setPrettyPrint(Boolean prettyPrint) {
                    return (BatchUpdate)super.setPrettyPrint(prettyPrint);
                }

                public BatchUpdate setQuotaUser(String quotaUser) {
                    return (BatchUpdate)super.setQuotaUser(quotaUser);
                }

                public BatchUpdate setUploadType(String uploadType) {
                    return (BatchUpdate)super.setUploadType(uploadType);
                }

                public BatchUpdate setUploadProtocol(String uploadProtocol) {
                    return (BatchUpdate)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public BatchUpdate setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                @Override
                public BatchUpdate set(String parameterName, Object value) {
                    return (BatchUpdate)super.set(parameterName, value);
                }
            }

            public class BatchGet
            extends AndroidPublisherRequest<BatchGetSubscriptionsResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions:batchGet";
                @Key
                private String packageName;
                @Key
                private java.util.List<String> productIds;

                protected BatchGet(String packageName) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, BatchGetSubscriptionsResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public BatchGet set$Xgafv(String $Xgafv) {
                    return (BatchGet)super.set$Xgafv($Xgafv);
                }

                public BatchGet setAccessToken(String accessToken) {
                    return (BatchGet)super.setAccessToken(accessToken);
                }

                public BatchGet setAlt(String alt) {
                    return (BatchGet)super.setAlt(alt);
                }

                public BatchGet setCallback(String callback) {
                    return (BatchGet)super.setCallback(callback);
                }

                public BatchGet setFields(String fields) {
                    return (BatchGet)super.setFields(fields);
                }

                public BatchGet setKey(String key) {
                    return (BatchGet)super.setKey(key);
                }

                public BatchGet setOauthToken(String oauthToken) {
                    return (BatchGet)super.setOauthToken(oauthToken);
                }

                public BatchGet setPrettyPrint(Boolean prettyPrint) {
                    return (BatchGet)super.setPrettyPrint(prettyPrint);
                }

                public BatchGet setQuotaUser(String quotaUser) {
                    return (BatchGet)super.setQuotaUser(quotaUser);
                }

                public BatchGet setUploadType(String uploadType) {
                    return (BatchGet)super.setUploadType(uploadType);
                }

                public BatchGet setUploadProtocol(String uploadProtocol) {
                    return (BatchGet)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public BatchGet setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public java.util.List<String> getProductIds() {
                    return this.productIds;
                }

                public BatchGet setProductIds(java.util.List<String> productIds) {
                    this.productIds = productIds;
                    return this;
                }

                @Override
                public BatchGet set(String parameterName, Object value) {
                    return (BatchGet)super.set(parameterName, value);
                }
            }

            public class Archive
            extends AndroidPublisherRequest<Subscription> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}:archive";
                @Key
                private String packageName;
                @Key
                private String productId;

                protected Archive(String packageName, String productId, ArchiveSubscriptionRequest content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, Subscription.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                }

                public Archive set$Xgafv(String $Xgafv) {
                    return (Archive)super.set$Xgafv($Xgafv);
                }

                public Archive setAccessToken(String accessToken) {
                    return (Archive)super.setAccessToken(accessToken);
                }

                public Archive setAlt(String alt) {
                    return (Archive)super.setAlt(alt);
                }

                public Archive setCallback(String callback) {
                    return (Archive)super.setCallback(callback);
                }

                public Archive setFields(String fields) {
                    return (Archive)super.setFields(fields);
                }

                public Archive setKey(String key) {
                    return (Archive)super.setKey(key);
                }

                public Archive setOauthToken(String oauthToken) {
                    return (Archive)super.setOauthToken(oauthToken);
                }

                public Archive setPrettyPrint(Boolean prettyPrint) {
                    return (Archive)super.setPrettyPrint(prettyPrint);
                }

                public Archive setQuotaUser(String quotaUser) {
                    return (Archive)super.setQuotaUser(quotaUser);
                }

                public Archive setUploadType(String uploadType) {
                    return (Archive)super.setUploadType(uploadType);
                }

                public Archive setUploadProtocol(String uploadProtocol) {
                    return (Archive)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Archive setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public Archive setProductId(String productId) {
                    this.productId = productId;
                    return this;
                }

                @Override
                public Archive set(String parameterName, Object value) {
                    return (Archive)super.set(parameterName, value);
                }
            }
        }

        public class ConvertRegionPrices
        extends AndroidPublisherRequest<ConvertRegionPricesResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/pricing:convertRegionPrices";
            @Key
            private String packageName;

            protected ConvertRegionPrices(String packageName, ConvertRegionPricesRequest content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, ConvertRegionPricesResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public ConvertRegionPrices set$Xgafv(String $Xgafv) {
                return (ConvertRegionPrices)super.set$Xgafv($Xgafv);
            }

            public ConvertRegionPrices setAccessToken(String accessToken) {
                return (ConvertRegionPrices)super.setAccessToken(accessToken);
            }

            public ConvertRegionPrices setAlt(String alt) {
                return (ConvertRegionPrices)super.setAlt(alt);
            }

            public ConvertRegionPrices setCallback(String callback) {
                return (ConvertRegionPrices)super.setCallback(callback);
            }

            public ConvertRegionPrices setFields(String fields) {
                return (ConvertRegionPrices)super.setFields(fields);
            }

            public ConvertRegionPrices setKey(String key) {
                return (ConvertRegionPrices)super.setKey(key);
            }

            public ConvertRegionPrices setOauthToken(String oauthToken) {
                return (ConvertRegionPrices)super.setOauthToken(oauthToken);
            }

            public ConvertRegionPrices setPrettyPrint(Boolean prettyPrint) {
                return (ConvertRegionPrices)super.setPrettyPrint(prettyPrint);
            }

            public ConvertRegionPrices setQuotaUser(String quotaUser) {
                return (ConvertRegionPrices)super.setQuotaUser(quotaUser);
            }

            public ConvertRegionPrices setUploadType(String uploadType) {
                return (ConvertRegionPrices)super.setUploadType(uploadType);
            }

            public ConvertRegionPrices setUploadProtocol(String uploadProtocol) {
                return (ConvertRegionPrices)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public ConvertRegionPrices setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            @Override
            public ConvertRegionPrices set(String parameterName, Object value) {
                return (ConvertRegionPrices)super.set(parameterName, value);
            }
        }
    }

    public class Internalappsharingartifacts {
        public Uploadapk uploadapk(String packageName) throws IOException {
            Uploadapk result = new Uploadapk(packageName);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Uploadapk uploadapk(String packageName, AbstractInputStreamContent mediaContent) throws IOException {
            Uploadapk result = new Uploadapk(packageName, mediaContent);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Uploadbundle uploadbundle(String packageName) throws IOException {
            Uploadbundle result = new Uploadbundle(packageName);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Uploadbundle uploadbundle(String packageName, AbstractInputStreamContent mediaContent) throws IOException {
            Uploadbundle result = new Uploadbundle(packageName, mediaContent);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Uploadbundle
        extends AndroidPublisherRequest<InternalAppSharingArtifact> {
            private static final String REST_PATH = "androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/bundle";
            @Key
            private String packageName;

            protected Uploadbundle(String packageName) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, InternalAppSharingArtifact.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            protected Uploadbundle(String packageName, AbstractInputStreamContent mediaContent) {
                super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, InternalAppSharingArtifact.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Uploadbundle set$Xgafv(String $Xgafv) {
                return (Uploadbundle)super.set$Xgafv($Xgafv);
            }

            public Uploadbundle setAccessToken(String accessToken) {
                return (Uploadbundle)super.setAccessToken(accessToken);
            }

            public Uploadbundle setAlt(String alt) {
                return (Uploadbundle)super.setAlt(alt);
            }

            public Uploadbundle setCallback(String callback) {
                return (Uploadbundle)super.setCallback(callback);
            }

            public Uploadbundle setFields(String fields) {
                return (Uploadbundle)super.setFields(fields);
            }

            public Uploadbundle setKey(String key) {
                return (Uploadbundle)super.setKey(key);
            }

            public Uploadbundle setOauthToken(String oauthToken) {
                return (Uploadbundle)super.setOauthToken(oauthToken);
            }

            public Uploadbundle setPrettyPrint(Boolean prettyPrint) {
                return (Uploadbundle)super.setPrettyPrint(prettyPrint);
            }

            public Uploadbundle setQuotaUser(String quotaUser) {
                return (Uploadbundle)super.setQuotaUser(quotaUser);
            }

            public Uploadbundle setUploadType(String uploadType) {
                return (Uploadbundle)super.setUploadType(uploadType);
            }

            public Uploadbundle setUploadProtocol(String uploadProtocol) {
                return (Uploadbundle)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Uploadbundle setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            @Override
            public Uploadbundle set(String parameterName, Object value) {
                return (Uploadbundle)super.set(parameterName, value);
            }
        }

        public class Uploadapk
        extends AndroidPublisherRequest<InternalAppSharingArtifact> {
            private static final String REST_PATH = "androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/apk";
            @Key
            private String packageName;

            protected Uploadapk(String packageName) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, InternalAppSharingArtifact.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            protected Uploadapk(String packageName, AbstractInputStreamContent mediaContent) {
                super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, InternalAppSharingArtifact.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Uploadapk set$Xgafv(String $Xgafv) {
                return (Uploadapk)super.set$Xgafv($Xgafv);
            }

            public Uploadapk setAccessToken(String accessToken) {
                return (Uploadapk)super.setAccessToken(accessToken);
            }

            public Uploadapk setAlt(String alt) {
                return (Uploadapk)super.setAlt(alt);
            }

            public Uploadapk setCallback(String callback) {
                return (Uploadapk)super.setCallback(callback);
            }

            public Uploadapk setFields(String fields) {
                return (Uploadapk)super.setFields(fields);
            }

            public Uploadapk setKey(String key) {
                return (Uploadapk)super.setKey(key);
            }

            public Uploadapk setOauthToken(String oauthToken) {
                return (Uploadapk)super.setOauthToken(oauthToken);
            }

            public Uploadapk setPrettyPrint(Boolean prettyPrint) {
                return (Uploadapk)super.setPrettyPrint(prettyPrint);
            }

            public Uploadapk setQuotaUser(String quotaUser) {
                return (Uploadapk)super.setQuotaUser(quotaUser);
            }

            public Uploadapk setUploadType(String uploadType) {
                return (Uploadapk)super.setUploadType(uploadType);
            }

            public Uploadapk setUploadProtocol(String uploadProtocol) {
                return (Uploadapk)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Uploadapk setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            @Override
            public Uploadapk set(String parameterName, Object value) {
                return (Uploadapk)super.set(parameterName, value);
            }
        }
    }

    public class Inappproducts {
        public BatchDelete batchDelete(String packageName, InappproductsBatchDeleteRequest content) throws IOException {
            BatchDelete result = new BatchDelete(packageName, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public BatchGet batchGet(String packageName) throws IOException {
            BatchGet result = new BatchGet(packageName);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public BatchUpdate batchUpdate(String packageName, InappproductsBatchUpdateRequest content) throws IOException {
            BatchUpdate result = new BatchUpdate(packageName, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String packageName, String sku) throws IOException {
            Delete result = new Delete(packageName, sku);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String packageName, String sku) throws IOException {
            Get result = new Get(packageName, sku);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String packageName, InAppProduct content) throws IOException {
            Insert result = new Insert(packageName, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String packageName) throws IOException {
            List result = new List(packageName);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String packageName, String sku, InAppProduct content) throws IOException {
            Patch result = new Patch(packageName, sku, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String packageName, String sku, InAppProduct content) throws IOException {
            Update result = new Update(packageName, sku, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;
            @Key
            private Boolean allowMissing;
            @Key
            private Boolean autoConvertMissingPrices;
            @Key
            private String latencyTolerance;

            protected Update(String packageName, String sku, InAppProduct content) {
                super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)sku, (Object)"Required parameter sku must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Update setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Update setSku(String sku) {
                this.sku = sku;
                return this;
            }

            public Boolean getAllowMissing() {
                return this.allowMissing;
            }

            public Update setAllowMissing(Boolean allowMissing) {
                this.allowMissing = allowMissing;
                return this;
            }

            public Boolean getAutoConvertMissingPrices() {
                return this.autoConvertMissingPrices;
            }

            public Update setAutoConvertMissingPrices(Boolean autoConvertMissingPrices) {
                this.autoConvertMissingPrices = autoConvertMissingPrices;
                return this;
            }

            public String getLatencyTolerance() {
                return this.latencyTolerance;
            }

            public Update setLatencyTolerance(String latencyTolerance) {
                this.latencyTolerance = latencyTolerance;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;
            @Key
            private Boolean autoConvertMissingPrices;
            @Key
            private String latencyTolerance;

            protected Patch(String packageName, String sku, InAppProduct content) {
                super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)sku, (Object)"Required parameter sku must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Patch setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Patch setSku(String sku) {
                this.sku = sku;
                return this;
            }

            public Boolean getAutoConvertMissingPrices() {
                return this.autoConvertMissingPrices;
            }

            public Patch setAutoConvertMissingPrices(Boolean autoConvertMissingPrices) {
                this.autoConvertMissingPrices = autoConvertMissingPrices;
                return this;
            }

            public String getLatencyTolerance() {
                return this.latencyTolerance;
            }

            public Patch setLatencyTolerance(String latencyTolerance) {
                this.latencyTolerance = latencyTolerance;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends AndroidPublisherRequest<InappproductsListResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts";
            @Key
            private String packageName;
            @Key
            private Long maxResults;
            @Key
            private Long startIndex;
            @Key
            private String token;

            protected List(String packageName) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, InappproductsListResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public List setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Long getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(Long startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            public String getToken() {
                return this.token;
            }

            public List setToken(String token) {
                this.token = token;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts";
            @Key
            private String packageName;
            @Key
            private Boolean autoConvertMissingPrices;

            protected Insert(String packageName, InAppProduct content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Insert setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Boolean getAutoConvertMissingPrices() {
                return this.autoConvertMissingPrices;
            }

            public Insert setAutoConvertMissingPrices(Boolean autoConvertMissingPrices) {
                this.autoConvertMissingPrices = autoConvertMissingPrices;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends AndroidPublisherRequest<InAppProduct> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;

            protected Get(String packageName, String sku) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, InAppProduct.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)sku, (Object)"Required parameter sku must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Get setSku(String sku) {
                this.sku = sku;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}";
            @Key
            private String packageName;
            @Key
            private String sku;
            @Key
            private String latencyTolerance;

            protected Delete(String packageName, String sku) {
                super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.sku = (String)Preconditions.checkNotNull((Object)sku, (Object)"Required parameter sku must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Delete setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getSku() {
                return this.sku;
            }

            public Delete setSku(String sku) {
                this.sku = sku;
                return this;
            }

            public String getLatencyTolerance() {
                return this.latencyTolerance;
            }

            public Delete setLatencyTolerance(String latencyTolerance) {
                this.latencyTolerance = latencyTolerance;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class BatchUpdate
        extends AndroidPublisherRequest<InappproductsBatchUpdateResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts:batchUpdate";
            @Key
            private String packageName;

            protected BatchUpdate(String packageName, InappproductsBatchUpdateRequest content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, InappproductsBatchUpdateResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public BatchUpdate set$Xgafv(String $Xgafv) {
                return (BatchUpdate)super.set$Xgafv($Xgafv);
            }

            public BatchUpdate setAccessToken(String accessToken) {
                return (BatchUpdate)super.setAccessToken(accessToken);
            }

            public BatchUpdate setAlt(String alt) {
                return (BatchUpdate)super.setAlt(alt);
            }

            public BatchUpdate setCallback(String callback) {
                return (BatchUpdate)super.setCallback(callback);
            }

            public BatchUpdate setFields(String fields) {
                return (BatchUpdate)super.setFields(fields);
            }

            public BatchUpdate setKey(String key) {
                return (BatchUpdate)super.setKey(key);
            }

            public BatchUpdate setOauthToken(String oauthToken) {
                return (BatchUpdate)super.setOauthToken(oauthToken);
            }

            public BatchUpdate setPrettyPrint(Boolean prettyPrint) {
                return (BatchUpdate)super.setPrettyPrint(prettyPrint);
            }

            public BatchUpdate setQuotaUser(String quotaUser) {
                return (BatchUpdate)super.setQuotaUser(quotaUser);
            }

            public BatchUpdate setUploadType(String uploadType) {
                return (BatchUpdate)super.setUploadType(uploadType);
            }

            public BatchUpdate setUploadProtocol(String uploadProtocol) {
                return (BatchUpdate)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public BatchUpdate setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            @Override
            public BatchUpdate set(String parameterName, Object value) {
                return (BatchUpdate)super.set(parameterName, value);
            }
        }

        public class BatchGet
        extends AndroidPublisherRequest<InappproductsBatchGetResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts:batchGet";
            @Key
            private String packageName;
            @Key
            private java.util.List<String> sku;

            protected BatchGet(String packageName) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, InappproductsBatchGetResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public BatchGet set$Xgafv(String $Xgafv) {
                return (BatchGet)super.set$Xgafv($Xgafv);
            }

            public BatchGet setAccessToken(String accessToken) {
                return (BatchGet)super.setAccessToken(accessToken);
            }

            public BatchGet setAlt(String alt) {
                return (BatchGet)super.setAlt(alt);
            }

            public BatchGet setCallback(String callback) {
                return (BatchGet)super.setCallback(callback);
            }

            public BatchGet setFields(String fields) {
                return (BatchGet)super.setFields(fields);
            }

            public BatchGet setKey(String key) {
                return (BatchGet)super.setKey(key);
            }

            public BatchGet setOauthToken(String oauthToken) {
                return (BatchGet)super.setOauthToken(oauthToken);
            }

            public BatchGet setPrettyPrint(Boolean prettyPrint) {
                return (BatchGet)super.setPrettyPrint(prettyPrint);
            }

            public BatchGet setQuotaUser(String quotaUser) {
                return (BatchGet)super.setQuotaUser(quotaUser);
            }

            public BatchGet setUploadType(String uploadType) {
                return (BatchGet)super.setUploadType(uploadType);
            }

            public BatchGet setUploadProtocol(String uploadProtocol) {
                return (BatchGet)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public BatchGet setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public java.util.List<String> getSku() {
                return this.sku;
            }

            public BatchGet setSku(java.util.List<String> sku) {
                this.sku = sku;
                return this;
            }

            @Override
            public BatchGet set(String parameterName, Object value) {
                return (BatchGet)super.set(parameterName, value);
            }
        }

        public class BatchDelete
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/inappproducts:batchDelete";
            @Key
            private String packageName;

            protected BatchDelete(String packageName, InappproductsBatchDeleteRequest content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public BatchDelete set$Xgafv(String $Xgafv) {
                return (BatchDelete)super.set$Xgafv($Xgafv);
            }

            public BatchDelete setAccessToken(String accessToken) {
                return (BatchDelete)super.setAccessToken(accessToken);
            }

            public BatchDelete setAlt(String alt) {
                return (BatchDelete)super.setAlt(alt);
            }

            public BatchDelete setCallback(String callback) {
                return (BatchDelete)super.setCallback(callback);
            }

            public BatchDelete setFields(String fields) {
                return (BatchDelete)super.setFields(fields);
            }

            public BatchDelete setKey(String key) {
                return (BatchDelete)super.setKey(key);
            }

            public BatchDelete setOauthToken(String oauthToken) {
                return (BatchDelete)super.setOauthToken(oauthToken);
            }

            public BatchDelete setPrettyPrint(Boolean prettyPrint) {
                return (BatchDelete)super.setPrettyPrint(prettyPrint);
            }

            public BatchDelete setQuotaUser(String quotaUser) {
                return (BatchDelete)super.setQuotaUser(quotaUser);
            }

            public BatchDelete setUploadType(String uploadType) {
                return (BatchDelete)super.setUploadType(uploadType);
            }

            public BatchDelete setUploadProtocol(String uploadProtocol) {
                return (BatchDelete)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public BatchDelete setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            @Override
            public BatchDelete set(String parameterName, Object value) {
                return (BatchDelete)super.set(parameterName, value);
            }
        }
    }

    public class Grants {
        public Create create(String parent, Grant content) throws IOException {
            Create result = new Create(parent, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, Grant content) throws IOException {
            Patch result = new Patch(name, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends AndroidPublisherRequest<Grant> {
            private static final String REST_PATH = "androidpublisher/v3/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected Patch(String name, Grant content) {
                super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, Grant.class);
                this.NAME_PATTERN = Pattern.compile("^developers/[^/]+/users/[^/]+/grants/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^developers/[^/]+/users/[^/]+/grants/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^developers/[^/]+/users/[^/]+/grants/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Delete
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "androidpublisher/v3/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                this.NAME_PATTERN = Pattern.compile("^developers/[^/]+/users/[^/]+/grants/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^developers/[^/]+/users/[^/]+/grants/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^developers/[^/]+/users/[^/]+/grants/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends AndroidPublisherRequest<Grant> {
            private static final String REST_PATH = "androidpublisher/v3/{+parent}/grants";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected Create(String parent, Grant content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, Grant.class);
                this.PARENT_PATTERN = Pattern.compile("^developers/[^/]+/users/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^developers/[^/]+/users/[^/]+$");
                }
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public Create setParent(String parent) {
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^developers/[^/]+/users/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Generatedapks {
        public Download download(String packageName, Integer versionCode, String downloadId) throws IOException {
            Download result = new Download(packageName, versionCode, downloadId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String packageName, Integer versionCode) throws IOException {
            List result = new List(packageName, versionCode);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends AndroidPublisherRequest<GeneratedApksListResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/generatedApks/{versionCode}";
            @Key
            private String packageName;
            @Key
            private Integer versionCode;

            protected List(String packageName, Integer versionCode) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, GeneratedApksListResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.versionCode = (Integer)Preconditions.checkNotNull((Object)versionCode, (Object)"Required parameter versionCode must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public List setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Integer getVersionCode() {
                return this.versionCode;
            }

            public List setVersionCode(Integer versionCode) {
                this.versionCode = versionCode;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Download
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/generatedApks/{versionCode}/downloads/{downloadId}:download";
            @Key
            private String packageName;
            @Key
            private Integer versionCode;
            @Key
            private String downloadId;

            protected Download(String packageName, Integer versionCode, String downloadId) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.versionCode = (Integer)Preconditions.checkNotNull((Object)versionCode, (Object)"Required parameter versionCode must be specified.");
                this.downloadId = (String)Preconditions.checkNotNull((Object)downloadId, (Object)"Required parameter downloadId must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public GenericUrl buildHttpRequestUrl() {
                String baseUrl = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? AndroidPublisher.this.getRootUrl() + "download/" + AndroidPublisher.this.getServicePath() : AndroidPublisher.this.getBaseUrl();
                return new GenericUrl(UriTemplate.expand((String)baseUrl, (String)this.getUriTemplate(), (Object)((Object)this), (boolean)true));
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Download set$Xgafv(String $Xgafv) {
                return (Download)super.set$Xgafv($Xgafv);
            }

            public Download setAccessToken(String accessToken) {
                return (Download)super.setAccessToken(accessToken);
            }

            public Download setAlt(String alt) {
                return (Download)super.setAlt(alt);
            }

            public Download setCallback(String callback) {
                return (Download)super.setCallback(callback);
            }

            public Download setFields(String fields) {
                return (Download)super.setFields(fields);
            }

            public Download setKey(String key) {
                return (Download)super.setKey(key);
            }

            public Download setOauthToken(String oauthToken) {
                return (Download)super.setOauthToken(oauthToken);
            }

            public Download setPrettyPrint(Boolean prettyPrint) {
                return (Download)super.setPrettyPrint(prettyPrint);
            }

            public Download setQuotaUser(String quotaUser) {
                return (Download)super.setQuotaUser(quotaUser);
            }

            public Download setUploadType(String uploadType) {
                return (Download)super.setUploadType(uploadType);
            }

            public Download setUploadProtocol(String uploadProtocol) {
                return (Download)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Download setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Integer getVersionCode() {
                return this.versionCode;
            }

            public Download setVersionCode(Integer versionCode) {
                this.versionCode = versionCode;
                return this;
            }

            public String getDownloadId() {
                return this.downloadId;
            }

            public Download setDownloadId(String downloadId) {
                this.downloadId = downloadId;
                return this;
            }

            @Override
            public Download set(String parameterName, Object value) {
                return (Download)super.set(parameterName, value);
            }
        }
    }

    public class Externaltransactions {
        public Createexternaltransaction createexternaltransaction(String parent, ExternalTransaction content) throws IOException {
            Createexternaltransaction result = new Createexternaltransaction(parent, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Getexternaltransaction getexternaltransaction(String name) throws IOException {
            Getexternaltransaction result = new Getexternaltransaction(name);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Refundexternaltransaction refundexternaltransaction(String name, RefundExternalTransactionRequest content) throws IOException {
            Refundexternaltransaction result = new Refundexternaltransaction(name, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Refundexternaltransaction
        extends AndroidPublisherRequest<ExternalTransaction> {
            private static final String REST_PATH = "androidpublisher/v3/{+name}:refund";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Refundexternaltransaction(String name, RefundExternalTransactionRequest content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, ExternalTransaction.class);
                this.NAME_PATTERN = Pattern.compile("^applications/[^/]+/externalTransactions/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^applications/[^/]+/externalTransactions/[^/]+$");
                }
            }

            public Refundexternaltransaction set$Xgafv(String $Xgafv) {
                return (Refundexternaltransaction)super.set$Xgafv($Xgafv);
            }

            public Refundexternaltransaction setAccessToken(String accessToken) {
                return (Refundexternaltransaction)super.setAccessToken(accessToken);
            }

            public Refundexternaltransaction setAlt(String alt) {
                return (Refundexternaltransaction)super.setAlt(alt);
            }

            public Refundexternaltransaction setCallback(String callback) {
                return (Refundexternaltransaction)super.setCallback(callback);
            }

            public Refundexternaltransaction setFields(String fields) {
                return (Refundexternaltransaction)super.setFields(fields);
            }

            public Refundexternaltransaction setKey(String key) {
                return (Refundexternaltransaction)super.setKey(key);
            }

            public Refundexternaltransaction setOauthToken(String oauthToken) {
                return (Refundexternaltransaction)super.setOauthToken(oauthToken);
            }

            public Refundexternaltransaction setPrettyPrint(Boolean prettyPrint) {
                return (Refundexternaltransaction)super.setPrettyPrint(prettyPrint);
            }

            public Refundexternaltransaction setQuotaUser(String quotaUser) {
                return (Refundexternaltransaction)super.setQuotaUser(quotaUser);
            }

            public Refundexternaltransaction setUploadType(String uploadType) {
                return (Refundexternaltransaction)super.setUploadType(uploadType);
            }

            public Refundexternaltransaction setUploadProtocol(String uploadProtocol) {
                return (Refundexternaltransaction)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Refundexternaltransaction setName(String name) {
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^applications/[^/]+/externalTransactions/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Refundexternaltransaction set(String parameterName, Object value) {
                return (Refundexternaltransaction)super.set(parameterName, value);
            }
        }

        public class Getexternaltransaction
        extends AndroidPublisherRequest<ExternalTransaction> {
            private static final String REST_PATH = "androidpublisher/v3/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Getexternaltransaction(String name) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, ExternalTransaction.class);
                this.NAME_PATTERN = Pattern.compile("^applications/[^/]+/externalTransactions/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^applications/[^/]+/externalTransactions/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getexternaltransaction set$Xgafv(String $Xgafv) {
                return (Getexternaltransaction)super.set$Xgafv($Xgafv);
            }

            public Getexternaltransaction setAccessToken(String accessToken) {
                return (Getexternaltransaction)super.setAccessToken(accessToken);
            }

            public Getexternaltransaction setAlt(String alt) {
                return (Getexternaltransaction)super.setAlt(alt);
            }

            public Getexternaltransaction setCallback(String callback) {
                return (Getexternaltransaction)super.setCallback(callback);
            }

            public Getexternaltransaction setFields(String fields) {
                return (Getexternaltransaction)super.setFields(fields);
            }

            public Getexternaltransaction setKey(String key) {
                return (Getexternaltransaction)super.setKey(key);
            }

            public Getexternaltransaction setOauthToken(String oauthToken) {
                return (Getexternaltransaction)super.setOauthToken(oauthToken);
            }

            public Getexternaltransaction setPrettyPrint(Boolean prettyPrint) {
                return (Getexternaltransaction)super.setPrettyPrint(prettyPrint);
            }

            public Getexternaltransaction setQuotaUser(String quotaUser) {
                return (Getexternaltransaction)super.setQuotaUser(quotaUser);
            }

            public Getexternaltransaction setUploadType(String uploadType) {
                return (Getexternaltransaction)super.setUploadType(uploadType);
            }

            public Getexternaltransaction setUploadProtocol(String uploadProtocol) {
                return (Getexternaltransaction)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Getexternaltransaction setName(String name) {
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^applications/[^/]+/externalTransactions/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Getexternaltransaction set(String parameterName, Object value) {
                return (Getexternaltransaction)super.set(parameterName, value);
            }
        }

        public class Createexternaltransaction
        extends AndroidPublisherRequest<ExternalTransaction> {
            private static final String REST_PATH = "androidpublisher/v3/{+parent}/externalTransactions";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String externalTransactionId;

            protected Createexternaltransaction(String parent, ExternalTransaction content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, ExternalTransaction.class);
                this.PARENT_PATTERN = Pattern.compile("^applications/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^applications/[^/]+$");
                }
            }

            public Createexternaltransaction set$Xgafv(String $Xgafv) {
                return (Createexternaltransaction)super.set$Xgafv($Xgafv);
            }

            public Createexternaltransaction setAccessToken(String accessToken) {
                return (Createexternaltransaction)super.setAccessToken(accessToken);
            }

            public Createexternaltransaction setAlt(String alt) {
                return (Createexternaltransaction)super.setAlt(alt);
            }

            public Createexternaltransaction setCallback(String callback) {
                return (Createexternaltransaction)super.setCallback(callback);
            }

            public Createexternaltransaction setFields(String fields) {
                return (Createexternaltransaction)super.setFields(fields);
            }

            public Createexternaltransaction setKey(String key) {
                return (Createexternaltransaction)super.setKey(key);
            }

            public Createexternaltransaction setOauthToken(String oauthToken) {
                return (Createexternaltransaction)super.setOauthToken(oauthToken);
            }

            public Createexternaltransaction setPrettyPrint(Boolean prettyPrint) {
                return (Createexternaltransaction)super.setPrettyPrint(prettyPrint);
            }

            public Createexternaltransaction setQuotaUser(String quotaUser) {
                return (Createexternaltransaction)super.setQuotaUser(quotaUser);
            }

            public Createexternaltransaction setUploadType(String uploadType) {
                return (Createexternaltransaction)super.setUploadType(uploadType);
            }

            public Createexternaltransaction setUploadProtocol(String uploadProtocol) {
                return (Createexternaltransaction)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public Createexternaltransaction setParent(String parent) {
                if (!AndroidPublisher.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^applications/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public String getExternalTransactionId() {
                return this.externalTransactionId;
            }

            public Createexternaltransaction setExternalTransactionId(String externalTransactionId) {
                this.externalTransactionId = externalTransactionId;
                return this;
            }

            @Override
            public Createexternaltransaction set(String parameterName, Object value) {
                return (Createexternaltransaction)super.set(parameterName, value);
            }
        }
    }

    public class Edits {
        public Commit commit(String packageName, String editId) throws IOException {
            Commit result = new Commit(packageName, editId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String packageName, String editId) throws IOException {
            Delete result = new Delete(packageName, editId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String packageName, String editId) throws IOException {
            Get result = new Get(packageName, editId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String packageName, AppEdit content) throws IOException {
            Insert result = new Insert(packageName, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Validate validate(String packageName, String editId) throws IOException {
            Validate result = new Validate(packageName, editId);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Apks apks() {
            return new Apks();
        }

        public Bundles bundles() {
            return new Bundles();
        }

        public Countryavailability countryavailability() {
            return new Countryavailability();
        }

        public Deobfuscationfiles deobfuscationfiles() {
            return new Deobfuscationfiles();
        }

        public Details details() {
            return new Details();
        }

        public Expansionfiles expansionfiles() {
            return new Expansionfiles();
        }

        public Images images() {
            return new Images();
        }

        public Listings listings() {
            return new Listings();
        }

        public Testers testers() {
            return new Testers();
        }

        public Tracks tracks() {
            return new Tracks();
        }

        public class Tracks {
            public Create create(String packageName, String editId, TrackConfig content) throws IOException {
                Create result = new Create(packageName, editId, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String packageName, String editId, String track) throws IOException {
                Get result = new Get(packageName, editId, track);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String packageName, String editId) throws IOException {
                List result = new List(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String packageName, String editId, String track, Track content) throws IOException {
                Patch result = new Patch(packageName, editId, track, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String packageName, String editId, String track, Track content) throws IOException {
                Update result = new Update(packageName, editId, track, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AndroidPublisherRequest<Track> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Update(String packageName, String editId, String track, Track content) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, Track.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Update setTrack(String track) {
                    this.track = track;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AndroidPublisherRequest<Track> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Patch(String packageName, String editId, String track, Track content) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, Track.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Patch setTrack(String track) {
                    this.track = track;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AndroidPublisherRequest<TracksListResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String packageName, String editId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, TracksListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<Track> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Get(String packageName, String editId, String track) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, Track.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Get setTrack(String track) {
                    this.track = track;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends AndroidPublisherRequest<Track> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Create(String packageName, String editId, TrackConfig content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, Track.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Create setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Create setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Testers {
            public Get get(String packageName, String editId, String track) throws IOException {
                Get result = new Get(packageName, editId, track);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String packageName, String editId, String track, com.google.api.services.androidpublisher.model.Testers content) throws IOException {
                Patch result = new Patch(packageName, editId, track, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String packageName, String editId, String track, com.google.api.services.androidpublisher.model.Testers content) throws IOException {
                Update result = new Update(packageName, editId, track, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Update(String packageName, String editId, String track, com.google.api.services.androidpublisher.model.Testers content) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, com.google.api.services.androidpublisher.model.Testers.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Update setTrack(String track) {
                    this.track = track;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Patch(String packageName, String editId, String track, com.google.api.services.androidpublisher.model.Testers content) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.androidpublisher.model.Testers.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Patch setTrack(String track) {
                    this.track = track;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<com.google.api.services.androidpublisher.model.Testers> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Get(String packageName, String editId, String track) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, com.google.api.services.androidpublisher.model.Testers.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Get setTrack(String track) {
                    this.track = track;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Listings {
            public Delete delete(String packageName, String editId, String language) throws IOException {
                Delete result = new Delete(packageName, editId, language);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Deleteall deleteall(String packageName, String editId) throws IOException {
                Deleteall result = new Deleteall(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String packageName, String editId, String language) throws IOException {
                Get result = new Get(packageName, editId, language);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String packageName, String editId) throws IOException {
                List result = new List(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String packageName, String editId, String language, Listing content) throws IOException {
                Patch result = new Patch(packageName, editId, language, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String packageName, String editId, String language, Listing content) throws IOException {
                Update result = new Update(packageName, editId, language, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AndroidPublisherRequest<Listing> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Update(String packageName, String editId, String language, Listing content) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, Listing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Update setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AndroidPublisherRequest<Listing> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Patch(String packageName, String editId, String language, Listing content) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, Listing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Patch setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AndroidPublisherRequest<ListingsListResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String packageName, String editId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ListingsListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<Listing> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Get(String packageName, String editId, String language) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, Listing.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Get setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Deleteall
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Deleteall(String packageName, String editId) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public Deleteall set$Xgafv(String $Xgafv) {
                    return (Deleteall)super.set$Xgafv($Xgafv);
                }

                public Deleteall setAccessToken(String accessToken) {
                    return (Deleteall)super.setAccessToken(accessToken);
                }

                public Deleteall setAlt(String alt) {
                    return (Deleteall)super.setAlt(alt);
                }

                public Deleteall setCallback(String callback) {
                    return (Deleteall)super.setCallback(callback);
                }

                public Deleteall setFields(String fields) {
                    return (Deleteall)super.setFields(fields);
                }

                public Deleteall setKey(String key) {
                    return (Deleteall)super.setKey(key);
                }

                public Deleteall setOauthToken(String oauthToken) {
                    return (Deleteall)super.setOauthToken(oauthToken);
                }

                public Deleteall setPrettyPrint(Boolean prettyPrint) {
                    return (Deleteall)super.setPrettyPrint(prettyPrint);
                }

                public Deleteall setQuotaUser(String quotaUser) {
                    return (Deleteall)super.setQuotaUser(quotaUser);
                }

                public Deleteall setUploadType(String uploadType) {
                    return (Deleteall)super.setUploadType(uploadType);
                }

                public Deleteall setUploadProtocol(String uploadProtocol) {
                    return (Deleteall)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Deleteall setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Deleteall setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Deleteall set(String parameterName, Object value) {
                    return (Deleteall)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;

                protected Delete(String packageName, String editId, String language) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Delete setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Delete setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Delete setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Images {
            public Delete delete(String packageName, String editId, String language, String imageType, String imageId) throws IOException {
                Delete result = new Delete(packageName, editId, language, imageType, imageId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Deleteall deleteall(String packageName, String editId, String language, String imageType) throws IOException {
                Deleteall result = new Deleteall(packageName, editId, language, imageType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String packageName, String editId, String language, String imageType) throws IOException {
                List result = new List(packageName, editId, language, imageType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, String language, String imageType) throws IOException {
                Upload result = new Upload(packageName, editId, language, imageType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, String language, String imageType, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(packageName, editId, language, imageType, mediaContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends AndroidPublisherRequest<ImagesUploadResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;

                protected Upload(String packageName, String editId, String language, String imageType) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, ImagesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)imageType, (Object)"Required parameter imageType must be specified.");
                }

                protected Upload(String packageName, String editId, String language, String imageType, AbstractInputStreamContent mediaContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, ImagesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)imageType, (Object)"Required parameter imageType must be specified.");
                    Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload set$Xgafv(String $Xgafv) {
                    return (Upload)super.set$Xgafv($Xgafv);
                }

                public Upload setAccessToken(String accessToken) {
                    return (Upload)super.setAccessToken(accessToken);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setCallback(String callback) {
                    return (Upload)super.setCallback(callback);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUploadType(String uploadType) {
                    return (Upload)super.setUploadType(uploadType);
                }

                public Upload setUploadProtocol(String uploadProtocol) {
                    return (Upload)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Upload setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public Upload setImageType(String imageType) {
                    this.imageType = imageType;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }

            public class List
            extends AndroidPublisherRequest<ImagesListResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;

                protected List(String packageName, String editId, String language, String imageType) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ImagesListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)imageType, (Object)"Required parameter imageType must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public List setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public List setImageType(String imageType) {
                    this.imageType = imageType;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Deleteall
            extends AndroidPublisherRequest<ImagesDeleteAllResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;

                protected Deleteall(String packageName, String editId, String language, String imageType) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, ImagesDeleteAllResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)imageType, (Object)"Required parameter imageType must be specified.");
                }

                public Deleteall set$Xgafv(String $Xgafv) {
                    return (Deleteall)super.set$Xgafv($Xgafv);
                }

                public Deleteall setAccessToken(String accessToken) {
                    return (Deleteall)super.setAccessToken(accessToken);
                }

                public Deleteall setAlt(String alt) {
                    return (Deleteall)super.setAlt(alt);
                }

                public Deleteall setCallback(String callback) {
                    return (Deleteall)super.setCallback(callback);
                }

                public Deleteall setFields(String fields) {
                    return (Deleteall)super.setFields(fields);
                }

                public Deleteall setKey(String key) {
                    return (Deleteall)super.setKey(key);
                }

                public Deleteall setOauthToken(String oauthToken) {
                    return (Deleteall)super.setOauthToken(oauthToken);
                }

                public Deleteall setPrettyPrint(Boolean prettyPrint) {
                    return (Deleteall)super.setPrettyPrint(prettyPrint);
                }

                public Deleteall setQuotaUser(String quotaUser) {
                    return (Deleteall)super.setQuotaUser(quotaUser);
                }

                public Deleteall setUploadType(String uploadType) {
                    return (Deleteall)super.setUploadType(uploadType);
                }

                public Deleteall setUploadProtocol(String uploadProtocol) {
                    return (Deleteall)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Deleteall setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Deleteall setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Deleteall setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public Deleteall setImageType(String imageType) {
                    this.imageType = imageType;
                    return this;
                }

                @Override
                public Deleteall set(String parameterName, Object value) {
                    return (Deleteall)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AndroidPublisherRequest<Void> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}/{imageId}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String language;
                @Key
                private String imageType;
                @Key
                private String imageId;

                protected Delete(String packageName, String editId, String language, String imageType, String imageId) {
                    super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                    this.imageType = (String)Preconditions.checkNotNull((Object)imageType, (Object)"Required parameter imageType must be specified.");
                    this.imageId = (String)Preconditions.checkNotNull((Object)imageId, (Object)"Required parameter imageId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Delete setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Delete setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getLanguage() {
                    return this.language;
                }

                public Delete setLanguage(String language) {
                    this.language = language;
                    return this;
                }

                public String getImageType() {
                    return this.imageType;
                }

                public Delete setImageType(String imageType) {
                    this.imageType = imageType;
                    return this;
                }

                public String getImageId() {
                    return this.imageId;
                }

                public Delete setImageId(String imageId) {
                    this.imageId = imageId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Expansionfiles {
            public Get get(String packageName, String editId, Integer apkVersionCode, String expansionFileType) throws IOException {
                Get result = new Get(packageName, editId, apkVersionCode, expansionFileType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String packageName, String editId, Integer apkVersionCode, String expansionFileType, ExpansionFile content) throws IOException {
                Patch result = new Patch(packageName, editId, apkVersionCode, expansionFileType, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String packageName, String editId, Integer apkVersionCode, String expansionFileType, ExpansionFile content) throws IOException {
                Update result = new Update(packageName, editId, apkVersionCode, expansionFileType, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, Integer apkVersionCode, String expansionFileType) throws IOException {
                Upload result = new Upload(packageName, editId, apkVersionCode, expansionFileType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, Integer apkVersionCode, String expansionFileType, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(packageName, editId, apkVersionCode, expansionFileType, mediaContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends AndroidPublisherRequest<ExpansionFilesUploadResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Upload(String packageName, String editId, Integer apkVersionCode, String expansionFileType) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, ExpansionFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)expansionFileType, (Object)"Required parameter expansionFileType must be specified.");
                }

                protected Upload(String packageName, String editId, Integer apkVersionCode, String expansionFileType, AbstractInputStreamContent mediaContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, ExpansionFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)expansionFileType, (Object)"Required parameter expansionFileType must be specified.");
                    Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload set$Xgafv(String $Xgafv) {
                    return (Upload)super.set$Xgafv($Xgafv);
                }

                public Upload setAccessToken(String accessToken) {
                    return (Upload)super.setAccessToken(accessToken);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setCallback(String callback) {
                    return (Upload)super.setCallback(callback);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUploadType(String uploadType) {
                    return (Upload)super.setUploadType(uploadType);
                }

                public Upload setUploadProtocol(String uploadProtocol) {
                    return (Upload)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Upload setApkVersionCode(Integer apkVersionCode) {
                    this.apkVersionCode = apkVersionCode;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Upload setExpansionFileType(String expansionFileType) {
                    this.expansionFileType = expansionFileType;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }

            public class Update
            extends AndroidPublisherRequest<ExpansionFile> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Update(String packageName, String editId, Integer apkVersionCode, String expansionFileType, ExpansionFile content) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, ExpansionFile.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)expansionFileType, (Object)"Required parameter expansionFileType must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Update setApkVersionCode(Integer apkVersionCode) {
                    this.apkVersionCode = apkVersionCode;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Update setExpansionFileType(String expansionFileType) {
                    this.expansionFileType = expansionFileType;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AndroidPublisherRequest<ExpansionFile> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Patch(String packageName, String editId, Integer apkVersionCode, String expansionFileType, ExpansionFile content) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, ExpansionFile.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)expansionFileType, (Object)"Required parameter expansionFileType must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Patch setApkVersionCode(Integer apkVersionCode) {
                    this.apkVersionCode = apkVersionCode;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Patch setExpansionFileType(String expansionFileType) {
                    this.expansionFileType = expansionFileType;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<ExpansionFile> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String expansionFileType;

                protected Get(String packageName, String editId, Integer apkVersionCode, String expansionFileType) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ExpansionFile.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.expansionFileType = (String)Preconditions.checkNotNull((Object)expansionFileType, (Object)"Required parameter expansionFileType must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Get setApkVersionCode(Integer apkVersionCode) {
                    this.apkVersionCode = apkVersionCode;
                    return this;
                }

                public String getExpansionFileType() {
                    return this.expansionFileType;
                }

                public Get setExpansionFileType(String expansionFileType) {
                    this.expansionFileType = expansionFileType;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Details {
            public Get get(String packageName, String editId) throws IOException {
                Get result = new Get(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String packageName, String editId, AppDetails content) throws IOException {
                Patch result = new Patch(packageName, editId, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String packageName, String editId, AppDetails content) throws IOException {
                Update result = new Update(packageName, editId, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AndroidPublisherRequest<AppDetails> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/details";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Update(String packageName, String editId, AppDetails content) {
                    super(AndroidPublisher.this, "PUT", REST_PATH, (Object)content, AppDetails.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Update setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Update setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AndroidPublisherRequest<AppDetails> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/details";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Patch(String packageName, String editId, AppDetails content) {
                    super(AndroidPublisher.this, "PATCH", REST_PATH, (Object)content, AppDetails.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Patch setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Patch setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<AppDetails> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/details";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Get(String packageName, String editId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, AppDetails.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Deobfuscationfiles {
            public Upload upload(String packageName, String editId, Integer apkVersionCode, String deobfuscationFileType) throws IOException {
                Upload result = new Upload(packageName, editId, apkVersionCode, deobfuscationFileType);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, Integer apkVersionCode, String deobfuscationFileType, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(packageName, editId, apkVersionCode, deobfuscationFileType, mediaContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends AndroidPublisherRequest<DeobfuscationFilesUploadResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/deobfuscationFiles/{deobfuscationFileType}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Integer apkVersionCode;
                @Key
                private String deobfuscationFileType;

                protected Upload(String packageName, String editId, Integer apkVersionCode, String deobfuscationFileType) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, DeobfuscationFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.deobfuscationFileType = (String)Preconditions.checkNotNull((Object)deobfuscationFileType, (Object)"Required parameter deobfuscationFileType must be specified.");
                }

                protected Upload(String packageName, String editId, Integer apkVersionCode, String deobfuscationFileType, AbstractInputStreamContent mediaContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, DeobfuscationFilesUploadResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.apkVersionCode = (Integer)Preconditions.checkNotNull((Object)apkVersionCode, (Object)"Required parameter apkVersionCode must be specified.");
                    this.deobfuscationFileType = (String)Preconditions.checkNotNull((Object)deobfuscationFileType, (Object)"Required parameter deobfuscationFileType must be specified.");
                    Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload set$Xgafv(String $Xgafv) {
                    return (Upload)super.set$Xgafv($Xgafv);
                }

                public Upload setAccessToken(String accessToken) {
                    return (Upload)super.setAccessToken(accessToken);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setCallback(String callback) {
                    return (Upload)super.setCallback(callback);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUploadType(String uploadType) {
                    return (Upload)super.setUploadType(uploadType);
                }

                public Upload setUploadProtocol(String uploadProtocol) {
                    return (Upload)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Integer getApkVersionCode() {
                    return this.apkVersionCode;
                }

                public Upload setApkVersionCode(Integer apkVersionCode) {
                    this.apkVersionCode = apkVersionCode;
                    return this;
                }

                public String getDeobfuscationFileType() {
                    return this.deobfuscationFileType;
                }

                public Upload setDeobfuscationFileType(String deobfuscationFileType) {
                    this.deobfuscationFileType = deobfuscationFileType;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }
        }

        public class Countryavailability {
            public Get get(String packageName, String editId, String track) throws IOException {
                Get result = new Get(packageName, editId, track);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends AndroidPublisherRequest<TrackCountryAvailability> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/countryAvailability/{track}";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private String track;

                protected Get(String packageName, String editId, String track) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, TrackCountryAvailability.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    this.track = (String)Preconditions.checkNotNull((Object)track, (Object)"Required parameter track must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Get setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public String getTrack() {
                    return this.track;
                }

                public Get setTrack(String track) {
                    this.track = track;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Bundles {
            public List list(String packageName, String editId) throws IOException {
                List result = new List(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId) throws IOException {
                Upload result = new Upload(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(packageName, editId, mediaContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends AndroidPublisherRequest<Bundle> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles";
                @Key
                private String packageName;
                @Key
                private String editId;
                @Key
                private Boolean ackBundleInstallationWarning;
                @Key
                private String deviceTierConfigId;

                protected Upload(String packageName, String editId) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Bundle.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                protected Upload(String packageName, String editId, AbstractInputStreamContent mediaContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, Bundle.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload set$Xgafv(String $Xgafv) {
                    return (Upload)super.set$Xgafv($Xgafv);
                }

                public Upload setAccessToken(String accessToken) {
                    return (Upload)super.setAccessToken(accessToken);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setCallback(String callback) {
                    return (Upload)super.setCallback(callback);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUploadType(String uploadType) {
                    return (Upload)super.setUploadType(uploadType);
                }

                public Upload setUploadProtocol(String uploadProtocol) {
                    return (Upload)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                public Boolean getAckBundleInstallationWarning() {
                    return this.ackBundleInstallationWarning;
                }

                public Upload setAckBundleInstallationWarning(Boolean ackBundleInstallationWarning) {
                    this.ackBundleInstallationWarning = ackBundleInstallationWarning;
                    return this;
                }

                public String getDeviceTierConfigId() {
                    return this.deviceTierConfigId;
                }

                public Upload setDeviceTierConfigId(String deviceTierConfigId) {
                    this.deviceTierConfigId = deviceTierConfigId;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }

            public class List
            extends AndroidPublisherRequest<BundlesListResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String packageName, String editId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, BundlesListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Apks {
            public Addexternallyhosted addexternallyhosted(String packageName, String editId, ApksAddExternallyHostedRequest content) throws IOException {
                Addexternallyhosted result = new Addexternallyhosted(packageName, editId, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String packageName, String editId) throws IOException {
                List result = new List(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId) throws IOException {
                Upload result = new Upload(packageName, editId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Upload upload(String packageName, String editId, AbstractInputStreamContent mediaContent) throws IOException {
                Upload result = new Upload(packageName, editId, mediaContent);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upload
            extends AndroidPublisherRequest<Apk> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Upload(String packageName, String editId) {
                    super(AndroidPublisher.this, "POST", REST_PATH, null, Apk.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                protected Upload(String packageName, String editId, AbstractInputStreamContent mediaContent) {
                    super(AndroidPublisher.this, "POST", "/upload/" + AndroidPublisher.this.getServicePath() + REST_PATH, null, Apk.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                    Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Upload set$Xgafv(String $Xgafv) {
                    return (Upload)super.set$Xgafv($Xgafv);
                }

                public Upload setAccessToken(String accessToken) {
                    return (Upload)super.setAccessToken(accessToken);
                }

                public Upload setAlt(String alt) {
                    return (Upload)super.setAlt(alt);
                }

                public Upload setCallback(String callback) {
                    return (Upload)super.setCallback(callback);
                }

                public Upload setFields(String fields) {
                    return (Upload)super.setFields(fields);
                }

                public Upload setKey(String key) {
                    return (Upload)super.setKey(key);
                }

                public Upload setOauthToken(String oauthToken) {
                    return (Upload)super.setOauthToken(oauthToken);
                }

                public Upload setPrettyPrint(Boolean prettyPrint) {
                    return (Upload)super.setPrettyPrint(prettyPrint);
                }

                public Upload setQuotaUser(String quotaUser) {
                    return (Upload)super.setQuotaUser(quotaUser);
                }

                public Upload setUploadType(String uploadType) {
                    return (Upload)super.setUploadType(uploadType);
                }

                public Upload setUploadProtocol(String uploadProtocol) {
                    return (Upload)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Upload setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Upload setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Upload set(String parameterName, Object value) {
                    return (Upload)super.set(parameterName, value);
                }
            }

            public class List
            extends AndroidPublisherRequest<ApksListResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected List(String packageName, String editId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ApksListResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public List setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Addexternallyhosted
            extends AndroidPublisherRequest<ApksAddExternallyHostedResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/externallyHosted";
                @Key
                private String packageName;
                @Key
                private String editId;

                protected Addexternallyhosted(String packageName, String editId, ApksAddExternallyHostedRequest content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, ApksAddExternallyHostedResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
                }

                public Addexternallyhosted set$Xgafv(String $Xgafv) {
                    return (Addexternallyhosted)super.set$Xgafv($Xgafv);
                }

                public Addexternallyhosted setAccessToken(String accessToken) {
                    return (Addexternallyhosted)super.setAccessToken(accessToken);
                }

                public Addexternallyhosted setAlt(String alt) {
                    return (Addexternallyhosted)super.setAlt(alt);
                }

                public Addexternallyhosted setCallback(String callback) {
                    return (Addexternallyhosted)super.setCallback(callback);
                }

                public Addexternallyhosted setFields(String fields) {
                    return (Addexternallyhosted)super.setFields(fields);
                }

                public Addexternallyhosted setKey(String key) {
                    return (Addexternallyhosted)super.setKey(key);
                }

                public Addexternallyhosted setOauthToken(String oauthToken) {
                    return (Addexternallyhosted)super.setOauthToken(oauthToken);
                }

                public Addexternallyhosted setPrettyPrint(Boolean prettyPrint) {
                    return (Addexternallyhosted)super.setPrettyPrint(prettyPrint);
                }

                public Addexternallyhosted setQuotaUser(String quotaUser) {
                    return (Addexternallyhosted)super.setQuotaUser(quotaUser);
                }

                public Addexternallyhosted setUploadType(String uploadType) {
                    return (Addexternallyhosted)super.setUploadType(uploadType);
                }

                public Addexternallyhosted setUploadProtocol(String uploadProtocol) {
                    return (Addexternallyhosted)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Addexternallyhosted setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public String getEditId() {
                    return this.editId;
                }

                public Addexternallyhosted setEditId(String editId) {
                    this.editId = editId;
                    return this;
                }

                @Override
                public Addexternallyhosted set(String parameterName, Object value) {
                    return (Addexternallyhosted)super.set(parameterName, value);
                }
            }
        }

        public class Validate
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}:validate";
            @Key
            private String packageName;
            @Key
            private String editId;

            protected Validate(String packageName, String editId) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
            }

            public Validate set$Xgafv(String $Xgafv) {
                return (Validate)super.set$Xgafv($Xgafv);
            }

            public Validate setAccessToken(String accessToken) {
                return (Validate)super.setAccessToken(accessToken);
            }

            public Validate setAlt(String alt) {
                return (Validate)super.setAlt(alt);
            }

            public Validate setCallback(String callback) {
                return (Validate)super.setCallback(callback);
            }

            public Validate setFields(String fields) {
                return (Validate)super.setFields(fields);
            }

            public Validate setKey(String key) {
                return (Validate)super.setKey(key);
            }

            public Validate setOauthToken(String oauthToken) {
                return (Validate)super.setOauthToken(oauthToken);
            }

            public Validate setPrettyPrint(Boolean prettyPrint) {
                return (Validate)super.setPrettyPrint(prettyPrint);
            }

            public Validate setQuotaUser(String quotaUser) {
                return (Validate)super.setQuotaUser(quotaUser);
            }

            public Validate setUploadType(String uploadType) {
                return (Validate)super.setUploadType(uploadType);
            }

            public Validate setUploadProtocol(String uploadProtocol) {
                return (Validate)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Validate setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Validate setEditId(String editId) {
                this.editId = editId;
                return this;
            }

            @Override
            public Validate set(String parameterName, Object value) {
                return (Validate)super.set(parameterName, value);
            }
        }

        public class Insert
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits";
            @Key
            private String packageName;

            protected Insert(String packageName, AppEdit content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Insert setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}";
            @Key
            private String packageName;
            @Key
            private String editId;

            protected Get(String packageName, String editId) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Get setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Get setEditId(String editId) {
                this.editId = editId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends AndroidPublisherRequest<Void> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}";
            @Key
            private String packageName;
            @Key
            private String editId;

            protected Delete(String packageName, String editId) {
                super(AndroidPublisher.this, "DELETE", REST_PATH, null, Void.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Delete setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Delete setEditId(String editId) {
                this.editId = editId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Commit
        extends AndroidPublisherRequest<AppEdit> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/edits/{editId}:commit";
            @Key
            private String packageName;
            @Key
            private String editId;
            @Key
            private Boolean changesNotSentForReview;

            protected Commit(String packageName, String editId) {
                super(AndroidPublisher.this, "POST", REST_PATH, null, AppEdit.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.editId = (String)Preconditions.checkNotNull((Object)editId, (Object)"Required parameter editId must be specified.");
            }

            public Commit set$Xgafv(String $Xgafv) {
                return (Commit)super.set$Xgafv($Xgafv);
            }

            public Commit setAccessToken(String accessToken) {
                return (Commit)super.setAccessToken(accessToken);
            }

            public Commit setAlt(String alt) {
                return (Commit)super.setAlt(alt);
            }

            public Commit setCallback(String callback) {
                return (Commit)super.setCallback(callback);
            }

            public Commit setFields(String fields) {
                return (Commit)super.setFields(fields);
            }

            public Commit setKey(String key) {
                return (Commit)super.setKey(key);
            }

            public Commit setOauthToken(String oauthToken) {
                return (Commit)super.setOauthToken(oauthToken);
            }

            public Commit setPrettyPrint(Boolean prettyPrint) {
                return (Commit)super.setPrettyPrint(prettyPrint);
            }

            public Commit setQuotaUser(String quotaUser) {
                return (Commit)super.setQuotaUser(quotaUser);
            }

            public Commit setUploadType(String uploadType) {
                return (Commit)super.setUploadType(uploadType);
            }

            public Commit setUploadProtocol(String uploadProtocol) {
                return (Commit)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Commit setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public String getEditId() {
                return this.editId;
            }

            public Commit setEditId(String editId) {
                this.editId = editId;
                return this;
            }

            public Boolean getChangesNotSentForReview() {
                return this.changesNotSentForReview;
            }

            public Commit setChangesNotSentForReview(Boolean changesNotSentForReview) {
                this.changesNotSentForReview = changesNotSentForReview;
                return this;
            }

            @Override
            public Commit set(String parameterName, Object value) {
                return (Commit)super.set(parameterName, value);
            }
        }
    }

    public class Apprecovery {
        public AddTargeting addTargeting(String packageName, Long appRecoveryId, AddTargetingRequest content) throws IOException {
            AddTargeting result = new AddTargeting(packageName, appRecoveryId, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Cancel cancel(String packageName, Long appRecoveryId, CancelAppRecoveryRequest content) throws IOException {
            Cancel result = new Cancel(packageName, appRecoveryId, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(String packageName, CreateDraftAppRecoveryRequest content) throws IOException {
            Create result = new Create(packageName, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Deploy deploy(String packageName, Long appRecoveryId, DeployAppRecoveryRequest content) throws IOException {
            Deploy result = new Deploy(packageName, appRecoveryId, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String packageName) throws IOException {
            List result = new List(packageName);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends AndroidPublisherRequest<ListAppRecoveriesResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/appRecoveries";
            @Key
            private String packageName;
            @Key
            private Long versionCode;

            protected List(String packageName) {
                super(AndroidPublisher.this, "GET", REST_PATH, null, ListAppRecoveriesResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public List setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Long getVersionCode() {
                return this.versionCode;
            }

            public List setVersionCode(Long versionCode) {
                this.versionCode = versionCode;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Deploy
        extends AndroidPublisherRequest<DeployAppRecoveryResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:deploy";
            @Key
            private String packageName;
            @Key
            private Long appRecoveryId;

            protected Deploy(String packageName, Long appRecoveryId, DeployAppRecoveryRequest content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, DeployAppRecoveryResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.appRecoveryId = (Long)Preconditions.checkNotNull((Object)appRecoveryId, (Object)"Required parameter appRecoveryId must be specified.");
            }

            public Deploy set$Xgafv(String $Xgafv) {
                return (Deploy)super.set$Xgafv($Xgafv);
            }

            public Deploy setAccessToken(String accessToken) {
                return (Deploy)super.setAccessToken(accessToken);
            }

            public Deploy setAlt(String alt) {
                return (Deploy)super.setAlt(alt);
            }

            public Deploy setCallback(String callback) {
                return (Deploy)super.setCallback(callback);
            }

            public Deploy setFields(String fields) {
                return (Deploy)super.setFields(fields);
            }

            public Deploy setKey(String key) {
                return (Deploy)super.setKey(key);
            }

            public Deploy setOauthToken(String oauthToken) {
                return (Deploy)super.setOauthToken(oauthToken);
            }

            public Deploy setPrettyPrint(Boolean prettyPrint) {
                return (Deploy)super.setPrettyPrint(prettyPrint);
            }

            public Deploy setQuotaUser(String quotaUser) {
                return (Deploy)super.setQuotaUser(quotaUser);
            }

            public Deploy setUploadType(String uploadType) {
                return (Deploy)super.setUploadType(uploadType);
            }

            public Deploy setUploadProtocol(String uploadProtocol) {
                return (Deploy)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Deploy setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Long getAppRecoveryId() {
                return this.appRecoveryId;
            }

            public Deploy setAppRecoveryId(Long appRecoveryId) {
                this.appRecoveryId = appRecoveryId;
                return this;
            }

            @Override
            public Deploy set(String parameterName, Object value) {
                return (Deploy)super.set(parameterName, value);
            }
        }

        public class Create
        extends AndroidPublisherRequest<AppRecoveryAction> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/appRecoveries";
            @Key
            private String packageName;

            protected Create(String packageName, CreateDraftAppRecoveryRequest content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, AppRecoveryAction.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Create setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class Cancel
        extends AndroidPublisherRequest<CancelAppRecoveryResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:cancel";
            @Key
            private String packageName;
            @Key
            private Long appRecoveryId;

            protected Cancel(String packageName, Long appRecoveryId, CancelAppRecoveryRequest content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, CancelAppRecoveryResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.appRecoveryId = (Long)Preconditions.checkNotNull((Object)appRecoveryId, (Object)"Required parameter appRecoveryId must be specified.");
            }

            public Cancel set$Xgafv(String $Xgafv) {
                return (Cancel)super.set$Xgafv($Xgafv);
            }

            public Cancel setAccessToken(String accessToken) {
                return (Cancel)super.setAccessToken(accessToken);
            }

            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            public Cancel setCallback(String callback) {
                return (Cancel)super.setCallback(callback);
            }

            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            public Cancel setUploadType(String uploadType) {
                return (Cancel)super.setUploadType(uploadType);
            }

            public Cancel setUploadProtocol(String uploadProtocol) {
                return (Cancel)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public Cancel setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Long getAppRecoveryId() {
                return this.appRecoveryId;
            }

            public Cancel setAppRecoveryId(Long appRecoveryId) {
                this.appRecoveryId = appRecoveryId;
                return this;
            }

            @Override
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }

        public class AddTargeting
        extends AndroidPublisherRequest<AddTargetingResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:addTargeting";
            @Key
            private String packageName;
            @Key
            private Long appRecoveryId;

            protected AddTargeting(String packageName, Long appRecoveryId, AddTargetingRequest content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, AddTargetingResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                this.appRecoveryId = (Long)Preconditions.checkNotNull((Object)appRecoveryId, (Object)"Required parameter appRecoveryId must be specified.");
            }

            public AddTargeting set$Xgafv(String $Xgafv) {
                return (AddTargeting)super.set$Xgafv($Xgafv);
            }

            public AddTargeting setAccessToken(String accessToken) {
                return (AddTargeting)super.setAccessToken(accessToken);
            }

            public AddTargeting setAlt(String alt) {
                return (AddTargeting)super.setAlt(alt);
            }

            public AddTargeting setCallback(String callback) {
                return (AddTargeting)super.setCallback(callback);
            }

            public AddTargeting setFields(String fields) {
                return (AddTargeting)super.setFields(fields);
            }

            public AddTargeting setKey(String key) {
                return (AddTargeting)super.setKey(key);
            }

            public AddTargeting setOauthToken(String oauthToken) {
                return (AddTargeting)super.setOauthToken(oauthToken);
            }

            public AddTargeting setPrettyPrint(Boolean prettyPrint) {
                return (AddTargeting)super.setPrettyPrint(prettyPrint);
            }

            public AddTargeting setQuotaUser(String quotaUser) {
                return (AddTargeting)super.setQuotaUser(quotaUser);
            }

            public AddTargeting setUploadType(String uploadType) {
                return (AddTargeting)super.setUploadType(uploadType);
            }

            public AddTargeting setUploadProtocol(String uploadProtocol) {
                return (AddTargeting)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public AddTargeting setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            public Long getAppRecoveryId() {
                return this.appRecoveryId;
            }

            public AddTargeting setAppRecoveryId(Long appRecoveryId) {
                this.appRecoveryId = appRecoveryId;
                return this;
            }

            @Override
            public AddTargeting set(String parameterName, Object value) {
                return (AddTargeting)super.set(parameterName, value);
            }
        }
    }

    public class Applications {
        public DataSafety dataSafety(String packageName, SafetyLabelsUpdateRequest content) throws IOException {
            DataSafety result = new DataSafety(packageName, content);
            AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public DeviceTierConfigs deviceTierConfigs() {
            return new DeviceTierConfigs();
        }

        public class DeviceTierConfigs {
            public Create create(String packageName, DeviceTierConfig content) throws IOException {
                Create result = new Create(packageName, content);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String packageName, Long deviceTierConfigId) throws IOException {
                Get result = new Get(packageName, deviceTierConfigId);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String packageName) throws IOException {
                List result = new List(packageName);
                AndroidPublisher.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AndroidPublisherRequest<ListDeviceTierConfigsResponse> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/deviceTierConfigs";
                @Key
                private String packageName;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String packageName) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, ListDeviceTierConfigsResponse.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public List setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AndroidPublisherRequest<DeviceTierConfig> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/deviceTierConfigs/{deviceTierConfigId}";
                @Key
                private String packageName;
                @Key
                private Long deviceTierConfigId;

                protected Get(String packageName, Long deviceTierConfigId) {
                    super(AndroidPublisher.this, "GET", REST_PATH, null, DeviceTierConfig.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                    this.deviceTierConfigId = (Long)Preconditions.checkNotNull((Object)deviceTierConfigId, (Object)"Required parameter deviceTierConfigId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Get setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public Long getDeviceTierConfigId() {
                    return this.deviceTierConfigId;
                }

                public Get setDeviceTierConfigId(Long deviceTierConfigId) {
                    this.deviceTierConfigId = deviceTierConfigId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends AndroidPublisherRequest<DeviceTierConfig> {
                private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/deviceTierConfigs";
                @Key
                private String packageName;
                @Key
                private Boolean allowUnknownDevices;

                protected Create(String packageName, DeviceTierConfig content) {
                    super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, DeviceTierConfig.class);
                    this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getPackageName() {
                    return this.packageName;
                }

                public Create setPackageName(String packageName) {
                    this.packageName = packageName;
                    return this;
                }

                public Boolean getAllowUnknownDevices() {
                    return this.allowUnknownDevices;
                }

                public Create setAllowUnknownDevices(Boolean allowUnknownDevices) {
                    this.allowUnknownDevices = allowUnknownDevices;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class DataSafety
        extends AndroidPublisherRequest<SafetyLabelsUpdateResponse> {
            private static final String REST_PATH = "androidpublisher/v3/applications/{packageName}/dataSafety";
            @Key
            private String packageName;

            protected DataSafety(String packageName, SafetyLabelsUpdateRequest content) {
                super(AndroidPublisher.this, "POST", REST_PATH, (Object)content, SafetyLabelsUpdateResponse.class);
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
            }

            public DataSafety set$Xgafv(String $Xgafv) {
                return (DataSafety)super.set$Xgafv($Xgafv);
            }

            public DataSafety setAccessToken(String accessToken) {
                return (DataSafety)super.setAccessToken(accessToken);
            }

            public DataSafety setAlt(String alt) {
                return (DataSafety)super.setAlt(alt);
            }

            public DataSafety setCallback(String callback) {
                return (DataSafety)super.setCallback(callback);
            }

            public DataSafety setFields(String fields) {
                return (DataSafety)super.setFields(fields);
            }

            public DataSafety setKey(String key) {
                return (DataSafety)super.setKey(key);
            }

            public DataSafety setOauthToken(String oauthToken) {
                return (DataSafety)super.setOauthToken(oauthToken);
            }

            public DataSafety setPrettyPrint(Boolean prettyPrint) {
                return (DataSafety)super.setPrettyPrint(prettyPrint);
            }

            public DataSafety setQuotaUser(String quotaUser) {
                return (DataSafety)super.setQuotaUser(quotaUser);
            }

            public DataSafety setUploadType(String uploadType) {
                return (DataSafety)super.setUploadType(uploadType);
            }

            public DataSafety setUploadProtocol(String uploadProtocol) {
                return (DataSafety)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public DataSafety setPackageName(String packageName) {
                this.packageName = packageName;
                return this;
            }

            @Override
            public DataSafety set(String parameterName, Object value) {
                return (DataSafety)super.set(parameterName, value);
            }
        }
    }
}

