/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Represents an installments base plan where a user commits to a specified number of payments.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstallmentsBasePlanType extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Account hold period of the subscription, specified exclusively in days and in ISO
   * 8601 format. Acceptable values are P0D (zero days) to P30D (30days). If not specified, the
   * default value is P30D (30 days).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountHoldDuration;

  /**
   * Required. Immutable. Subscription period, specified in ISO 8601 format. For a list of
   * acceptable billing periods, refer to the help center. The duration is immutable after the base
   * plan is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String billingPeriodDuration;

  /**
   * Required. Immutable. The number of payments the user is committed to. It is immutable after the
   * base plan is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer committedPaymentsCount;

  /**
   * Grace period of the subscription, specified in ISO 8601 format. Acceptable values are P0D (zero
   * days), P3D (3 days), P7D (7 days), P14D (14 days), and P30D (30 days). If not specified, a
   * default value will be used based on the recurring period duration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gracePeriodDuration;

  /**
   * The proration mode for the base plan determines what happens when a user switches to this plan
   * from another base plan. If unspecified, defaults to CHARGE_ON_NEXT_BILLING_DATE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String prorationMode;

  /**
   * Required. Immutable. Installments base plan renewal type. Determines the behavior at the end of
   * the initial commitment. The renewal type is immutable after the base plan is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String renewalType;

  /**
   * Whether users should be able to resubscribe to this base plan in Google Play surfaces. Defaults
   * to RESUBSCRIBE_STATE_ACTIVE if not specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resubscribeState;

  /**
   * Optional. Account hold period of the subscription, specified exclusively in days and in ISO
   * 8601 format. Acceptable values are P0D (zero days) to P30D (30days). If not specified, the
   * default value is P30D (30 days).
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountHoldDuration() {
    return accountHoldDuration;
  }

  /**
   * Optional. Account hold period of the subscription, specified exclusively in days and in ISO
   * 8601 format. Acceptable values are P0D (zero days) to P30D (30days). If not specified, the
   * default value is P30D (30 days).
   * @param accountHoldDuration accountHoldDuration or {@code null} for none
   */
  public InstallmentsBasePlanType setAccountHoldDuration(java.lang.String accountHoldDuration) {
    this.accountHoldDuration = accountHoldDuration;
    return this;
  }

  /**
   * Required. Immutable. Subscription period, specified in ISO 8601 format. For a list of
   * acceptable billing periods, refer to the help center. The duration is immutable after the base
   * plan is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getBillingPeriodDuration() {
    return billingPeriodDuration;
  }

  /**
   * Required. Immutable. Subscription period, specified in ISO 8601 format. For a list of
   * acceptable billing periods, refer to the help center. The duration is immutable after the base
   * plan is created.
   * @param billingPeriodDuration billingPeriodDuration or {@code null} for none
   */
  public InstallmentsBasePlanType setBillingPeriodDuration(java.lang.String billingPeriodDuration) {
    this.billingPeriodDuration = billingPeriodDuration;
    return this;
  }

  /**
   * Required. Immutable. The number of payments the user is committed to. It is immutable after the
   * base plan is created.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCommittedPaymentsCount() {
    return committedPaymentsCount;
  }

  /**
   * Required. Immutable. The number of payments the user is committed to. It is immutable after the
   * base plan is created.
   * @param committedPaymentsCount committedPaymentsCount or {@code null} for none
   */
  public InstallmentsBasePlanType setCommittedPaymentsCount(java.lang.Integer committedPaymentsCount) {
    this.committedPaymentsCount = committedPaymentsCount;
    return this;
  }

  /**
   * Grace period of the subscription, specified in ISO 8601 format. Acceptable values are P0D (zero
   * days), P3D (3 days), P7D (7 days), P14D (14 days), and P30D (30 days). If not specified, a
   * default value will be used based on the recurring period duration.
   * @return value or {@code null} for none
   */
  public java.lang.String getGracePeriodDuration() {
    return gracePeriodDuration;
  }

  /**
   * Grace period of the subscription, specified in ISO 8601 format. Acceptable values are P0D (zero
   * days), P3D (3 days), P7D (7 days), P14D (14 days), and P30D (30 days). If not specified, a
   * default value will be used based on the recurring period duration.
   * @param gracePeriodDuration gracePeriodDuration or {@code null} for none
   */
  public InstallmentsBasePlanType setGracePeriodDuration(java.lang.String gracePeriodDuration) {
    this.gracePeriodDuration = gracePeriodDuration;
    return this;
  }

  /**
   * The proration mode for the base plan determines what happens when a user switches to this plan
   * from another base plan. If unspecified, defaults to CHARGE_ON_NEXT_BILLING_DATE.
   * @return value or {@code null} for none
   */
  public java.lang.String getProrationMode() {
    return prorationMode;
  }

  /**
   * The proration mode for the base plan determines what happens when a user switches to this plan
   * from another base plan. If unspecified, defaults to CHARGE_ON_NEXT_BILLING_DATE.
   * @param prorationMode prorationMode or {@code null} for none
   */
  public InstallmentsBasePlanType setProrationMode(java.lang.String prorationMode) {
    this.prorationMode = prorationMode;
    return this;
  }

  /**
   * Required. Immutable. Installments base plan renewal type. Determines the behavior at the end of
   * the initial commitment. The renewal type is immutable after the base plan is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getRenewalType() {
    return renewalType;
  }

  /**
   * Required. Immutable. Installments base plan renewal type. Determines the behavior at the end of
   * the initial commitment. The renewal type is immutable after the base plan is created.
   * @param renewalType renewalType or {@code null} for none
   */
  public InstallmentsBasePlanType setRenewalType(java.lang.String renewalType) {
    this.renewalType = renewalType;
    return this;
  }

  /**
   * Whether users should be able to resubscribe to this base plan in Google Play surfaces. Defaults
   * to RESUBSCRIBE_STATE_ACTIVE if not specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getResubscribeState() {
    return resubscribeState;
  }

  /**
   * Whether users should be able to resubscribe to this base plan in Google Play surfaces. Defaults
   * to RESUBSCRIBE_STATE_ACTIVE if not specified.
   * @param resubscribeState resubscribeState or {@code null} for none
   */
  public InstallmentsBasePlanType setResubscribeState(java.lang.String resubscribeState) {
    this.resubscribeState = resubscribeState;
    return this;
  }

  @Override
  public InstallmentsBasePlanType set(String fieldName, Object value) {
    return (InstallmentsBasePlanType) super.set(fieldName, value);
  }

  @Override
  public InstallmentsBasePlanType clone() {
    return (InstallmentsBasePlanType) super.clone();
  }

}
