/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Targeting details for a recovery action such as regions, android sdk levels, app versions etc.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Targeting extends com.google.api.client.json.GenericJson {

  /**
   * All users are targeted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AllUsers allUsers;

  /**
   * Targeting is based on android api levels of devices.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AndroidSdks androidSdks;

  /**
   * Targeting is based on the user account region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Regions regions;

  /**
   * Target version codes as a list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppVersionList versionList;

  /**
   * Target version codes as a range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppVersionRange versionRange;

  /**
   * All users are targeted.
   * @return value or {@code null} for none
   */
  public AllUsers getAllUsers() {
    return allUsers;
  }

  /**
   * All users are targeted.
   * @param allUsers allUsers or {@code null} for none
   */
  public Targeting setAllUsers(AllUsers allUsers) {
    this.allUsers = allUsers;
    return this;
  }

  /**
   * Targeting is based on android api levels of devices.
   * @return value or {@code null} for none
   */
  public AndroidSdks getAndroidSdks() {
    return androidSdks;
  }

  /**
   * Targeting is based on android api levels of devices.
   * @param androidSdks androidSdks or {@code null} for none
   */
  public Targeting setAndroidSdks(AndroidSdks androidSdks) {
    this.androidSdks = androidSdks;
    return this;
  }

  /**
   * Targeting is based on the user account region.
   * @return value or {@code null} for none
   */
  public Regions getRegions() {
    return regions;
  }

  /**
   * Targeting is based on the user account region.
   * @param regions regions or {@code null} for none
   */
  public Targeting setRegions(Regions regions) {
    this.regions = regions;
    return this;
  }

  /**
   * Target version codes as a list.
   * @return value or {@code null} for none
   */
  public AppVersionList getVersionList() {
    return versionList;
  }

  /**
   * Target version codes as a list.
   * @param versionList versionList or {@code null} for none
   */
  public Targeting setVersionList(AppVersionList versionList) {
    this.versionList = versionList;
    return this;
  }

  /**
   * Target version codes as a range.
   * @return value or {@code null} for none
   */
  public AppVersionRange getVersionRange() {
    return versionRange;
  }

  /**
   * Target version codes as a range.
   * @param versionRange versionRange or {@code null} for none
   */
  public Targeting setVersionRange(AppVersionRange versionRange) {
    this.versionRange = versionRange;
    return this;
  }

  @Override
  public Targeting set(String fieldName, Object value) {
    return (Targeting) super.set(fieldName, value);
  }

  @Override
  public Targeting clone() {
    return (Targeting) super.clone();
  }

}
