/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Represents a base plan that automatically renews at the end of its subscription period.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoRenewingBasePlanType extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Account hold period of the subscription, specified in ISO 8601 format. Acceptable
   * values must be in days and between P0D and P60D. If not specified, the default value is P30D.
   * The sum of gracePeriodDuration and accountHoldDuration must be between P30D and P60D days,
   * inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountHoldDuration;

  /**
   * Required. Immutable. Subscription period, specified in ISO 8601 format. For a list of
   * acceptable billing periods, refer to the help center. The duration is immutable after the base
   * plan is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String billingPeriodDuration;

  /**
   * Grace period of the subscription, specified in ISO 8601 format. Acceptable values must be in
   * days and between P0D and the lesser of 30D and base plan billing period. If not specified, a
   * default value will be used based on the billing period. The sum of gracePeriodDuration and
   * accountHoldDuration must be between P30D and P60D days, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gracePeriodDuration;

  /**
   * Whether the renewing base plan is backward compatible. The backward compatible base plan is
   * returned by the Google Play Billing Library deprecated method querySkuDetailsAsync(). Only one
   * renewing base plan can be marked as legacy compatible for a given subscription.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean legacyCompatible;

  /**
   * Subscription offer id which is legacy compatible. The backward compatible subscription offer is
   * returned by the Google Play Billing Library deprecated method querySkuDetailsAsync(). Only one
   * subscription offer can be marked as legacy compatible for a given renewing base plan. To have
   * no Subscription offer as legacy compatible set this field as empty string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String legacyCompatibleSubscriptionOfferId;

  /**
   * The proration mode for the base plan determines what happens when a user switches to this plan
   * from another base plan. If unspecified, defaults to CHARGE_ON_NEXT_BILLING_DATE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String prorationMode;

  /**
   * Whether users should be able to resubscribe to this base plan in Google Play surfaces. Defaults
   * to RESUBSCRIBE_STATE_ACTIVE if not specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resubscribeState;

  /**
   * Optional. Account hold period of the subscription, specified in ISO 8601 format. Acceptable
   * values must be in days and between P0D and P60D. If not specified, the default value is P30D.
   * The sum of gracePeriodDuration and accountHoldDuration must be between P30D and P60D days,
   * inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountHoldDuration() {
    return accountHoldDuration;
  }

  /**
   * Optional. Account hold period of the subscription, specified in ISO 8601 format. Acceptable
   * values must be in days and between P0D and P60D. If not specified, the default value is P30D.
   * The sum of gracePeriodDuration and accountHoldDuration must be between P30D and P60D days,
   * inclusive.
   * @param accountHoldDuration accountHoldDuration or {@code null} for none
   */
  public AutoRenewingBasePlanType setAccountHoldDuration(java.lang.String accountHoldDuration) {
    this.accountHoldDuration = accountHoldDuration;
    return this;
  }

  /**
   * Required. Immutable. Subscription period, specified in ISO 8601 format. For a list of
   * acceptable billing periods, refer to the help center. The duration is immutable after the base
   * plan is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getBillingPeriodDuration() {
    return billingPeriodDuration;
  }

  /**
   * Required. Immutable. Subscription period, specified in ISO 8601 format. For a list of
   * acceptable billing periods, refer to the help center. The duration is immutable after the base
   * plan is created.
   * @param billingPeriodDuration billingPeriodDuration or {@code null} for none
   */
  public AutoRenewingBasePlanType setBillingPeriodDuration(java.lang.String billingPeriodDuration) {
    this.billingPeriodDuration = billingPeriodDuration;
    return this;
  }

  /**
   * Grace period of the subscription, specified in ISO 8601 format. Acceptable values must be in
   * days and between P0D and the lesser of 30D and base plan billing period. If not specified, a
   * default value will be used based on the billing period. The sum of gracePeriodDuration and
   * accountHoldDuration must be between P30D and P60D days, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.String getGracePeriodDuration() {
    return gracePeriodDuration;
  }

  /**
   * Grace period of the subscription, specified in ISO 8601 format. Acceptable values must be in
   * days and between P0D and the lesser of 30D and base plan billing period. If not specified, a
   * default value will be used based on the billing period. The sum of gracePeriodDuration and
   * accountHoldDuration must be between P30D and P60D days, inclusive.
   * @param gracePeriodDuration gracePeriodDuration or {@code null} for none
   */
  public AutoRenewingBasePlanType setGracePeriodDuration(java.lang.String gracePeriodDuration) {
    this.gracePeriodDuration = gracePeriodDuration;
    return this;
  }

  /**
   * Whether the renewing base plan is backward compatible. The backward compatible base plan is
   * returned by the Google Play Billing Library deprecated method querySkuDetailsAsync(). Only one
   * renewing base plan can be marked as legacy compatible for a given subscription.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getLegacyCompatible() {
    return legacyCompatible;
  }

  /**
   * Whether the renewing base plan is backward compatible. The backward compatible base plan is
   * returned by the Google Play Billing Library deprecated method querySkuDetailsAsync(). Only one
   * renewing base plan can be marked as legacy compatible for a given subscription.
   * @param legacyCompatible legacyCompatible or {@code null} for none
   */
  public AutoRenewingBasePlanType setLegacyCompatible(java.lang.Boolean legacyCompatible) {
    this.legacyCompatible = legacyCompatible;
    return this;
  }

  /**
   * Subscription offer id which is legacy compatible. The backward compatible subscription offer is
   * returned by the Google Play Billing Library deprecated method querySkuDetailsAsync(). Only one
   * subscription offer can be marked as legacy compatible for a given renewing base plan. To have
   * no Subscription offer as legacy compatible set this field as empty string.
   * @return value or {@code null} for none
   */
  public java.lang.String getLegacyCompatibleSubscriptionOfferId() {
    return legacyCompatibleSubscriptionOfferId;
  }

  /**
   * Subscription offer id which is legacy compatible. The backward compatible subscription offer is
   * returned by the Google Play Billing Library deprecated method querySkuDetailsAsync(). Only one
   * subscription offer can be marked as legacy compatible for a given renewing base plan. To have
   * no Subscription offer as legacy compatible set this field as empty string.
   * @param legacyCompatibleSubscriptionOfferId legacyCompatibleSubscriptionOfferId or {@code null} for none
   */
  public AutoRenewingBasePlanType setLegacyCompatibleSubscriptionOfferId(java.lang.String legacyCompatibleSubscriptionOfferId) {
    this.legacyCompatibleSubscriptionOfferId = legacyCompatibleSubscriptionOfferId;
    return this;
  }

  /**
   * The proration mode for the base plan determines what happens when a user switches to this plan
   * from another base plan. If unspecified, defaults to CHARGE_ON_NEXT_BILLING_DATE.
   * @return value or {@code null} for none
   */
  public java.lang.String getProrationMode() {
    return prorationMode;
  }

  /**
   * The proration mode for the base plan determines what happens when a user switches to this plan
   * from another base plan. If unspecified, defaults to CHARGE_ON_NEXT_BILLING_DATE.
   * @param prorationMode prorationMode or {@code null} for none
   */
  public AutoRenewingBasePlanType setProrationMode(java.lang.String prorationMode) {
    this.prorationMode = prorationMode;
    return this;
  }

  /**
   * Whether users should be able to resubscribe to this base plan in Google Play surfaces. Defaults
   * to RESUBSCRIBE_STATE_ACTIVE if not specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getResubscribeState() {
    return resubscribeState;
  }

  /**
   * Whether users should be able to resubscribe to this base plan in Google Play surfaces. Defaults
   * to RESUBSCRIBE_STATE_ACTIVE if not specified.
   * @param resubscribeState resubscribeState or {@code null} for none
   */
  public AutoRenewingBasePlanType setResubscribeState(java.lang.String resubscribeState) {
    this.resubscribeState = resubscribeState;
    return this;
  }

  @Override
  public AutoRenewingBasePlanType set(String fieldName, Object value) {
    return (AutoRenewingBasePlanType) super.set(fieldName, value);
  }

  @Override
  public AutoRenewingBasePlanType clone() {
    return (AutoRenewingBasePlanType) super.clone();
  }

}
