/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Information related to an auto renewing plan.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoRenewingPlan extends com.google.api.client.json.GenericJson {

  /**
   * If the subscription is currently set to auto-renew, e.g. the user has not canceled the
   * subscription
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoRenewEnabled;

  /**
   * The installment plan commitment and state related info for the auto renewing plan.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstallmentPlan installmentDetails;

  /**
   * The information of the last price change for the item since subscription signup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubscriptionItemPriceChangeDetails priceChangeDetails;

  /**
   * The current recurring price of the auto renewing plan.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money recurringPrice;

  /**
   * If the subscription is currently set to auto-renew, e.g. the user has not canceled the
   * subscription
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoRenewEnabled() {
    return autoRenewEnabled;
  }

  /**
   * If the subscription is currently set to auto-renew, e.g. the user has not canceled the
   * subscription
   * @param autoRenewEnabled autoRenewEnabled or {@code null} for none
   */
  public AutoRenewingPlan setAutoRenewEnabled(java.lang.Boolean autoRenewEnabled) {
    this.autoRenewEnabled = autoRenewEnabled;
    return this;
  }

  /**
   * The installment plan commitment and state related info for the auto renewing plan.
   * @return value or {@code null} for none
   */
  public InstallmentPlan getInstallmentDetails() {
    return installmentDetails;
  }

  /**
   * The installment plan commitment and state related info for the auto renewing plan.
   * @param installmentDetails installmentDetails or {@code null} for none
   */
  public AutoRenewingPlan setInstallmentDetails(InstallmentPlan installmentDetails) {
    this.installmentDetails = installmentDetails;
    return this;
  }

  /**
   * The information of the last price change for the item since subscription signup.
   * @return value or {@code null} for none
   */
  public SubscriptionItemPriceChangeDetails getPriceChangeDetails() {
    return priceChangeDetails;
  }

  /**
   * The information of the last price change for the item since subscription signup.
   * @param priceChangeDetails priceChangeDetails or {@code null} for none
   */
  public AutoRenewingPlan setPriceChangeDetails(SubscriptionItemPriceChangeDetails priceChangeDetails) {
    this.priceChangeDetails = priceChangeDetails;
    return this;
  }

  /**
   * The current recurring price of the auto renewing plan.
   * @return value or {@code null} for none
   */
  public Money getRecurringPrice() {
    return recurringPrice;
  }

  /**
   * The current recurring price of the auto renewing plan.
   * @param recurringPrice recurringPrice or {@code null} for none
   */
  public AutoRenewingPlan setRecurringPrice(Money recurringPrice) {
    this.recurringPrice = recurringPrice;
    return this;
  }

  @Override
  public AutoRenewingPlan set(String fieldName, Object value) {
    return (AutoRenewingPlan) super.set(fieldName, value);
  }

  @Override
  public AutoRenewingPlan clone() {
    return (AutoRenewingPlan) super.clone();
  }

}
