/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Response message for ConvertRegionPrices.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConvertRegionPricesResponse extends com.google.api.client.json.GenericJson {

  /**
   * Converted other regions prices in USD and EUR, to use for countries where Play doesn't support
   * a country's local currency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConvertedOtherRegionsPrice convertedOtherRegionsPrice;

  /**
   * Map from region code to converted region price.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, ConvertedRegionPrice> convertedRegionPrices;

  /**
   * The region version at which the prices were generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RegionsVersion regionVersion;

  /**
   * Converted other regions prices in USD and EUR, to use for countries where Play doesn't support
   * a country's local currency.
   * @return value or {@code null} for none
   */
  public ConvertedOtherRegionsPrice getConvertedOtherRegionsPrice() {
    return convertedOtherRegionsPrice;
  }

  /**
   * Converted other regions prices in USD and EUR, to use for countries where Play doesn't support
   * a country's local currency.
   * @param convertedOtherRegionsPrice convertedOtherRegionsPrice or {@code null} for none
   */
  public ConvertRegionPricesResponse setConvertedOtherRegionsPrice(ConvertedOtherRegionsPrice convertedOtherRegionsPrice) {
    this.convertedOtherRegionsPrice = convertedOtherRegionsPrice;
    return this;
  }

  /**
   * Map from region code to converted region price.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, ConvertedRegionPrice> getConvertedRegionPrices() {
    return convertedRegionPrices;
  }

  /**
   * Map from region code to converted region price.
   * @param convertedRegionPrices convertedRegionPrices or {@code null} for none
   */
  public ConvertRegionPricesResponse setConvertedRegionPrices(java.util.Map<String, ConvertedRegionPrice> convertedRegionPrices) {
    this.convertedRegionPrices = convertedRegionPrices;
    return this;
  }

  /**
   * The region version at which the prices were generated.
   * @return value or {@code null} for none
   */
  public RegionsVersion getRegionVersion() {
    return regionVersion;
  }

  /**
   * The region version at which the prices were generated.
   * @param regionVersion regionVersion or {@code null} for none
   */
  public ConvertRegionPricesResponse setRegionVersion(RegionsVersion regionVersion) {
    this.regionVersion = regionVersion;
    return this;
  }

  @Override
  public ConvertRegionPricesResponse set(String fieldName, Object value) {
    return (ConvertRegionPricesResponse) super.set(fieldName, value);
  }

  @Override
  public ConvertRegionPricesResponse clone() {
    return (ConvertRegionPricesResponse) super.clone();
  }

}
