/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Offer details information related to a purchase line item.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OfferDetails extends com.google.api.client.json.GenericJson {

  /**
   * The base plan ID. Present for all base plan and offers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String basePlanId;

  /**
   * The offer ID. Only present for discounted offers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String offerId;

  /**
   * The latest offer tags associated with the offer. It includes tags inherited from the base plan.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> offerTags;

  /**
   * The base plan ID. Present for all base plan and offers.
   * @return value or {@code null} for none
   */
  public java.lang.String getBasePlanId() {
    return basePlanId;
  }

  /**
   * The base plan ID. Present for all base plan and offers.
   * @param basePlanId basePlanId or {@code null} for none
   */
  public OfferDetails setBasePlanId(java.lang.String basePlanId) {
    this.basePlanId = basePlanId;
    return this;
  }

  /**
   * The offer ID. Only present for discounted offers.
   * @return value or {@code null} for none
   */
  public java.lang.String getOfferId() {
    return offerId;
  }

  /**
   * The offer ID. Only present for discounted offers.
   * @param offerId offerId or {@code null} for none
   */
  public OfferDetails setOfferId(java.lang.String offerId) {
    this.offerId = offerId;
    return this;
  }

  /**
   * The latest offer tags associated with the offer. It includes tags inherited from the base plan.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getOfferTags() {
    return offerTags;
  }

  /**
   * The latest offer tags associated with the offer. It includes tags inherited from the base plan.
   * @param offerTags offerTags or {@code null} for none
   */
  public OfferDetails setOfferTags(java.util.List<java.lang.String> offerTags) {
    this.offerTags = offerTags;
    return this;
  }

  @Override
  public OfferDetails set(String fieldName, Object value) {
    return (OfferDetails) super.set(fieldName, value);
  }

  @Override
  public OfferDetails clone() {
    return (OfferDetails) super.clone();
  }

}
