/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Representation of a System-on-Chip (SoC) of an Android device. Can be used to target S+ devices.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SystemOnChip extends com.google.api.client.json.GenericJson {

  /**
   * Required. The designer of the SoC, eg. "Google" Value of build property "ro.soc.manufacturer"
   * https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String manufacturer;

  /**
   * Required. The model of the SoC, eg. "Tensor" Value of build property "ro.soc.model"
   * https://developer.android.com/reference/android/os/Build#SOC_MODEL Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String model;

  /**
   * Required. The designer of the SoC, eg. "Google" Value of build property "ro.soc.manufacturer"
   * https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getManufacturer() {
    return manufacturer;
  }

  /**
   * Required. The designer of the SoC, eg. "Google" Value of build property "ro.soc.manufacturer"
   * https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER Required.
   * @param manufacturer manufacturer or {@code null} for none
   */
  public SystemOnChip setManufacturer(java.lang.String manufacturer) {
    this.manufacturer = manufacturer;
    return this;
  }

  /**
   * Required. The model of the SoC, eg. "Tensor" Value of build property "ro.soc.model"
   * https://developer.android.com/reference/android/os/Build#SOC_MODEL Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getModel() {
    return model;
  }

  /**
   * Required. The model of the SoC, eg. "Tensor" Value of build property "ro.soc.model"
   * https://developer.android.com/reference/android/os/Build#SOC_MODEL Required.
   * @param model model or {@code null} for none
   */
  public SystemOnChip setModel(java.lang.String model) {
    this.model = model;
    return this;
  }

  @Override
  public SystemOnChip set(String fieldName, Object value) {
    return (SystemOnChip) super.set(fieldName, value);
  }

  @Override
  public SystemOnChip clone() {
    return (SystemOnChip) super.clone();
  }

}
