/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-02-28 at 04:55:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Contains the price change information for a subscription that can be used to control the user
 * journey for the price change in the app. This can be in the form of seeking confirmation from the
 * user or tailoring the experience for a successful conversion.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionPriceChange extends com.google.api.client.json.GenericJson {

  /**
   * The new price the subscription will renew with if the price change is accepted by the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price newPrice;

  /**
   * The current state of the price change. Possible values are: - Outstanding: State for a pending
   * price change waiting for the user to agree. In this state, you can optionally seek confirmation
   * from the user using the In-App API.  - Accepted: State for an accepted price change that the
   * subscription will renew with unless it's canceled. The price change takes effect on a future
   * date when the subscription renews. Note that the change might not occur when the subscription
   * is renewed next.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer state;

  /**
   * The new price the subscription will renew with if the price change is accepted by the user.
   * @return value or {@code null} for none
   */
  public Price getNewPrice() {
    return newPrice;
  }

  /**
   * The new price the subscription will renew with if the price change is accepted by the user.
   * @param newPrice newPrice or {@code null} for none
   */
  public SubscriptionPriceChange setNewPrice(Price newPrice) {
    this.newPrice = newPrice;
    return this;
  }

  /**
   * The current state of the price change. Possible values are: - Outstanding: State for a pending
   * price change waiting for the user to agree. In this state, you can optionally seek confirmation
   * from the user using the In-App API.  - Accepted: State for an accepted price change that the
   * subscription will renew with unless it's canceled. The price change takes effect on a future
   * date when the subscription renews. Note that the change might not occur when the subscription
   * is renewed next.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getState() {
    return state;
  }

  /**
   * The current state of the price change. Possible values are: - Outstanding: State for a pending
   * price change waiting for the user to agree. In this state, you can optionally seek confirmation
   * from the user using the In-App API.  - Accepted: State for an accepted price change that the
   * subscription will renew with unless it's canceled. The price change takes effect on a future
   * date when the subscription renews. Note that the change might not occur when the subscription
   * is renewed next.
   * @param state state or {@code null} for none
   */
  public SubscriptionPriceChange setState(java.lang.Integer state) {
    this.state = state;
    return this;
  }

  @Override
  public SubscriptionPriceChange set(String fieldName, Object value) {
    return (SubscriptionPriceChange) super.set(fieldName, value);
  }

  @Override
  public SubscriptionPriceChange clone() {
    return (SubscriptionPriceChange) super.clone();
  }

}
