/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-04-08 at 19:07:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Model definition for TrackRelease.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TrackRelease extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CountryTargeting countryTargeting;

  /**
   * The release name, used to identify this release in the Play Console UI. Not required to be
   * unique. This is optional, if not set it will be generated from the version_name in the APKs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The description of what is new in the app in this release.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LocalizedText> releaseNotes;

  static {
    // hack to force ProGuard to consider LocalizedText used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(LocalizedText.class);
  }

  /**
   * The desired status of this release.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Fraction of users who are eligible to receive the release. 0 < fraction < 1. To be set, release
   * status must be "inProgress" or "halted".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double userFraction;

  /**
   * A list of all version codes of APKs that will be exposed to the users of this track when this
   * release is rolled out. Note that this list should contain all versions you wish to be active,
   * including those you wish to retain from previous releases.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> versionCodes;

  /**
   * @return value or {@code null} for none
   */
  public CountryTargeting getCountryTargeting() {
    return countryTargeting;
  }

  /**
   * @param countryTargeting countryTargeting or {@code null} for none
   */
  public TrackRelease setCountryTargeting(CountryTargeting countryTargeting) {
    this.countryTargeting = countryTargeting;
    return this;
  }

  /**
   * The release name, used to identify this release in the Play Console UI. Not required to be
   * unique. This is optional, if not set it will be generated from the version_name in the APKs.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The release name, used to identify this release in the Play Console UI. Not required to be
   * unique. This is optional, if not set it will be generated from the version_name in the APKs.
   * @param name name or {@code null} for none
   */
  public TrackRelease setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The description of what is new in the app in this release.
   * @return value or {@code null} for none
   */
  public java.util.List<LocalizedText> getReleaseNotes() {
    return releaseNotes;
  }

  /**
   * The description of what is new in the app in this release.
   * @param releaseNotes releaseNotes or {@code null} for none
   */
  public TrackRelease setReleaseNotes(java.util.List<LocalizedText> releaseNotes) {
    this.releaseNotes = releaseNotes;
    return this;
  }

  /**
   * The desired status of this release.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The desired status of this release.
   * @param status status or {@code null} for none
   */
  public TrackRelease setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Fraction of users who are eligible to receive the release. 0 < fraction < 1. To be set, release
   * status must be "inProgress" or "halted".
   * @return value or {@code null} for none
   */
  public java.lang.Double getUserFraction() {
    return userFraction;
  }

  /**
   * Fraction of users who are eligible to receive the release. 0 < fraction < 1. To be set, release
   * status must be "inProgress" or "halted".
   * @param userFraction userFraction or {@code null} for none
   */
  public TrackRelease setUserFraction(java.lang.Double userFraction) {
    this.userFraction = userFraction;
    return this;
  }

  /**
   * A list of all version codes of APKs that will be exposed to the users of this track when this
   * release is rolled out. Note that this list should contain all versions you wish to be active,
   * including those you wish to retain from previous releases.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getVersionCodes() {
    return versionCodes;
  }

  /**
   * A list of all version codes of APKs that will be exposed to the users of this track when this
   * release is rolled out. Note that this list should contain all versions you wish to be active,
   * including those you wish to retain from previous releases.
   * @param versionCodes versionCodes or {@code null} for none
   */
  public TrackRelease setVersionCodes(java.util.List<java.lang.Long> versionCodes) {
    this.versionCodes = versionCodes;
    return this;
  }

  @Override
  public TrackRelease set(String fieldName, Object value) {
    return (TrackRelease) super.set(fieldName, value);
  }

  @Override
  public TrackRelease clone() {
    return (TrackRelease) super.clone();
  }

}
