/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-04-15 at 20:41:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Model definition for UserComment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserComment extends com.google.api.client.json.GenericJson {

  /**
   * Integer Android SDK version of the user's device at the time the review was written, e.g. 23 is
   * Marshmallow. May be absent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer androidOsVersion;

  /**
   * Integer version code of the app as installed at the time the review was written. May be absent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer appVersionCode;

  /**
   * String version name of the app as installed at the time the review was written. May be absent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appVersionName;

  /**
   * Codename for the reviewer's device, e.g. klte, flounder. May be absent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String device;

  /**
   * Some information about the characteristics of the user's device
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeviceMetadata deviceMetadata;

  /**
   * The last time at which this comment was updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Timestamp lastModified;

  /**
   * Untranslated text of the review, in the case where the review has been translated. If the
   * review has not been translated this is left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originalText;

  /**
   * Language code for the reviewer. This is taken from the device settings so is not guaranteed to
   * match the language the review is written in. May be absent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reviewerLanguage;

  /**
   * The star rating associated with the review, from 1 to 5.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer starRating;

  /**
   * The content of the comment, i.e. review body. In some cases users have been able to write a
   * review with separate title and body; in those cases the title and body are concatenated and
   * separated by a tab character.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * Number of users who have given this review a thumbs down
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer thumbsDownCount;

  /**
   * Number of users who have given this review a thumbs up
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer thumbsUpCount;

  /**
   * Integer Android SDK version of the user's device at the time the review was written, e.g. 23 is
   * Marshmallow. May be absent.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAndroidOsVersion() {
    return androidOsVersion;
  }

  /**
   * Integer Android SDK version of the user's device at the time the review was written, e.g. 23 is
   * Marshmallow. May be absent.
   * @param androidOsVersion androidOsVersion or {@code null} for none
   */
  public UserComment setAndroidOsVersion(java.lang.Integer androidOsVersion) {
    this.androidOsVersion = androidOsVersion;
    return this;
  }

  /**
   * Integer version code of the app as installed at the time the review was written. May be absent.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAppVersionCode() {
    return appVersionCode;
  }

  /**
   * Integer version code of the app as installed at the time the review was written. May be absent.
   * @param appVersionCode appVersionCode or {@code null} for none
   */
  public UserComment setAppVersionCode(java.lang.Integer appVersionCode) {
    this.appVersionCode = appVersionCode;
    return this;
  }

  /**
   * String version name of the app as installed at the time the review was written. May be absent.
   * @return value or {@code null} for none
   */
  public java.lang.String getAppVersionName() {
    return appVersionName;
  }

  /**
   * String version name of the app as installed at the time the review was written. May be absent.
   * @param appVersionName appVersionName or {@code null} for none
   */
  public UserComment setAppVersionName(java.lang.String appVersionName) {
    this.appVersionName = appVersionName;
    return this;
  }

  /**
   * Codename for the reviewer's device, e.g. klte, flounder. May be absent.
   * @return value or {@code null} for none
   */
  public java.lang.String getDevice() {
    return device;
  }

  /**
   * Codename for the reviewer's device, e.g. klte, flounder. May be absent.
   * @param device device or {@code null} for none
   */
  public UserComment setDevice(java.lang.String device) {
    this.device = device;
    return this;
  }

  /**
   * Some information about the characteristics of the user's device
   * @return value or {@code null} for none
   */
  public DeviceMetadata getDeviceMetadata() {
    return deviceMetadata;
  }

  /**
   * Some information about the characteristics of the user's device
   * @param deviceMetadata deviceMetadata or {@code null} for none
   */
  public UserComment setDeviceMetadata(DeviceMetadata deviceMetadata) {
    this.deviceMetadata = deviceMetadata;
    return this;
  }

  /**
   * The last time at which this comment was updated.
   * @return value or {@code null} for none
   */
  public Timestamp getLastModified() {
    return lastModified;
  }

  /**
   * The last time at which this comment was updated.
   * @param lastModified lastModified or {@code null} for none
   */
  public UserComment setLastModified(Timestamp lastModified) {
    this.lastModified = lastModified;
    return this;
  }

  /**
   * Untranslated text of the review, in the case where the review has been translated. If the
   * review has not been translated this is left blank.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginalText() {
    return originalText;
  }

  /**
   * Untranslated text of the review, in the case where the review has been translated. If the
   * review has not been translated this is left blank.
   * @param originalText originalText or {@code null} for none
   */
  public UserComment setOriginalText(java.lang.String originalText) {
    this.originalText = originalText;
    return this;
  }

  /**
   * Language code for the reviewer. This is taken from the device settings so is not guaranteed to
   * match the language the review is written in. May be absent.
   * @return value or {@code null} for none
   */
  public java.lang.String getReviewerLanguage() {
    return reviewerLanguage;
  }

  /**
   * Language code for the reviewer. This is taken from the device settings so is not guaranteed to
   * match the language the review is written in. May be absent.
   * @param reviewerLanguage reviewerLanguage or {@code null} for none
   */
  public UserComment setReviewerLanguage(java.lang.String reviewerLanguage) {
    this.reviewerLanguage = reviewerLanguage;
    return this;
  }

  /**
   * The star rating associated with the review, from 1 to 5.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStarRating() {
    return starRating;
  }

  /**
   * The star rating associated with the review, from 1 to 5.
   * @param starRating starRating or {@code null} for none
   */
  public UserComment setStarRating(java.lang.Integer starRating) {
    this.starRating = starRating;
    return this;
  }

  /**
   * The content of the comment, i.e. review body. In some cases users have been able to write a
   * review with separate title and body; in those cases the title and body are concatenated and
   * separated by a tab character.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * The content of the comment, i.e. review body. In some cases users have been able to write a
   * review with separate title and body; in those cases the title and body are concatenated and
   * separated by a tab character.
   * @param text text or {@code null} for none
   */
  public UserComment setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  /**
   * Number of users who have given this review a thumbs down
   * @return value or {@code null} for none
   */
  public java.lang.Integer getThumbsDownCount() {
    return thumbsDownCount;
  }

  /**
   * Number of users who have given this review a thumbs down
   * @param thumbsDownCount thumbsDownCount or {@code null} for none
   */
  public UserComment setThumbsDownCount(java.lang.Integer thumbsDownCount) {
    this.thumbsDownCount = thumbsDownCount;
    return this;
  }

  /**
   * Number of users who have given this review a thumbs up
   * @return value or {@code null} for none
   */
  public java.lang.Integer getThumbsUpCount() {
    return thumbsUpCount;
  }

  /**
   * Number of users who have given this review a thumbs up
   * @param thumbsUpCount thumbsUpCount or {@code null} for none
   */
  public UserComment setThumbsUpCount(java.lang.Integer thumbsUpCount) {
    this.thumbsUpCount = thumbsUpCount;
    return this;
  }

  @Override
  public UserComment set(String fieldName, Object value) {
    return (UserComment) super.set(fieldName, value);
  }

  @Override
  public UserComment clone() {
    return (UserComment) super.clone();
  }

}
