/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-07 at 21:00:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Model definition for Prorate.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Prorate extends com.google.api.client.json.GenericJson {

  /**
   * Default price cannot be zero and must be less than the full subscription price. Default price
   * is always in the developer's Checkout merchant currency. Targeted countries have their prices
   * set automatically based on the default_price.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price defaultPrice;

  /**
   * Defines the first day on which the price takes effect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MonthDay start;

  /**
   * Default price cannot be zero and must be less than the full subscription price. Default price
   * is always in the developer's Checkout merchant currency. Targeted countries have their prices
   * set automatically based on the default_price.
   * @return value or {@code null} for none
   */
  public Price getDefaultPrice() {
    return defaultPrice;
  }

  /**
   * Default price cannot be zero and must be less than the full subscription price. Default price
   * is always in the developer's Checkout merchant currency. Targeted countries have their prices
   * set automatically based on the default_price.
   * @param defaultPrice defaultPrice or {@code null} for none
   */
  public Prorate setDefaultPrice(Price defaultPrice) {
    this.defaultPrice = defaultPrice;
    return this;
  }

  /**
   * Defines the first day on which the price takes effect.
   * @return value or {@code null} for none
   */
  public MonthDay getStart() {
    return start;
  }

  /**
   * Defines the first day on which the price takes effect.
   * @param start start or {@code null} for none
   */
  public Prorate setStart(MonthDay start) {
    this.start = start;
    return this;
  }

  @Override
  public Prorate set(String fieldName, Object value) {
    return (Prorate) super.set(fieldName, value);
  }

  @Override
  public Prorate clone() {
    return (Prorate) super.clone();
  }

}
