/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-21 at 13:59:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * An artifact resource which gets created when uploading an APK or Android App Bundle through
 * internal app sharing.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InternalAppSharingArtifact extends com.google.api.client.json.GenericJson {

  /**
   * The SHA256 fingerprint of the certificate used to signed the generated artifact.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String certificateFingerprint;

  /**
   * The download URL generated for the uploaded artifact. Users that are authorized to download can
   * follow the link to the Play Store app to install it.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String downloadUrl;

  /**
   * The SHA-256 hash of the artifact represented as a lowercase hexadecimal number, matching the
   * output of the sha256sum command.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha256;

  /**
   * The SHA256 fingerprint of the certificate used to signed the generated artifact.
   * @return value or {@code null} for none
   */
  public java.lang.String getCertificateFingerprint() {
    return certificateFingerprint;
  }

  /**
   * The SHA256 fingerprint of the certificate used to signed the generated artifact.
   * @param certificateFingerprint certificateFingerprint or {@code null} for none
   */
  public InternalAppSharingArtifact setCertificateFingerprint(java.lang.String certificateFingerprint) {
    this.certificateFingerprint = certificateFingerprint;
    return this;
  }

  /**
   * The download URL generated for the uploaded artifact. Users that are authorized to download can
   * follow the link to the Play Store app to install it.
   * @return value or {@code null} for none
   */
  public java.lang.String getDownloadUrl() {
    return downloadUrl;
  }

  /**
   * The download URL generated for the uploaded artifact. Users that are authorized to download can
   * follow the link to the Play Store app to install it.
   * @param downloadUrl downloadUrl or {@code null} for none
   */
  public InternalAppSharingArtifact setDownloadUrl(java.lang.String downloadUrl) {
    this.downloadUrl = downloadUrl;
    return this;
  }

  /**
   * The SHA-256 hash of the artifact represented as a lowercase hexadecimal number, matching the
   * output of the sha256sum command.
   * @return value or {@code null} for none
   */
  public java.lang.String getSha256() {
    return sha256;
  }

  /**
   * The SHA-256 hash of the artifact represented as a lowercase hexadecimal number, matching the
   * output of the sha256sum command.
   * @param sha256 sha256 or {@code null} for none
   */
  public InternalAppSharingArtifact setSha256(java.lang.String sha256) {
    this.sha256 = sha256;
    return this;
  }

  @Override
  public InternalAppSharingArtifact set(String fieldName, Object value) {
    return (InternalAppSharingArtifact) super.set(fieldName, value);
  }

  @Override
  public InternalAppSharingArtifact clone() {
    return (InternalAppSharingArtifact) super.clone();
  }

}
