/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.artifactregistry.v1beta2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.artifactregistry.v1beta2.ArtifactRegistryRequest;
import com.google.api.services.artifactregistry.v1beta2.ArtifactRegistryRequestInitializer;
import com.google.api.services.artifactregistry.v1beta2.model.ArtifactRegistryPackage;
import com.google.api.services.artifactregistry.v1beta2.model.Empty;
import com.google.api.services.artifactregistry.v1beta2.model.GoogleDevtoolsArtifactregistryV1beta2File;
import com.google.api.services.artifactregistry.v1beta2.model.ImportAptArtifactsRequest;
import com.google.api.services.artifactregistry.v1beta2.model.ImportYumArtifactsRequest;
import com.google.api.services.artifactregistry.v1beta2.model.ListFilesResponse;
import com.google.api.services.artifactregistry.v1beta2.model.ListLocationsResponse;
import com.google.api.services.artifactregistry.v1beta2.model.ListPackagesResponse;
import com.google.api.services.artifactregistry.v1beta2.model.ListRepositoriesResponse;
import com.google.api.services.artifactregistry.v1beta2.model.ListTagsResponse;
import com.google.api.services.artifactregistry.v1beta2.model.ListVersionsResponse;
import com.google.api.services.artifactregistry.v1beta2.model.Location;
import com.google.api.services.artifactregistry.v1beta2.model.Operation;
import com.google.api.services.artifactregistry.v1beta2.model.Policy;
import com.google.api.services.artifactregistry.v1beta2.model.ProjectSettings;
import com.google.api.services.artifactregistry.v1beta2.model.Repository;
import com.google.api.services.artifactregistry.v1beta2.model.SetIamPolicyRequest;
import com.google.api.services.artifactregistry.v1beta2.model.Tag;
import com.google.api.services.artifactregistry.v1beta2.model.TestIamPermissionsRequest;
import com.google.api.services.artifactregistry.v1beta2.model.TestIamPermissionsResponse;
import com.google.api.services.artifactregistry.v1beta2.model.UploadAptArtifactMediaResponse;
import com.google.api.services.artifactregistry.v1beta2.model.UploadAptArtifactRequest;
import com.google.api.services.artifactregistry.v1beta2.model.UploadYumArtifactMediaResponse;
import com.google.api.services.artifactregistry.v1beta2.model.UploadYumArtifactRequest;
import com.google.api.services.artifactregistry.v1beta2.model.Version;
import java.io.IOException;
import java.util.regex.Pattern;

public class ArtifactRegistry
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://artifactregistry.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://artifactregistry.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://artifactregistry.googleapis.com/";

    public ArtifactRegistry(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    ArtifactRegistry(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Artifact Registry API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return ArtifactRegistry.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://artifactregistry.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), ArtifactRegistry.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ArtifactRegistry.DEFAULT_BATCH_PATH);
        }

        public ArtifactRegistry build() {
            return new ArtifactRegistry(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setArtifactRegistryRequestInitializer(ArtifactRegistryRequestInitializer artifactregistryRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)artifactregistryRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public GetProjectSettings getProjectSettings(String name) throws IOException {
            GetProjectSettings result = new GetProjectSettings(name);
            ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateProjectSettings updateProjectSettings(String name, ProjectSettings content) throws IOException {
            UpdateProjectSettings result = new UpdateProjectSettings(name, content);
            ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Operations operations() {
                return new Operations();
            }

            public Repositories repositories() {
                return new Repositories();
            }

            public class Repositories {
                public Create create(String parent, Repository content) throws IOException {
                    Create result = new Create(parent, content);
                    ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetIamPolicy getIamPolicy(String resource) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource);
                    ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Repository content) throws IOException {
                    Patch result = new Patch(name, content);
                    ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public AptArtifacts aptArtifacts() {
                    return new AptArtifacts();
                }

                public Files files() {
                    return new Files();
                }

                public Packages packages() {
                    return new Packages();
                }

                public YumArtifacts yumArtifacts() {
                    return new YumArtifacts();
                }

                public class YumArtifacts {
                    public ArtifactRegistryImport artifactregistryImport(String parent, ImportYumArtifactsRequest content) throws IOException {
                        ArtifactRegistryImport result = new ArtifactRegistryImport(parent, content);
                        ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Upload upload(String parent, UploadYumArtifactRequest content) throws IOException {
                        Upload result = new Upload(parent, content);
                        ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Upload upload(String parent, UploadYumArtifactRequest content, AbstractInputStreamContent mediaContent) throws IOException {
                        Upload result = new Upload(parent, content, mediaContent);
                        ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Upload
                    extends ArtifactRegistryRequest<UploadYumArtifactMediaResponse> {
                        private static final String REST_PATH = "v1beta2/{+parent}/yumArtifacts:create";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Upload(String parent, UploadYumArtifactRequest content) {
                            super(ArtifactRegistry.this, "POST", REST_PATH, (Object)content, UploadYumArtifactMediaResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                        }

                        protected Upload(String parent, UploadYumArtifactRequest content, AbstractInputStreamContent mediaContent) {
                            super(ArtifactRegistry.this, "POST", "/upload/" + ArtifactRegistry.this.getServicePath() + REST_PATH, (Object)content, UploadYumArtifactMediaResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            this.initializeMediaUpload(mediaContent);
                        }

                        public Upload set$Xgafv(String $Xgafv) {
                            return (Upload)super.set$Xgafv($Xgafv);
                        }

                        public Upload setAccessToken(String accessToken) {
                            return (Upload)super.setAccessToken(accessToken);
                        }

                        public Upload setAlt(String alt) {
                            return (Upload)super.setAlt(alt);
                        }

                        public Upload setCallback(String callback) {
                            return (Upload)super.setCallback(callback);
                        }

                        public Upload setFields(String fields) {
                            return (Upload)super.setFields(fields);
                        }

                        public Upload setKey(String key) {
                            return (Upload)super.setKey(key);
                        }

                        public Upload setOauthToken(String oauthToken) {
                            return (Upload)super.setOauthToken(oauthToken);
                        }

                        public Upload setPrettyPrint(Boolean prettyPrint) {
                            return (Upload)super.setPrettyPrint(prettyPrint);
                        }

                        public Upload setQuotaUser(String quotaUser) {
                            return (Upload)super.setQuotaUser(quotaUser);
                        }

                        public Upload setUploadType(String uploadType) {
                            return (Upload)super.setUploadType(uploadType);
                        }

                        public Upload setUploadProtocol(String uploadProtocol) {
                            return (Upload)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Upload setParent(String parent) {
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public Upload set(String parameterName, Object value) {
                            return (Upload)super.set(parameterName, value);
                        }
                    }

                    public class ArtifactRegistryImport
                    extends ArtifactRegistryRequest<Operation> {
                        private static final String REST_PATH = "v1beta2/{+parent}/yumArtifacts:import";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected ArtifactRegistryImport(String parent, ImportYumArtifactsRequest content) {
                            super(ArtifactRegistry.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                        }

                        public ArtifactRegistryImport set$Xgafv(String $Xgafv) {
                            return (ArtifactRegistryImport)super.set$Xgafv($Xgafv);
                        }

                        public ArtifactRegistryImport setAccessToken(String accessToken) {
                            return (ArtifactRegistryImport)super.setAccessToken(accessToken);
                        }

                        public ArtifactRegistryImport setAlt(String alt) {
                            return (ArtifactRegistryImport)super.setAlt(alt);
                        }

                        public ArtifactRegistryImport setCallback(String callback) {
                            return (ArtifactRegistryImport)super.setCallback(callback);
                        }

                        public ArtifactRegistryImport setFields(String fields) {
                            return (ArtifactRegistryImport)super.setFields(fields);
                        }

                        public ArtifactRegistryImport setKey(String key) {
                            return (ArtifactRegistryImport)super.setKey(key);
                        }

                        public ArtifactRegistryImport setOauthToken(String oauthToken) {
                            return (ArtifactRegistryImport)super.setOauthToken(oauthToken);
                        }

                        public ArtifactRegistryImport setPrettyPrint(Boolean prettyPrint) {
                            return (ArtifactRegistryImport)super.setPrettyPrint(prettyPrint);
                        }

                        public ArtifactRegistryImport setQuotaUser(String quotaUser) {
                            return (ArtifactRegistryImport)super.setQuotaUser(quotaUser);
                        }

                        public ArtifactRegistryImport setUploadType(String uploadType) {
                            return (ArtifactRegistryImport)super.setUploadType(uploadType);
                        }

                        public ArtifactRegistryImport setUploadProtocol(String uploadProtocol) {
                            return (ArtifactRegistryImport)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public ArtifactRegistryImport setParent(String parent) {
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public ArtifactRegistryImport set(String parameterName, Object value) {
                            return (ArtifactRegistryImport)super.set(parameterName, value);
                        }
                    }
                }

                public class Packages {
                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Tags tags() {
                        return new Tags();
                    }

                    public Versions versions() {
                        return new Versions();
                    }

                    public class Versions {
                        public Delete delete(String name) throws IOException {
                            Delete result = new Delete(name);
                            ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Get get(String name) throws IOException {
                            Get result = new Get(name);
                            ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public List list(String parent) throws IOException {
                            List result = new List(parent);
                            ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class List
                        extends ArtifactRegistryRequest<ListVersionsResponse> {
                            private static final String REST_PATH = "v1beta2/{+parent}/versions";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String orderBy;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;
                            @Key
                            private String view;

                            protected List(String parent) {
                                super(ArtifactRegistry.this, "GET", REST_PATH, null, ListVersionsResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public List setParent(String parent) {
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getOrderBy() {
                                return this.orderBy;
                            }

                            public List setOrderBy(String orderBy) {
                                this.orderBy = orderBy;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            public String getView() {
                                return this.view;
                            }

                            public List setView(String view) {
                                this.view = view;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }

                        public class Get
                        extends ArtifactRegistryRequest<Version> {
                            private static final String REST_PATH = "v1beta2/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;
                            @Key
                            private String view;

                            protected Get(String name) {
                                super(ArtifactRegistry.this, "GET", REST_PATH, null, Version.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/versions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/versions/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Get set$Xgafv(String $Xgafv) {
                                return (Get)super.set$Xgafv($Xgafv);
                            }

                            public Get setAccessToken(String accessToken) {
                                return (Get)super.setAccessToken(accessToken);
                            }

                            public Get setAlt(String alt) {
                                return (Get)super.setAlt(alt);
                            }

                            public Get setCallback(String callback) {
                                return (Get)super.setCallback(callback);
                            }

                            public Get setFields(String fields) {
                                return (Get)super.setFields(fields);
                            }

                            public Get setKey(String key) {
                                return (Get)super.setKey(key);
                            }

                            public Get setOauthToken(String oauthToken) {
                                return (Get)super.setOauthToken(oauthToken);
                            }

                            public Get setPrettyPrint(Boolean prettyPrint) {
                                return (Get)super.setPrettyPrint(prettyPrint);
                            }

                            public Get setQuotaUser(String quotaUser) {
                                return (Get)super.setQuotaUser(quotaUser);
                            }

                            public Get setUploadType(String uploadType) {
                                return (Get)super.setUploadType(uploadType);
                            }

                            public Get setUploadProtocol(String uploadProtocol) {
                                return (Get)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Get setName(String name) {
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/versions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            public String getView() {
                                return this.view;
                            }

                            public Get setView(String view) {
                                this.view = view;
                                return this;
                            }

                            @Override
                            public Get set(String parameterName, Object value) {
                                return (Get)super.set(parameterName, value);
                            }
                        }

                        public class Delete
                        extends ArtifactRegistryRequest<Operation> {
                            private static final String REST_PATH = "v1beta2/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;
                            @Key
                            private Boolean force;

                            protected Delete(String name) {
                                super(ArtifactRegistry.this, "DELETE", REST_PATH, null, Operation.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/versions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/versions/[^/]+$");
                                }
                            }

                            public Delete set$Xgafv(String $Xgafv) {
                                return (Delete)super.set$Xgafv($Xgafv);
                            }

                            public Delete setAccessToken(String accessToken) {
                                return (Delete)super.setAccessToken(accessToken);
                            }

                            public Delete setAlt(String alt) {
                                return (Delete)super.setAlt(alt);
                            }

                            public Delete setCallback(String callback) {
                                return (Delete)super.setCallback(callback);
                            }

                            public Delete setFields(String fields) {
                                return (Delete)super.setFields(fields);
                            }

                            public Delete setKey(String key) {
                                return (Delete)super.setKey(key);
                            }

                            public Delete setOauthToken(String oauthToken) {
                                return (Delete)super.setOauthToken(oauthToken);
                            }

                            public Delete setPrettyPrint(Boolean prettyPrint) {
                                return (Delete)super.setPrettyPrint(prettyPrint);
                            }

                            public Delete setQuotaUser(String quotaUser) {
                                return (Delete)super.setQuotaUser(quotaUser);
                            }

                            public Delete setUploadType(String uploadType) {
                                return (Delete)super.setUploadType(uploadType);
                            }

                            public Delete setUploadProtocol(String uploadProtocol) {
                                return (Delete)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Delete setName(String name) {
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/versions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            public Boolean getForce() {
                                return this.force;
                            }

                            public Delete setForce(Boolean force) {
                                this.force = force;
                                return this;
                            }

                            @Override
                            public Delete set(String parameterName, Object value) {
                                return (Delete)super.set(parameterName, value);
                            }
                        }
                    }

                    public class Tags {
                        public Create create(String parent, Tag content) throws IOException {
                            Create result = new Create(parent, content);
                            ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Delete delete(String name) throws IOException {
                            Delete result = new Delete(name);
                            ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Get get(String name) throws IOException {
                            Get result = new Get(name);
                            ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public List list(String parent) throws IOException {
                            List result = new List(parent);
                            ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Patch patch(String name, Tag content) throws IOException {
                            Patch result = new Patch(name, content);
                            ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class Patch
                        extends ArtifactRegistryRequest<Tag> {
                            private static final String REST_PATH = "v1beta2/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;
                            @Key
                            private String updateMask;

                            protected Patch(String name, Tag content) {
                                super(ArtifactRegistry.this, "PATCH", REST_PATH, (Object)content, Tag.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/tags/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/tags/[^/]+$");
                                }
                            }

                            public Patch set$Xgafv(String $Xgafv) {
                                return (Patch)super.set$Xgafv($Xgafv);
                            }

                            public Patch setAccessToken(String accessToken) {
                                return (Patch)super.setAccessToken(accessToken);
                            }

                            public Patch setAlt(String alt) {
                                return (Patch)super.setAlt(alt);
                            }

                            public Patch setCallback(String callback) {
                                return (Patch)super.setCallback(callback);
                            }

                            public Patch setFields(String fields) {
                                return (Patch)super.setFields(fields);
                            }

                            public Patch setKey(String key) {
                                return (Patch)super.setKey(key);
                            }

                            public Patch setOauthToken(String oauthToken) {
                                return (Patch)super.setOauthToken(oauthToken);
                            }

                            public Patch setPrettyPrint(Boolean prettyPrint) {
                                return (Patch)super.setPrettyPrint(prettyPrint);
                            }

                            public Patch setQuotaUser(String quotaUser) {
                                return (Patch)super.setQuotaUser(quotaUser);
                            }

                            public Patch setUploadType(String uploadType) {
                                return (Patch)super.setUploadType(uploadType);
                            }

                            public Patch setUploadProtocol(String uploadProtocol) {
                                return (Patch)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Patch setName(String name) {
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/tags/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            public String getUpdateMask() {
                                return this.updateMask;
                            }

                            public Patch setUpdateMask(String updateMask) {
                                this.updateMask = updateMask;
                                return this;
                            }

                            @Override
                            public Patch set(String parameterName, Object value) {
                                return (Patch)super.set(parameterName, value);
                            }
                        }

                        public class List
                        extends ArtifactRegistryRequest<ListTagsResponse> {
                            private static final String REST_PATH = "v1beta2/{+parent}/tags";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String filter;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;

                            protected List(String parent) {
                                super(ArtifactRegistry.this, "GET", REST_PATH, null, ListTagsResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public List setParent(String parent) {
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getFilter() {
                                return this.filter;
                            }

                            public List setFilter(String filter) {
                                this.filter = filter;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }

                        public class Get
                        extends ArtifactRegistryRequest<Tag> {
                            private static final String REST_PATH = "v1beta2/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Get(String name) {
                                super(ArtifactRegistry.this, "GET", REST_PATH, null, Tag.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/tags/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/tags/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Get set$Xgafv(String $Xgafv) {
                                return (Get)super.set$Xgafv($Xgafv);
                            }

                            public Get setAccessToken(String accessToken) {
                                return (Get)super.setAccessToken(accessToken);
                            }

                            public Get setAlt(String alt) {
                                return (Get)super.setAlt(alt);
                            }

                            public Get setCallback(String callback) {
                                return (Get)super.setCallback(callback);
                            }

                            public Get setFields(String fields) {
                                return (Get)super.setFields(fields);
                            }

                            public Get setKey(String key) {
                                return (Get)super.setKey(key);
                            }

                            public Get setOauthToken(String oauthToken) {
                                return (Get)super.setOauthToken(oauthToken);
                            }

                            public Get setPrettyPrint(Boolean prettyPrint) {
                                return (Get)super.setPrettyPrint(prettyPrint);
                            }

                            public Get setQuotaUser(String quotaUser) {
                                return (Get)super.setQuotaUser(quotaUser);
                            }

                            public Get setUploadType(String uploadType) {
                                return (Get)super.setUploadType(uploadType);
                            }

                            public Get setUploadProtocol(String uploadProtocol) {
                                return (Get)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Get setName(String name) {
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/tags/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Get set(String parameterName, Object value) {
                                return (Get)super.set(parameterName, value);
                            }
                        }

                        public class Delete
                        extends ArtifactRegistryRequest<Empty> {
                            private static final String REST_PATH = "v1beta2/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Delete(String name) {
                                super(ArtifactRegistry.this, "DELETE", REST_PATH, null, Empty.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/tags/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/tags/[^/]+$");
                                }
                            }

                            public Delete set$Xgafv(String $Xgafv) {
                                return (Delete)super.set$Xgafv($Xgafv);
                            }

                            public Delete setAccessToken(String accessToken) {
                                return (Delete)super.setAccessToken(accessToken);
                            }

                            public Delete setAlt(String alt) {
                                return (Delete)super.setAlt(alt);
                            }

                            public Delete setCallback(String callback) {
                                return (Delete)super.setCallback(callback);
                            }

                            public Delete setFields(String fields) {
                                return (Delete)super.setFields(fields);
                            }

                            public Delete setKey(String key) {
                                return (Delete)super.setKey(key);
                            }

                            public Delete setOauthToken(String oauthToken) {
                                return (Delete)super.setOauthToken(oauthToken);
                            }

                            public Delete setPrettyPrint(Boolean prettyPrint) {
                                return (Delete)super.setPrettyPrint(prettyPrint);
                            }

                            public Delete setQuotaUser(String quotaUser) {
                                return (Delete)super.setQuotaUser(quotaUser);
                            }

                            public Delete setUploadType(String uploadType) {
                                return (Delete)super.setUploadType(uploadType);
                            }

                            public Delete setUploadProtocol(String uploadProtocol) {
                                return (Delete)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Delete setName(String name) {
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+/tags/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Delete set(String parameterName, Object value) {
                                return (Delete)super.set(parameterName, value);
                            }
                        }

                        public class Create
                        extends ArtifactRegistryRequest<Tag> {
                            private static final String REST_PATH = "v1beta2/{+parent}/tags";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String tagId;

                            protected Create(String parent, Tag content) {
                                super(ArtifactRegistry.this, "POST", REST_PATH, (Object)content, Tag.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                                }
                            }

                            public Create set$Xgafv(String $Xgafv) {
                                return (Create)super.set$Xgafv($Xgafv);
                            }

                            public Create setAccessToken(String accessToken) {
                                return (Create)super.setAccessToken(accessToken);
                            }

                            public Create setAlt(String alt) {
                                return (Create)super.setAlt(alt);
                            }

                            public Create setCallback(String callback) {
                                return (Create)super.setCallback(callback);
                            }

                            public Create setFields(String fields) {
                                return (Create)super.setFields(fields);
                            }

                            public Create setKey(String key) {
                                return (Create)super.setKey(key);
                            }

                            public Create setOauthToken(String oauthToken) {
                                return (Create)super.setOauthToken(oauthToken);
                            }

                            public Create setPrettyPrint(Boolean prettyPrint) {
                                return (Create)super.setPrettyPrint(prettyPrint);
                            }

                            public Create setQuotaUser(String quotaUser) {
                                return (Create)super.setQuotaUser(quotaUser);
                            }

                            public Create setUploadType(String uploadType) {
                                return (Create)super.setUploadType(uploadType);
                            }

                            public Create setUploadProtocol(String uploadProtocol) {
                                return (Create)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public Create setParent(String parent) {
                                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getTagId() {
                                return this.tagId;
                            }

                            public Create setTagId(String tagId) {
                                this.tagId = tagId;
                                return this;
                            }

                            @Override
                            public Create set(String parameterName, Object value) {
                                return (Create)super.set(parameterName, value);
                            }
                        }
                    }

                    public class List
                    extends ArtifactRegistryRequest<ListPackagesResponse> {
                        private static final String REST_PATH = "v1beta2/{+parent}/packages";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(ArtifactRegistry.this, "GET", REST_PATH, null, ListPackagesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends ArtifactRegistryRequest<ArtifactRegistryPackage> {
                        private static final String REST_PATH = "v1beta2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(ArtifactRegistry.this, "GET", REST_PATH, null, ArtifactRegistryPackage.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends ArtifactRegistryRequest<Operation> {
                        private static final String REST_PATH = "v1beta2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(ArtifactRegistry.this, "DELETE", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/packages/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }
                }

                public class Files {
                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends ArtifactRegistryRequest<ListFilesResponse> {
                        private static final String REST_PATH = "v1beta2/{+parent}/files";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String filter;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(ArtifactRegistry.this, "GET", REST_PATH, null, ListFilesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends ArtifactRegistryRequest<GoogleDevtoolsArtifactregistryV1beta2File> {
                        private static final String REST_PATH = "v1beta2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(ArtifactRegistry.this, "GET", REST_PATH, null, GoogleDevtoolsArtifactregistryV1beta2File.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+/files/.*$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/files/.*$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+/files/.*$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }
                }

                public class AptArtifacts {
                    public ArtifactRegistryImport artifactregistryImport(String parent, ImportAptArtifactsRequest content) throws IOException {
                        ArtifactRegistryImport result = new ArtifactRegistryImport(parent, content);
                        ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Upload upload(String parent, UploadAptArtifactRequest content) throws IOException {
                        Upload result = new Upload(parent, content);
                        ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Upload upload(String parent, UploadAptArtifactRequest content, AbstractInputStreamContent mediaContent) throws IOException {
                        Upload result = new Upload(parent, content, mediaContent);
                        ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Upload
                    extends ArtifactRegistryRequest<UploadAptArtifactMediaResponse> {
                        private static final String REST_PATH = "v1beta2/{+parent}/aptArtifacts:create";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Upload(String parent, UploadAptArtifactRequest content) {
                            super(ArtifactRegistry.this, "POST", REST_PATH, (Object)content, UploadAptArtifactMediaResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                        }

                        protected Upload(String parent, UploadAptArtifactRequest content, AbstractInputStreamContent mediaContent) {
                            super(ArtifactRegistry.this, "POST", "/upload/" + ArtifactRegistry.this.getServicePath() + REST_PATH, (Object)content, UploadAptArtifactMediaResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            this.initializeMediaUpload(mediaContent);
                        }

                        public Upload set$Xgafv(String $Xgafv) {
                            return (Upload)super.set$Xgafv($Xgafv);
                        }

                        public Upload setAccessToken(String accessToken) {
                            return (Upload)super.setAccessToken(accessToken);
                        }

                        public Upload setAlt(String alt) {
                            return (Upload)super.setAlt(alt);
                        }

                        public Upload setCallback(String callback) {
                            return (Upload)super.setCallback(callback);
                        }

                        public Upload setFields(String fields) {
                            return (Upload)super.setFields(fields);
                        }

                        public Upload setKey(String key) {
                            return (Upload)super.setKey(key);
                        }

                        public Upload setOauthToken(String oauthToken) {
                            return (Upload)super.setOauthToken(oauthToken);
                        }

                        public Upload setPrettyPrint(Boolean prettyPrint) {
                            return (Upload)super.setPrettyPrint(prettyPrint);
                        }

                        public Upload setQuotaUser(String quotaUser) {
                            return (Upload)super.setQuotaUser(quotaUser);
                        }

                        public Upload setUploadType(String uploadType) {
                            return (Upload)super.setUploadType(uploadType);
                        }

                        public Upload setUploadProtocol(String uploadProtocol) {
                            return (Upload)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Upload setParent(String parent) {
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public Upload set(String parameterName, Object value) {
                            return (Upload)super.set(parameterName, value);
                        }
                    }

                    public class ArtifactRegistryImport
                    extends ArtifactRegistryRequest<Operation> {
                        private static final String REST_PATH = "v1beta2/{+parent}/aptArtifacts:import";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected ArtifactRegistryImport(String parent, ImportAptArtifactsRequest content) {
                            super(ArtifactRegistry.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                        }

                        public ArtifactRegistryImport set$Xgafv(String $Xgafv) {
                            return (ArtifactRegistryImport)super.set$Xgafv($Xgafv);
                        }

                        public ArtifactRegistryImport setAccessToken(String accessToken) {
                            return (ArtifactRegistryImport)super.setAccessToken(accessToken);
                        }

                        public ArtifactRegistryImport setAlt(String alt) {
                            return (ArtifactRegistryImport)super.setAlt(alt);
                        }

                        public ArtifactRegistryImport setCallback(String callback) {
                            return (ArtifactRegistryImport)super.setCallback(callback);
                        }

                        public ArtifactRegistryImport setFields(String fields) {
                            return (ArtifactRegistryImport)super.setFields(fields);
                        }

                        public ArtifactRegistryImport setKey(String key) {
                            return (ArtifactRegistryImport)super.setKey(key);
                        }

                        public ArtifactRegistryImport setOauthToken(String oauthToken) {
                            return (ArtifactRegistryImport)super.setOauthToken(oauthToken);
                        }

                        public ArtifactRegistryImport setPrettyPrint(Boolean prettyPrint) {
                            return (ArtifactRegistryImport)super.setPrettyPrint(prettyPrint);
                        }

                        public ArtifactRegistryImport setQuotaUser(String quotaUser) {
                            return (ArtifactRegistryImport)super.setQuotaUser(quotaUser);
                        }

                        public ArtifactRegistryImport setUploadType(String uploadType) {
                            return (ArtifactRegistryImport)super.setUploadType(uploadType);
                        }

                        public ArtifactRegistryImport setUploadProtocol(String uploadProtocol) {
                            return (ArtifactRegistryImport)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public ArtifactRegistryImport setParent(String parent) {
                            if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public ArtifactRegistryImport set(String parameterName, Object value) {
                            return (ArtifactRegistryImport)super.set(parameterName, value);
                        }
                    }
                }

                public class TestIamPermissions
                extends ArtifactRegistryRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1beta2/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(ArtifactRegistry.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends ArtifactRegistryRequest<Policy> {
                    private static final String REST_PATH = "v1beta2/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(ArtifactRegistry.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends ArtifactRegistryRequest<Repository> {
                    private static final String REST_PATH = "v1beta2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, Repository content) {
                        super(ArtifactRegistry.this, "PATCH", REST_PATH, (Object)content, Repository.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends ArtifactRegistryRequest<ListRepositoriesResponse> {
                    private static final String REST_PATH = "v1beta2/{+parent}/repositories";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(ArtifactRegistry.this, "GET", REST_PATH, null, ListRepositoriesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends ArtifactRegistryRequest<Policy> {
                    private static final String REST_PATH = "v1beta2/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;
                    @Key(value="options.requestedPolicyVersion")
                    private Integer optionsRequestedPolicyVersion;

                    protected GetIamPolicy(String resource) {
                        super(ArtifactRegistry.this, "GET", REST_PATH, null, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    public Integer getOptionsRequestedPolicyVersion() {
                        return this.optionsRequestedPolicyVersion;
                    }

                    public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Get
                extends ArtifactRegistryRequest<Repository> {
                    private static final String REST_PATH = "v1beta2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(ArtifactRegistry.this, "GET", REST_PATH, null, Repository.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends ArtifactRegistryRequest<Operation> {
                    private static final String REST_PATH = "v1beta2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(ArtifactRegistry.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/repositories/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends ArtifactRegistryRequest<Operation> {
                    private static final String REST_PATH = "v1beta2/{+parent}/repositories";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String repositoryId;

                    protected Create(String parent, Repository content) {
                        super(ArtifactRegistry.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getRepositoryId() {
                        return this.repositoryId;
                    }

                    public Create setRepositoryId(String repositoryId) {
                        this.repositoryId = repositoryId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Operations {
                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    ArtifactRegistry.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Get
                extends ArtifactRegistryRequest<Operation> {
                    private static final String REST_PATH = "v1beta2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(ArtifactRegistry.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends ArtifactRegistryRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v1beta2/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(ArtifactRegistry.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ArtifactRegistryRequest<Location> {
                private static final String REST_PATH = "v1beta2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(ArtifactRegistry.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class UpdateProjectSettings
        extends ArtifactRegistryRequest<ProjectSettings> {
            private static final String REST_PATH = "v1beta2/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected UpdateProjectSettings(String name, ProjectSettings content) {
                super(ArtifactRegistry.this, "PATCH", REST_PATH, (Object)content, ProjectSettings.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/projectSettings$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/projectSettings$");
                }
            }

            public UpdateProjectSettings set$Xgafv(String $Xgafv) {
                return (UpdateProjectSettings)super.set$Xgafv($Xgafv);
            }

            public UpdateProjectSettings setAccessToken(String accessToken) {
                return (UpdateProjectSettings)super.setAccessToken(accessToken);
            }

            public UpdateProjectSettings setAlt(String alt) {
                return (UpdateProjectSettings)super.setAlt(alt);
            }

            public UpdateProjectSettings setCallback(String callback) {
                return (UpdateProjectSettings)super.setCallback(callback);
            }

            public UpdateProjectSettings setFields(String fields) {
                return (UpdateProjectSettings)super.setFields(fields);
            }

            public UpdateProjectSettings setKey(String key) {
                return (UpdateProjectSettings)super.setKey(key);
            }

            public UpdateProjectSettings setOauthToken(String oauthToken) {
                return (UpdateProjectSettings)super.setOauthToken(oauthToken);
            }

            public UpdateProjectSettings setPrettyPrint(Boolean prettyPrint) {
                return (UpdateProjectSettings)super.setPrettyPrint(prettyPrint);
            }

            public UpdateProjectSettings setQuotaUser(String quotaUser) {
                return (UpdateProjectSettings)super.setQuotaUser(quotaUser);
            }

            public UpdateProjectSettings setUploadType(String uploadType) {
                return (UpdateProjectSettings)super.setUploadType(uploadType);
            }

            public UpdateProjectSettings setUploadProtocol(String uploadProtocol) {
                return (UpdateProjectSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public UpdateProjectSettings setName(String name) {
                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/projectSettings$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public UpdateProjectSettings setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public UpdateProjectSettings set(String parameterName, Object value) {
                return (UpdateProjectSettings)super.set(parameterName, value);
            }
        }

        public class GetProjectSettings
        extends ArtifactRegistryRequest<ProjectSettings> {
            private static final String REST_PATH = "v1beta2/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetProjectSettings(String name) {
                super(ArtifactRegistry.this, "GET", REST_PATH, null, ProjectSettings.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/projectSettings$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/projectSettings$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetProjectSettings set$Xgafv(String $Xgafv) {
                return (GetProjectSettings)super.set$Xgafv($Xgafv);
            }

            public GetProjectSettings setAccessToken(String accessToken) {
                return (GetProjectSettings)super.setAccessToken(accessToken);
            }

            public GetProjectSettings setAlt(String alt) {
                return (GetProjectSettings)super.setAlt(alt);
            }

            public GetProjectSettings setCallback(String callback) {
                return (GetProjectSettings)super.setCallback(callback);
            }

            public GetProjectSettings setFields(String fields) {
                return (GetProjectSettings)super.setFields(fields);
            }

            public GetProjectSettings setKey(String key) {
                return (GetProjectSettings)super.setKey(key);
            }

            public GetProjectSettings setOauthToken(String oauthToken) {
                return (GetProjectSettings)super.setOauthToken(oauthToken);
            }

            public GetProjectSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetProjectSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetProjectSettings setQuotaUser(String quotaUser) {
                return (GetProjectSettings)super.setQuotaUser(quotaUser);
            }

            public GetProjectSettings setUploadType(String uploadType) {
                return (GetProjectSettings)super.setUploadType(uploadType);
            }

            public GetProjectSettings setUploadProtocol(String uploadProtocol) {
                return (GetProjectSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetProjectSettings setName(String name) {
                if (!ArtifactRegistry.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/projectSettings$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetProjectSettings set(String parameterName, Object value) {
                return (GetProjectSettings)super.set(parameterName, value);
            }
        }
    }
}

