/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model evaluation metrics for a single ARIMA forecasting model.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ArimaSingleModelForecastingMetrics extends com.google.api.client.json.GenericJson {

  /**
   * Arima fitting metrics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ArimaFittingMetrics arimaFittingMetrics;

  /**
   * Is arima model fitted with drift or not. It is always false when d is not 1.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasDrift;

  /**
   * Non-seasonal order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ArimaOrder nonSeasonalOrder;

  /**
   * Seasonal periods. Repeated because multiple periods are supported for one time series.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> seasonalPeriods;

  /**
   * The id to indicate different time series.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeSeriesId;

  /**
   * Arima fitting metrics.
   * @return value or {@code null} for none
   */
  public ArimaFittingMetrics getArimaFittingMetrics() {
    return arimaFittingMetrics;
  }

  /**
   * Arima fitting metrics.
   * @param arimaFittingMetrics arimaFittingMetrics or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setArimaFittingMetrics(ArimaFittingMetrics arimaFittingMetrics) {
    this.arimaFittingMetrics = arimaFittingMetrics;
    return this;
  }

  /**
   * Is arima model fitted with drift or not. It is always false when d is not 1.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasDrift() {
    return hasDrift;
  }

  /**
   * Is arima model fitted with drift or not. It is always false when d is not 1.
   * @param hasDrift hasDrift or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setHasDrift(java.lang.Boolean hasDrift) {
    this.hasDrift = hasDrift;
    return this;
  }

  /**
   * Non-seasonal order.
   * @return value or {@code null} for none
   */
  public ArimaOrder getNonSeasonalOrder() {
    return nonSeasonalOrder;
  }

  /**
   * Non-seasonal order.
   * @param nonSeasonalOrder nonSeasonalOrder or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setNonSeasonalOrder(ArimaOrder nonSeasonalOrder) {
    this.nonSeasonalOrder = nonSeasonalOrder;
    return this;
  }

  /**
   * Seasonal periods. Repeated because multiple periods are supported for one time series.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSeasonalPeriods() {
    return seasonalPeriods;
  }

  /**
   * Seasonal periods. Repeated because multiple periods are supported for one time series.
   * @param seasonalPeriods seasonalPeriods or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setSeasonalPeriods(java.util.List<java.lang.String> seasonalPeriods) {
    this.seasonalPeriods = seasonalPeriods;
    return this;
  }

  /**
   * The id to indicate different time series.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeSeriesId() {
    return timeSeriesId;
  }

  /**
   * The id to indicate different time series.
   * @param timeSeriesId timeSeriesId or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setTimeSeriesId(java.lang.String timeSeriesId) {
    this.timeSeriesId = timeSeriesId;
    return this;
  }

  @Override
  public ArimaSingleModelForecastingMetrics set(String fieldName, Object value) {
    return (ArimaSingleModelForecastingMetrics) super.set(fieldName, value);
  }

  @Override
  public ArimaSingleModelForecastingMetrics clone() {
    return (ArimaSingleModelForecastingMetrics) super.clone();
  }

}
