/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery;

/**
 * Service definition for Bigquery (v2).
 *
 * <p>
 * A data platform for customers to create, manage, share and query data.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/bigquery/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link BigqueryRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Bigquery extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.31.0 of the BigQuery API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://bigquery.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://bigquery.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "bigquery/v2/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/bigquery/v2";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Bigquery(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Bigquery(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Datasets collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Datasets.List request = bigquery.datasets().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Datasets datasets() {
    return new Datasets();
  }

  /**
   * The "datasets" collection of methods.
   */
  public class Datasets {

    /**
     * Deletes the dataset specified by the datasetId value. Before you can delete a dataset, you must
     * delete all its tables, either manually or by specifying deleteContents. Immediately after
     * deletion, you can create another dataset with the same name.
     *
     * Create a request for the method "datasets.delete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the dataset being deleted
     * @param datasetId Dataset ID of dataset being deleted
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      Delete result = new Delete(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class Delete extends BigqueryRequest<Void> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";

      /**
       * Deletes the dataset specified by the datasetId value. Before you can delete a dataset, you must
       * delete all its tables, either manually or by specifying deleteContents. Immediately after
       * deletion, you can create another dataset with the same name.
       *
       * Create a request for the method "datasets.delete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the dataset being deleted
       * @param datasetId Dataset ID of dataset being deleted
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID of the dataset being deleted */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the dataset being deleted
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the dataset being deleted */
      public Delete setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of dataset being deleted */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of dataset being deleted
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of dataset being deleted */
      public Delete setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /**
       * If True, delete all the tables in the dataset. If False and the dataset contains tables,
       * the request will fail. Default is False
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean deleteContents;

      /** If True, delete all the tables in the dataset. If False and the dataset contains tables, the
     request will fail. Default is False
       */
      public java.lang.Boolean getDeleteContents() {
        return deleteContents;
      }

      /**
       * If True, delete all the tables in the dataset. If False and the dataset contains tables,
       * the request will fail. Default is False
       */
      public Delete setDeleteContents(java.lang.Boolean deleteContents) {
        this.deleteContents = deleteContents;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the dataset specified by datasetID.
     *
     * Create a request for the method "datasets.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the requested dataset
     * @param datasetId Dataset ID of the requested dataset
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      Get result = new Get(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";

      /**
       * Returns the dataset specified by datasetID.
       *
       * Create a request for the method "datasets.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the requested dataset
       * @param datasetId Dataset ID of the requested dataset
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID of the requested dataset */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the requested dataset
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the requested dataset */
      public Get setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the requested dataset */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the requested dataset
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the requested dataset */
      public Get setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new empty dataset.
     *
     * Create a request for the method "datasets.insert".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the new dataset
     * @param content the {@link com.google.api.services.bigquery.model.Dataset}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, com.google.api.services.bigquery.model.Dataset content) throws java.io.IOException {
      Insert result = new Insert(projectId, content);
      initialize(result);
      return result;
    }

    public class Insert extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{projectId}/datasets";

      /**
       * Creates a new empty dataset.
       *
       * Create a request for the method "datasets.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the new dataset
       * @param content the {@link com.google.api.services.bigquery.model.Dataset}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, com.google.api.services.bigquery.model.Dataset content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID of the new dataset */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the new dataset
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the new dataset */
      public Insert setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all datasets in the specified project to which you have been granted the READER dataset
     * role.
     *
     * Create a request for the method "datasets.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the datasets to be listed
     * @return the request
     */
    public List list(java.lang.String projectId) throws java.io.IOException {
      List result = new List(projectId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.DatasetList> {

      private static final String REST_PATH = "projects/{projectId}/datasets";

      /**
       * Lists all datasets in the specified project to which you have been granted the READER dataset
       * role.
       *
       * Create a request for the method "datasets.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the datasets to be listed
       * @since 1.13
       */
      protected List(java.lang.String projectId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.DatasetList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the datasets to be listed */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the datasets to be listed
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the datasets to be listed */
      public List setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Whether to list all datasets, including hidden ones */
      @com.google.api.client.util.Key
      private java.lang.Boolean all;

      /** Whether to list all datasets, including hidden ones
       */
      public java.lang.Boolean getAll() {
        return all;
      }

      /** Whether to list all datasets, including hidden ones */
      public List setAll(java.lang.Boolean all) {
        this.all = all;
        return this;
      }

      /**
       * An expression for filtering the results of the request by label. The syntax is
       * "labels.[:]". Multiple filters can be ANDed together by connecting with a space. Example:
       * "labels.department:receiving labels.active". See Filtering datasets using labels for
       * details.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** An expression for filtering the results of the request by label. The syntax is "labels.[:]".
     Multiple filters can be ANDed together by connecting with a space. Example:
     "labels.department:receiving labels.active". See Filtering datasets using labels for details.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * An expression for filtering the results of the request by label. The syntax is
       * "labels.[:]". Multiple filters can be ANDed together by connecting with a space. Example:
       * "labels.department:receiving labels.active". See Filtering datasets using labels for
       * details.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /** The maximum number of results to return */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results to return
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** The maximum number of results to return */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing dataset. The update method replaces the entire dataset
     * resource, whereas the patch method only replaces fields that are provided in the submitted
     * dataset resource. This method supports patch semantics.
     *
     * Create a request for the method "datasets.patch".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the dataset being updated
     * @param datasetId Dataset ID of the dataset being updated
     * @param content the {@link com.google.api.services.bigquery.model.Dataset}
     * @return the request
     */
    public Patch patch(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) throws java.io.IOException {
      Patch result = new Patch(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Patch extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";

      /**
       * Updates information in an existing dataset. The update method replaces the entire dataset
       * resource, whereas the patch method only replaces fields that are provided in the submitted
       * dataset resource. This method supports patch semantics.
       *
       * Create a request for the method "datasets.patch".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the dataset being updated
       * @param datasetId Dataset ID of the dataset being updated
       * @param content the {@link com.google.api.services.bigquery.model.Dataset}
       * @since 1.13
       */
      protected Patch(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) {
        super(Bigquery.this, "PATCH", REST_PATH, content, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the dataset being updated
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the dataset being updated */
      public Patch setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the dataset being updated
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the dataset being updated */
      public Patch setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing dataset. The update method replaces the entire dataset
     * resource, whereas the patch method only replaces fields that are provided in the submitted
     * dataset resource.
     *
     * Create a request for the method "datasets.update".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the dataset being updated
     * @param datasetId Dataset ID of the dataset being updated
     * @param content the {@link com.google.api.services.bigquery.model.Dataset}
     * @return the request
     */
    public Update update(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) throws java.io.IOException {
      Update result = new Update(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Update extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";

      /**
       * Updates information in an existing dataset. The update method replaces the entire dataset
       * resource, whereas the patch method only replaces fields that are provided in the submitted
       * dataset resource.
       *
       * Create a request for the method "datasets.update".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the dataset being updated
       * @param datasetId Dataset ID of the dataset being updated
       * @param content the {@link com.google.api.services.bigquery.model.Dataset}
       * @since 1.13
       */
      protected Update(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) {
        super(Bigquery.this, "PUT", REST_PATH, content, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the dataset being updated
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the dataset being updated */
      public Update setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the dataset being updated
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the dataset being updated */
      public Update setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Jobs collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Jobs.List request = bigquery.jobs().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Jobs jobs() {
    return new Jobs();
  }

  /**
   * The "jobs" collection of methods.
   */
  public class Jobs {

    /**
     * Requests that a job be cancelled. This call will return immediately, and the client will need to
     * poll for the job status to see if the cancel completed successfully. Cancelled jobs may still
     * incur costs.
     *
     * Create a request for the method "jobs.cancel".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
     *
     * @param projectId [Required] Project ID of the job to cancel
     * @param jobId [Required] Job ID of the job to cancel
     * @return the request
     */
    public Cancel cancel(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
      Cancel result = new Cancel(projectId, jobId);
      initialize(result);
      return result;
    }

    public class Cancel extends BigqueryRequest<com.google.api.services.bigquery.model.JobCancelResponse> {

      private static final String REST_PATH = "projects/{projectId}/jobs/{jobId}/cancel";

      /**
       * Requests that a job be cancelled. This call will return immediately, and the client will need
       * to poll for the job status to see if the cancel completed successfully. Cancelled jobs may
       * still incur costs.
       *
       * Create a request for the method "jobs.cancel".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
       * <p> {@link
       * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId [Required] Project ID of the job to cancel
       * @param jobId [Required] Job ID of the job to cancel
       * @since 1.13
       */
      protected Cancel(java.lang.String projectId, java.lang.String jobId) {
        super(Bigquery.this, "POST", REST_PATH, null, com.google.api.services.bigquery.model.JobCancelResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
      }

      @Override
      public Cancel setAlt(java.lang.String alt) {
        return (Cancel) super.setAlt(alt);
      }

      @Override
      public Cancel setFields(java.lang.String fields) {
        return (Cancel) super.setFields(fields);
      }

      @Override
      public Cancel setKey(java.lang.String key) {
        return (Cancel) super.setKey(key);
      }

      @Override
      public Cancel setOauthToken(java.lang.String oauthToken) {
        return (Cancel) super.setOauthToken(oauthToken);
      }

      @Override
      public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Cancel) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Cancel setQuotaUser(java.lang.String quotaUser) {
        return (Cancel) super.setQuotaUser(quotaUser);
      }

      @Override
      public Cancel setUserIp(java.lang.String userIp) {
        return (Cancel) super.setUserIp(userIp);
      }

      /** [Required] Project ID of the job to cancel */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**[ Required] Project ID of the job to cancel
    [

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** [Required] Project ID of the job to cancel */
      public Cancel setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** [Required] Job ID of the job to cancel */
      @com.google.api.client.util.Key
      private java.lang.String jobId;

      /**[ Required] Job ID of the job to cancel
    [

       */
      public java.lang.String getJobId() {
        return jobId;
      }

      /** [Required] Job ID of the job to cancel */
      public Cancel setJobId(java.lang.String jobId) {
        this.jobId = jobId;
        return this;
      }

      /**
       * The geographic location of the job. Required except for US and EU. See details at
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /** The geographic location of the job. Required except for US and EU. See details at
     https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * The geographic location of the job. Required except for US and EU. See details at
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public Cancel setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      @Override
      public Cancel set(String parameterName, Object value) {
        return (Cancel) super.set(parameterName, value);
      }
    }
    /**
     * Returns information about a specific job. Job information is available for a six month period
     * after creation. Requires that you're the person who ran the job, or have the Is Owner project
     * role.
     *
     * Create a request for the method "jobs.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId [Required] Project ID of the requested job
     * @param jobId [Required] Job ID of the requested job
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
      Get result = new Get(projectId, jobId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Job> {

      private static final String REST_PATH = "projects/{projectId}/jobs/{jobId}";

      /**
       * Returns information about a specific job. Job information is available for a six month period
       * after creation. Requires that you're the person who ran the job, or have the Is Owner project
       * role.
       *
       * Create a request for the method "jobs.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId [Required] Project ID of the requested job
       * @param jobId [Required] Job ID of the requested job
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String jobId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Job.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** [Required] Project ID of the requested job */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**[ Required] Project ID of the requested job
    [

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** [Required] Project ID of the requested job */
      public Get setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** [Required] Job ID of the requested job */
      @com.google.api.client.util.Key
      private java.lang.String jobId;

      /**[ Required] Job ID of the requested job
    [

       */
      public java.lang.String getJobId() {
        return jobId;
      }

      /** [Required] Job ID of the requested job */
      public Get setJobId(java.lang.String jobId) {
        this.jobId = jobId;
        return this;
      }

      /**
       * The geographic location of the job. Required except for US and EU. See details at
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /** The geographic location of the job. Required except for US and EU. See details at
     https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * The geographic location of the job. Required except for US and EU. See details at
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public Get setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the results of a query job.
     *
     * Create a request for the method "jobs.getQueryResults".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link GetQueryResults#execute()} method to invoke the remote operation.
     *
     * @param projectId [Required] Project ID of the query job
     * @param jobId [Required] Job ID of the query job
     * @return the request
     */
    public GetQueryResults getQueryResults(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
      GetQueryResults result = new GetQueryResults(projectId, jobId);
      initialize(result);
      return result;
    }

    public class GetQueryResults extends BigqueryRequest<com.google.api.services.bigquery.model.GetQueryResultsResponse> {

      private static final String REST_PATH = "projects/{projectId}/queries/{jobId}";

      /**
       * Retrieves the results of a query job.
       *
       * Create a request for the method "jobs.getQueryResults".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link GetQueryResults#execute()} method to invoke the remote
       * operation. <p> {@link GetQueryResults#initialize(com.google.api.client.googleapis.services.Abst
       * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param projectId [Required] Project ID of the query job
       * @param jobId [Required] Job ID of the query job
       * @since 1.13
       */
      protected GetQueryResults(java.lang.String projectId, java.lang.String jobId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.GetQueryResultsResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetQueryResults setAlt(java.lang.String alt) {
        return (GetQueryResults) super.setAlt(alt);
      }

      @Override
      public GetQueryResults setFields(java.lang.String fields) {
        return (GetQueryResults) super.setFields(fields);
      }

      @Override
      public GetQueryResults setKey(java.lang.String key) {
        return (GetQueryResults) super.setKey(key);
      }

      @Override
      public GetQueryResults setOauthToken(java.lang.String oauthToken) {
        return (GetQueryResults) super.setOauthToken(oauthToken);
      }

      @Override
      public GetQueryResults setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetQueryResults) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetQueryResults setQuotaUser(java.lang.String quotaUser) {
        return (GetQueryResults) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetQueryResults setUserIp(java.lang.String userIp) {
        return (GetQueryResults) super.setUserIp(userIp);
      }

      /** [Required] Project ID of the query job */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**[ Required] Project ID of the query job
    [

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** [Required] Project ID of the query job */
      public GetQueryResults setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** [Required] Job ID of the query job */
      @com.google.api.client.util.Key
      private java.lang.String jobId;

      /**[ Required] Job ID of the query job
    [

       */
      public java.lang.String getJobId() {
        return jobId;
      }

      /** [Required] Job ID of the query job */
      public GetQueryResults setJobId(java.lang.String jobId) {
        this.jobId = jobId;
        return this;
      }

      /**
       * The geographic location where the job should run. Required except for US and EU. See
       * details at https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /** The geographic location where the job should run. Required except for US and EU. See details at
     https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * The geographic location where the job should run. Required except for US and EU. See
       * details at https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public GetQueryResults setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      /** Maximum number of results to read */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of results to read
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of results to read */
      public GetQueryResults setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public GetQueryResults setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Zero-based index of the starting row */
      @com.google.api.client.util.Key
      private java.math.BigInteger startIndex;

      /** Zero-based index of the starting row
       */
      public java.math.BigInteger getStartIndex() {
        return startIndex;
      }

      /** Zero-based index of the starting row */
      public GetQueryResults setStartIndex(java.math.BigInteger startIndex) {
        this.startIndex = startIndex;
        return this;
      }

      /**
       * How long to wait for the query to complete, in milliseconds, before returning. Default is
       * 10 seconds. If the timeout passes before the job completes, the 'jobComplete' field in the
       * response will be false
       */
      @com.google.api.client.util.Key
      private java.lang.Long timeoutMs;

      /** How long to wait for the query to complete, in milliseconds, before returning. Default is 10
     seconds. If the timeout passes before the job completes, the 'jobComplete' field in the response
     will be false
       */
      public java.lang.Long getTimeoutMs() {
        return timeoutMs;
      }

      /**
       * How long to wait for the query to complete, in milliseconds, before returning. Default is
       * 10 seconds. If the timeout passes before the job completes, the 'jobComplete' field in the
       * response will be false
       */
      public GetQueryResults setTimeoutMs(java.lang.Long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
      }

      @Override
      public GetQueryResults set(String parameterName, Object value) {
        return (GetQueryResults) super.set(parameterName, value);
      }
    }
    /**
     * Starts a new asynchronous job. Requires the Can View project role.
     *
     * Create a request for the method "jobs.insert".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the project that will be billed for the job
     * @param content the {@link com.google.api.services.bigquery.model.Job}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content) throws java.io.IOException {
      Insert result = new Insert(projectId, content);
      initialize(result);
      return result;
    }

    /**
     * Starts a new asynchronous job. Requires the Can View project role.
     *
     * Create a request for the method "jobs.insert".
     *
     * This request holds the parameters needed by the the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param projectId Project ID of the project that will be billed for the job
     * @param content the {@link com.google.api.services.bigquery.model.Job} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(projectId, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends BigqueryRequest<com.google.api.services.bigquery.model.Job> {

      private static final String REST_PATH = "projects/{projectId}/jobs";

      /**
       * Starts a new asynchronous job. Requires the Can View project role.
       *
       * Create a request for the method "jobs.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the project that will be billed for the job
       * @param content the {@link com.google.api.services.bigquery.model.Job}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Job.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      /**
       * Starts a new asynchronous job. Requires the Can View project role.
       *
       * Create a request for the method "jobs.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param projectId Project ID of the project that will be billed for the job
       * @param content the {@link com.google.api.services.bigquery.model.Job} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Bigquery.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.bigquery.model.Job.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID of the project that will be billed for the job */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the project that will be billed for the job
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the project that will be billed for the job */
      public Insert setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all jobs that you started in the specified project. Job information is available for a six
     * month period after creation. The job list is sorted in reverse chronological order, by job
     * creation time. Requires the Can View project role, or the Is Owner project role if you set the
     * allUsers property.
     *
     * Create a request for the method "jobs.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the jobs to list
     * @return the request
     */
    public List list(java.lang.String projectId) throws java.io.IOException {
      List result = new List(projectId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.JobList> {

      private static final String REST_PATH = "projects/{projectId}/jobs";

      /**
       * Lists all jobs that you started in the specified project. Job information is available for a
       * six month period after creation. The job list is sorted in reverse chronological order, by job
       * creation time. Requires the Can View project role, or the Is Owner project role if you set the
       * allUsers property.
       *
       * Create a request for the method "jobs.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the jobs to list
       * @since 1.13
       */
      protected List(java.lang.String projectId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.JobList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the jobs to list */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the jobs to list
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the jobs to list */
      public List setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Whether to display jobs owned by all users in the project. Default false */
      @com.google.api.client.util.Key
      private java.lang.Boolean allUsers;

      /** Whether to display jobs owned by all users in the project. Default false
       */
      public java.lang.Boolean getAllUsers() {
        return allUsers;
      }

      /** Whether to display jobs owned by all users in the project. Default false */
      public List setAllUsers(java.lang.Boolean allUsers) {
        this.allUsers = allUsers;
        return this;
      }

      /**
       * Max value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs
       * created before or at this timestamp are returned
       */
      @com.google.api.client.util.Key
      private java.math.BigInteger maxCreationTime;

      /** Max value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs created
     before or at this timestamp are returned
       */
      public java.math.BigInteger getMaxCreationTime() {
        return maxCreationTime;
      }

      /**
       * Max value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs
       * created before or at this timestamp are returned
       */
      public List setMaxCreationTime(java.math.BigInteger maxCreationTime) {
        this.maxCreationTime = maxCreationTime;
        return this;
      }

      /** Maximum number of results to return */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of results to return
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of results to return */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Min value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs
       * created after or at this timestamp are returned
       */
      @com.google.api.client.util.Key
      private java.math.BigInteger minCreationTime;

      /** Min value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs created
     after or at this timestamp are returned
       */
      public java.math.BigInteger getMinCreationTime() {
        return minCreationTime;
      }

      /**
       * Min value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs
       * created after or at this timestamp are returned
       */
      public List setMinCreationTime(java.math.BigInteger minCreationTime) {
        this.minCreationTime = minCreationTime;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * If set, retrieves only jobs whose parent is this job. Otherwise, retrieves only jobs which
       * have no parent
       */
      @com.google.api.client.util.Key
      private java.lang.String parentJobId;

      /** If set, retrieves only jobs whose parent is this job. Otherwise, retrieves only jobs which have no
     parent
       */
      public java.lang.String getParentJobId() {
        return parentJobId;
      }

      /**
       * If set, retrieves only jobs whose parent is this job. Otherwise, retrieves only jobs which
       * have no parent
       */
      public List setParentJobId(java.lang.String parentJobId) {
        this.parentJobId = parentJobId;
        return this;
      }

      /** Restrict information returned to a set of selected fields */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Restrict information returned to a set of selected fields
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Restrict information returned to a set of selected fields */
      public List setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      /** Filter for job state */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> stateFilter;

      /** Filter for job state
       */
      public java.util.List<java.lang.String> getStateFilter() {
        return stateFilter;
      }

      /** Filter for job state */
      public List setStateFilter(java.util.List<java.lang.String> stateFilter) {
        this.stateFilter = stateFilter;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Runs a BigQuery SQL query synchronously and returns query results if the query completes within a
     * specified timeout.
     *
     * Create a request for the method "jobs.query".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Query#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the project billed for the query
     * @param content the {@link com.google.api.services.bigquery.model.QueryRequest}
     * @return the request
     */
    public Query query(java.lang.String projectId, com.google.api.services.bigquery.model.QueryRequest content) throws java.io.IOException {
      Query result = new Query(projectId, content);
      initialize(result);
      return result;
    }

    public class Query extends BigqueryRequest<com.google.api.services.bigquery.model.QueryResponse> {

      private static final String REST_PATH = "projects/{projectId}/queries";

      /**
       * Runs a BigQuery SQL query synchronously and returns query results if the query completes within
       * a specified timeout.
       *
       * Create a request for the method "jobs.query".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
       * <p> {@link
       * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the project billed for the query
       * @param content the {@link com.google.api.services.bigquery.model.QueryRequest}
       * @since 1.13
       */
      protected Query(java.lang.String projectId, com.google.api.services.bigquery.model.QueryRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.QueryResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public Query setAlt(java.lang.String alt) {
        return (Query) super.setAlt(alt);
      }

      @Override
      public Query setFields(java.lang.String fields) {
        return (Query) super.setFields(fields);
      }

      @Override
      public Query setKey(java.lang.String key) {
        return (Query) super.setKey(key);
      }

      @Override
      public Query setOauthToken(java.lang.String oauthToken) {
        return (Query) super.setOauthToken(oauthToken);
      }

      @Override
      public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Query) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Query setQuotaUser(java.lang.String quotaUser) {
        return (Query) super.setQuotaUser(quotaUser);
      }

      @Override
      public Query setUserIp(java.lang.String userIp) {
        return (Query) super.setUserIp(userIp);
      }

      /** Project ID of the project billed for the query */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the project billed for the query
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the project billed for the query */
      public Query setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Query set(String parameterName, Object value) {
        return (Query) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Models collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Models.List request = bigquery.models().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Models models() {
    return new Models();
  }

  /**
   * The "models" collection of methods.
   */
  public class Models {

    /**
     * Deletes the model specified by modelId from the dataset.
     *
     * Create a request for the method "models.delete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the model to delete.
     * @param datasetId Required. Dataset ID of the model to delete.
     * @param modelId Required. Model ID of the model to delete.
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId) throws java.io.IOException {
      Delete result = new Delete(projectId, datasetId, modelId);
      initialize(result);
      return result;
    }

    public class Delete extends BigqueryRequest<Void> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern MODEL_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Deletes the model specified by modelId from the dataset.
       *
       * Create a request for the method "models.delete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the model to delete.
       * @param datasetId Required. Dataset ID of the model to delete.
       * @param modelId Required. Model ID of the model to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId) {
        super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = com.google.api.client.util.Preconditions.checkNotNull(modelId, "Required parameter modelId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Required. Project ID of the model to delete. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the model to delete.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the model to delete. */
      public Delete setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the model to delete. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the model to delete.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the model to delete. */
      public Delete setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Model ID of the model to delete. */
      @com.google.api.client.util.Key
      private java.lang.String modelId;

      /** Required. Model ID of the model to delete.
       */
      public java.lang.String getModelId() {
        return modelId;
      }

      /** Required. Model ID of the model to delete. */
      public Delete setModelId(java.lang.String modelId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = modelId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets the specified model resource by model ID.
     *
     * Create a request for the method "models.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the requested model.
     * @param datasetId Required. Dataset ID of the requested model.
     * @param modelId Required. Model ID of the requested model.
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId) throws java.io.IOException {
      Get result = new Get(projectId, datasetId, modelId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Model> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern MODEL_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Gets the specified model resource by model ID.
       *
       * Create a request for the method "models.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the requested model.
       * @param datasetId Required. Dataset ID of the requested model.
       * @param modelId Required. Model ID of the requested model.
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Model.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = com.google.api.client.util.Preconditions.checkNotNull(modelId, "Required parameter modelId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Required. Project ID of the requested model. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the requested model.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the requested model. */
      public Get setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the requested model. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the requested model.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the requested model. */
      public Get setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Model ID of the requested model. */
      @com.google.api.client.util.Key
      private java.lang.String modelId;

      /** Required. Model ID of the requested model.
       */
      public java.lang.String getModelId() {
        return modelId;
      }

      /** Required. Model ID of the requested model. */
      public Get setModelId(java.lang.String modelId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = modelId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists all models in the specified dataset. Requires the READER dataset role.
     *
     * Create a request for the method "models.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the models to list.
     * @param datasetId Required. Dataset ID of the models to list.
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      List result = new List(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.ListModelsResponse> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Lists all models in the specified dataset. Requires the READER dataset role.
       *
       * Create a request for the method "models.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the models to list.
       * @param datasetId Required. Dataset ID of the models to list.
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.ListModelsResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Required. Project ID of the models to list. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the models to list.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the models to list. */
      public List setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the models to list. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the models to list.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the models to list. */
      public List setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results to return in a single response page. Leverage the page tokens to
     iterate through the entire collection.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Patch specific fields in the specified model.
     *
     * Create a request for the method "models.patch".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the model to patch.
     * @param datasetId Required. Dataset ID of the model to patch.
     * @param modelId Required. Model ID of the model to patch.
     * @param content the {@link com.google.api.services.bigquery.model.Model}
     * @return the request
     */
    public Patch patch(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId, com.google.api.services.bigquery.model.Model content) throws java.io.IOException {
      Patch result = new Patch(projectId, datasetId, modelId, content);
      initialize(result);
      return result;
    }

    public class Patch extends BigqueryRequest<com.google.api.services.bigquery.model.Model> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern MODEL_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Patch specific fields in the specified model.
       *
       * Create a request for the method "models.patch".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the model to patch.
       * @param datasetId Required. Dataset ID of the model to patch.
       * @param modelId Required. Model ID of the model to patch.
       * @param content the {@link com.google.api.services.bigquery.model.Model}
       * @since 1.13
       */
      protected Patch(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId, com.google.api.services.bigquery.model.Model content) {
        super(Bigquery.this, "PATCH", REST_PATH, content, com.google.api.services.bigquery.model.Model.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = com.google.api.client.util.Preconditions.checkNotNull(modelId, "Required parameter modelId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Required. Project ID of the model to patch. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the model to patch.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the model to patch. */
      public Patch setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the model to patch. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the model to patch.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the model to patch. */
      public Patch setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Model ID of the model to patch. */
      @com.google.api.client.util.Key
      private java.lang.String modelId;

      /** Required. Model ID of the model to patch.
       */
      public java.lang.String getModelId() {
        return modelId;
      }

      /** Required. Model ID of the model to patch. */
      public Patch setModelId(java.lang.String modelId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = modelId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Projects.List request = bigquery.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Returns the email address of the service account for your project used for interactions with
     * Google Cloud KMS.
     *
     * Create a request for the method "projects.getServiceAccount".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link GetServiceAccount#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID for which the service account is requested.
     * @return the request
     */
    public GetServiceAccount getServiceAccount(java.lang.String projectId) throws java.io.IOException {
      GetServiceAccount result = new GetServiceAccount(projectId);
      initialize(result);
      return result;
    }

    public class GetServiceAccount extends BigqueryRequest<com.google.api.services.bigquery.model.GetServiceAccountResponse> {

      private static final String REST_PATH = "projects/{projectId}/serviceAccount";

      /**
       * Returns the email address of the service account for your project used for interactions with
       * Google Cloud KMS.
       *
       * Create a request for the method "projects.getServiceAccount".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link GetServiceAccount#execute()} method to invoke the remote
       * operation. <p> {@link GetServiceAccount#initialize(com.google.api.client.googleapis.services.Ab
       * stractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param projectId Project ID for which the service account is requested.
       * @since 1.13
       */
      protected GetServiceAccount(java.lang.String projectId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.GetServiceAccountResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetServiceAccount setAlt(java.lang.String alt) {
        return (GetServiceAccount) super.setAlt(alt);
      }

      @Override
      public GetServiceAccount setFields(java.lang.String fields) {
        return (GetServiceAccount) super.setFields(fields);
      }

      @Override
      public GetServiceAccount setKey(java.lang.String key) {
        return (GetServiceAccount) super.setKey(key);
      }

      @Override
      public GetServiceAccount setOauthToken(java.lang.String oauthToken) {
        return (GetServiceAccount) super.setOauthToken(oauthToken);
      }

      @Override
      public GetServiceAccount setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetServiceAccount) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetServiceAccount setQuotaUser(java.lang.String quotaUser) {
        return (GetServiceAccount) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetServiceAccount setUserIp(java.lang.String userIp) {
        return (GetServiceAccount) super.setUserIp(userIp);
      }

      /** Project ID for which the service account is requested. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID for which the service account is requested.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID for which the service account is requested. */
      public GetServiceAccount setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public GetServiceAccount set(String parameterName, Object value) {
        return (GetServiceAccount) super.set(parameterName, value);
      }
    }
    /**
     * Lists all projects to which you have been granted any project role.
     *
     * Create a request for the method "projects.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.ProjectList> {

      private static final String REST_PATH = "projects";

      /**
       * Lists all projects to which you have been granted any project role.
       *
       * Create a request for the method "projects.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.ProjectList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Maximum number of results to return */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of results to return
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of results to return */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Routines collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Routines.List request = bigquery.routines().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Routines routines() {
    return new Routines();
  }

  /**
   * The "routines" collection of methods.
   */
  public class Routines {

    /**
     * Deletes the routine specified by routineId from the dataset.
     *
     * Create a request for the method "routines.delete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the routine to delete
     * @param datasetId Required. Dataset ID of the routine to delete
     * @param routineId Required. Routine ID of the routine to delete
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId) throws java.io.IOException {
      Delete result = new Delete(projectId, datasetId, routineId);
      initialize(result);
      return result;
    }

    public class Delete extends BigqueryRequest<Void> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern ROUTINE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Deletes the routine specified by routineId from the dataset.
       *
       * Create a request for the method "routines.delete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the routine to delete
       * @param datasetId Required. Dataset ID of the routine to delete
       * @param routineId Required. Routine ID of the routine to delete
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId) {
        super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = com.google.api.client.util.Preconditions.checkNotNull(routineId, "Required parameter routineId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Required. Project ID of the routine to delete */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the routine to delete
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the routine to delete */
      public Delete setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the routine to delete */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the routine to delete
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the routine to delete */
      public Delete setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Routine ID of the routine to delete */
      @com.google.api.client.util.Key
      private java.lang.String routineId;

      /** Required. Routine ID of the routine to delete
       */
      public java.lang.String getRoutineId() {
        return routineId;
      }

      /** Required. Routine ID of the routine to delete */
      public Delete setRoutineId(java.lang.String routineId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = routineId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets the specified routine resource by routine ID.
     *
     * Create a request for the method "routines.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the requested routine
     * @param datasetId Required. Dataset ID of the requested routine
     * @param routineId Required. Routine ID of the requested routine
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId) throws java.io.IOException {
      Get result = new Get(projectId, datasetId, routineId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Routine> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern ROUTINE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Gets the specified routine resource by routine ID.
       *
       * Create a request for the method "routines.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the requested routine
       * @param datasetId Required. Dataset ID of the requested routine
       * @param routineId Required. Routine ID of the requested routine
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Routine.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = com.google.api.client.util.Preconditions.checkNotNull(routineId, "Required parameter routineId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Required. Project ID of the requested routine */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the requested routine
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the requested routine */
      public Get setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the requested routine */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the requested routine
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the requested routine */
      public Get setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Routine ID of the requested routine */
      @com.google.api.client.util.Key
      private java.lang.String routineId;

      /** Required. Routine ID of the requested routine
       */
      public java.lang.String getRoutineId() {
        return routineId;
      }

      /** Required. Routine ID of the requested routine */
      public Get setRoutineId(java.lang.String routineId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = routineId;
        return this;
      }

      /**
       * If set, only the Routine fields in the field mask are returned in the response. If unset,
       * all Routine fields are returned.
       */
      @com.google.api.client.util.Key
      private String readMask;

      /** If set, only the Routine fields in the field mask are returned in the response. If unset, all
     Routine fields are returned.
       */
      public String getReadMask() {
        return readMask;
      }

      /**
       * If set, only the Routine fields in the field mask are returned in the response. If unset,
       * all Routine fields are returned.
       */
      public Get setReadMask(String readMask) {
        this.readMask = readMask;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new routine in the dataset.
     *
     * Create a request for the method "routines.insert".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the new routine
     * @param datasetId Required. Dataset ID of the new routine
     * @param content the {@link com.google.api.services.bigquery.model.Routine}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Routine content) throws java.io.IOException {
      Insert result = new Insert(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Insert extends BigqueryRequest<com.google.api.services.bigquery.model.Routine> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Creates a new routine in the dataset.
       *
       * Create a request for the method "routines.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the new routine
       * @param datasetId Required. Dataset ID of the new routine
       * @param content the {@link com.google.api.services.bigquery.model.Routine}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Routine content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Routine.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Required. Project ID of the new routine */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the new routine
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the new routine */
      public Insert setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the new routine */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the new routine
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the new routine */
      public Insert setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all routines in the specified dataset. Requires the READER dataset role.
     *
     * Create a request for the method "routines.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the routines to list
     * @param datasetId Required. Dataset ID of the routines to list
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      List result = new List(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.ListRoutinesResponse> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Lists all routines in the specified dataset. Requires the READER dataset role.
       *
       * Create a request for the method "routines.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the routines to list
       * @param datasetId Required. Dataset ID of the routines to list
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.ListRoutinesResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Required. Project ID of the routines to list */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the routines to list
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the routines to list */
      public List setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the routines to list */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the routines to list
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the routines to list */
      public List setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /**
       * If set, then only the Routines matching this filter are returned. The current supported
       * form is either "routine_type:" or "routineType:", where is a RoutineType enum. Example:
       * "routineType:SCALAR_FUNCTION".
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** If set, then only the Routines matching this filter are returned. The current supported form is
     either "routine_type:" or "routineType:", where is a RoutineType enum. Example:
     "routineType:SCALAR_FUNCTION".
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * If set, then only the Routines matching this filter are returned. The current supported
       * form is either "routine_type:" or "routineType:", where is a RoutineType enum. Example:
       * "routineType:SCALAR_FUNCTION".
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results to return in a single response page. Leverage the page tokens to
     iterate through the entire collection.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * If set, then only the Routine fields in the field mask, as well as project_id, dataset_id
       * and routine_id, are returned in the response. If unset, then the following Routine fields
       * are returned: etag, project_id, dataset_id, routine_id, routine_type, creation_time,
       * last_modified_time, and language.
       */
      @com.google.api.client.util.Key
      private String readMask;

      /** If set, then only the Routine fields in the field mask, as well as project_id, dataset_id and
     routine_id, are returned in the response. If unset, then the following Routine fields are returned:
     etag, project_id, dataset_id, routine_id, routine_type, creation_time, last_modified_time, and
     language.
       */
      public String getReadMask() {
        return readMask;
      }

      /**
       * If set, then only the Routine fields in the field mask, as well as project_id, dataset_id
       * and routine_id, are returned in the response. If unset, then the following Routine fields
       * are returned: etag, project_id, dataset_id, routine_id, routine_type, creation_time,
       * last_modified_time, and language.
       */
      public List setReadMask(String readMask) {
        this.readMask = readMask;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing routine. The update method replaces the entire Routine
     * resource.
     *
     * Create a request for the method "routines.update".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the routine to update
     * @param datasetId Required. Dataset ID of the routine to update
     * @param routineId Required. Routine ID of the routine to update
     * @param content the {@link com.google.api.services.bigquery.model.Routine}
     * @return the request
     */
    public Update update(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId, com.google.api.services.bigquery.model.Routine content) throws java.io.IOException {
      Update result = new Update(projectId, datasetId, routineId, content);
      initialize(result);
      return result;
    }

    public class Update extends BigqueryRequest<com.google.api.services.bigquery.model.Routine> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern ROUTINE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Updates information in an existing routine. The update method replaces the entire Routine
       * resource.
       *
       * Create a request for the method "routines.update".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the routine to update
       * @param datasetId Required. Dataset ID of the routine to update
       * @param routineId Required. Routine ID of the routine to update
       * @param content the {@link com.google.api.services.bigquery.model.Routine}
       * @since 1.13
       */
      protected Update(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId, com.google.api.services.bigquery.model.Routine content) {
        super(Bigquery.this, "PUT", REST_PATH, content, com.google.api.services.bigquery.model.Routine.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = com.google.api.client.util.Preconditions.checkNotNull(routineId, "Required parameter routineId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Required. Project ID of the routine to update */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the routine to update
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the routine to update */
      public Update setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the routine to update */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the routine to update
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the routine to update */
      public Update setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Routine ID of the routine to update */
      @com.google.api.client.util.Key
      private java.lang.String routineId;

      /** Required. Routine ID of the routine to update
       */
      public java.lang.String getRoutineId() {
        return routineId;
      }

      /** Required. Routine ID of the routine to update */
      public Update setRoutineId(java.lang.String routineId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = routineId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the RowAccessPolicies collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.RowAccessPolicies.List request = bigquery.rowAccessPolicies().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public RowAccessPolicies rowAccessPolicies() {
    return new RowAccessPolicies();
  }

  /**
   * The "rowAccessPolicies" collection of methods.
   */
  public class RowAccessPolicies {

    /**
     * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
     * does not have a policy set.
     *
     * Create a request for the method "rowAccessPolicies.getIamPolicy".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
     *        the appropriate value for this field.
     * @param content the {@link com.google.api.services.bigquery.model.GetIamPolicyRequest}
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.GetIamPolicyRequest content) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends BigqueryRequest<com.google.api.services.bigquery.model.Policy> {

      private static final String REST_PATH = "{+resource}:getIamPolicy";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");

      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists
       * and does not have a policy set.
       *
       * Create a request for the method "rowAccessPolicies.getIamPolicy".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
     *        the appropriate value for this field.
       * @param content the {@link com.google.api.services.bigquery.model.GetIamPolicyRequest}
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.GetIamPolicyRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
        }
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUserIp(java.lang.String userIp) {
        return (GetIamPolicy) super.setUserIp(userIp);
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. See the operation
       * documentation for the appropriate value for this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
     the appropriate value for this field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. See the operation
       * documentation for the appropriate value for this field.
       */
      public GetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Lists all row access policies on the specified table.
     *
     * Create a request for the method "rowAccessPolicies.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the row access policies to list.
     * @param datasetId Required. Dataset ID of row access policies to list.
     * @param tableId Required. Table ID of the table to list row access policies.
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) throws java.io.IOException {
      List result = new List(projectId, datasetId, tableId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.ListRowAccessPoliciesResponse> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern TABLE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Lists all row access policies on the specified table.
       *
       * Create a request for the method "rowAccessPolicies.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the row access policies to list.
       * @param datasetId Required. Dataset ID of row access policies to list.
       * @param tableId Required. Table ID of the table to list row access policies.
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.ListRowAccessPoliciesResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Required. Project ID of the row access policies to list. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the row access policies to list.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the row access policies to list. */
      public List setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of row access policies to list. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of row access policies to list.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of row access policies to list. */
      public List setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Table ID of the table to list row access policies. */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Required. Table ID of the table to list row access policies.
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Required. Table ID of the table to list row access policies. */
      public List setTableId(java.lang.String tableId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = tableId;
        return this;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of results to return in a single response page. Leverage the page tokens to
     iterate through the entire collection.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Sets the access control policy on the specified resource. Replaces any existing policy. Can
     * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
     *
     * Create a request for the method "rowAccessPolicies.setIamPolicy".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
     *        the appropriate value for this field.
     * @param content the {@link com.google.api.services.bigquery.model.SetIamPolicyRequest}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.SetIamPolicyRequest content) throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy extends BigqueryRequest<com.google.api.services.bigquery.model.Policy> {

      private static final String REST_PATH = "{+resource}:setIamPolicy";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");

      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy. Can
       * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
       *
       * Create a request for the method "rowAccessPolicies.setIamPolicy".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
     *        the appropriate value for this field.
       * @param content the {@link com.google.api.services.bigquery.model.SetIamPolicyRequest}
       * @since 1.13
       */
      protected SetIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.SetIamPolicyRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
        }
      }

      @Override
      public SetIamPolicy setAlt(java.lang.String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setFields(java.lang.String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(java.lang.String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUserIp(java.lang.String userIp) {
        return (SetIamPolicy) super.setUserIp(userIp);
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. See the operation
       * documentation for the appropriate value for this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
     the appropriate value for this field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. See the operation
       * documentation for the appropriate value for this field.
       */
      public SetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource. If the resource does not exist,
     * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
     * designed to be used for building permission-aware UIs and command-line tools, not for
     * authorization checking. This operation may "fail open" without warning.
     *
     * Create a request for the method "rowAccessPolicies.testIamPermissions".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
     *        documentation for the appropriate value for this field.
     * @param content the {@link com.google.api.services.bigquery.model.TestIamPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.bigquery.model.TestIamPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends BigqueryRequest<com.google.api.services.bigquery.model.TestIamPermissionsResponse> {

      private static final String REST_PATH = "{+resource}:testIamPermissions";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");

      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not
       * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
       * operation is designed to be used for building permission-aware UIs and command-line tools, not
       * for authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "rowAccessPolicies.testIamPermissions".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
     *        documentation for the appropriate value for this field.
       * @param content the {@link com.google.api.services.bigquery.model.TestIamPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String resource, com.google.api.services.bigquery.model.TestIamPermissionsRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.TestIamPermissionsResponse.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
        }
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUserIp(java.lang.String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. See the operation
       * documentation for the appropriate value for this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy detail is being requested. See the operation
     documentation for the appropriate value for this field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. See the operation
       * documentation for the appropriate value for this field.
       */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Tabledata collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Tabledata.List request = bigquery.tabledata().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Tabledata tabledata() {
    return new Tabledata();
  }

  /**
   * The "tabledata" collection of methods.
   */
  public class Tabledata {

    /**
     * Streams data into BigQuery one record at a time without needing to run a load job. Requires the
     * WRITER dataset role.
     *
     * Create a request for the method "tabledata.insertAll".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link InsertAll#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the destination table.
     * @param datasetId Dataset ID of the destination table.
     * @param tableId Table ID of the destination table.
     * @param content the {@link com.google.api.services.bigquery.model.TableDataInsertAllRequest}
     * @return the request
     */
    public InsertAll insertAll(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.TableDataInsertAllRequest content) throws java.io.IOException {
      InsertAll result = new InsertAll(projectId, datasetId, tableId, content);
      initialize(result);
      return result;
    }

    public class InsertAll extends BigqueryRequest<com.google.api.services.bigquery.model.TableDataInsertAllResponse> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}/insertAll";

      /**
       * Streams data into BigQuery one record at a time without needing to run a load job. Requires the
       * WRITER dataset role.
       *
       * Create a request for the method "tabledata.insertAll".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link InsertAll#execute()} method to invoke the remote
       * operation. <p> {@link
       * InsertAll#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the destination table.
       * @param datasetId Dataset ID of the destination table.
       * @param tableId Table ID of the destination table.
       * @param content the {@link com.google.api.services.bigquery.model.TableDataInsertAllRequest}
       * @since 1.13
       */
      protected InsertAll(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.TableDataInsertAllRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.TableDataInsertAllResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public InsertAll setAlt(java.lang.String alt) {
        return (InsertAll) super.setAlt(alt);
      }

      @Override
      public InsertAll setFields(java.lang.String fields) {
        return (InsertAll) super.setFields(fields);
      }

      @Override
      public InsertAll setKey(java.lang.String key) {
        return (InsertAll) super.setKey(key);
      }

      @Override
      public InsertAll setOauthToken(java.lang.String oauthToken) {
        return (InsertAll) super.setOauthToken(oauthToken);
      }

      @Override
      public InsertAll setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (InsertAll) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public InsertAll setQuotaUser(java.lang.String quotaUser) {
        return (InsertAll) super.setQuotaUser(quotaUser);
      }

      @Override
      public InsertAll setUserIp(java.lang.String userIp) {
        return (InsertAll) super.setUserIp(userIp);
      }

      /** Project ID of the destination table. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the destination table.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the destination table. */
      public InsertAll setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the destination table. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the destination table.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the destination table. */
      public InsertAll setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the destination table. */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the destination table.
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the destination table. */
      public InsertAll setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      @Override
      public InsertAll set(String parameterName, Object value) {
        return (InsertAll) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves table data from a specified set of rows. Requires the READER dataset role.
     *
     * Create a request for the method "tabledata.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the table to read
     * @param datasetId Dataset ID of the table to read
     * @param tableId Table ID of the table to read
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) throws java.io.IOException {
      List result = new List(projectId, datasetId, tableId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.TableDataList> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}/data";

      /**
       * Retrieves table data from a specified set of rows. Requires the READER dataset role.
       *
       * Create a request for the method "tabledata.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the table to read
       * @param datasetId Dataset ID of the table to read
       * @param tableId Table ID of the table to read
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.TableDataList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the table to read */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the table to read
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the table to read */
      public List setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the table to read */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the table to read
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the table to read */
      public List setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the table to read */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the table to read
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the table to read */
      public List setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      /** Maximum number of results to return */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of results to return
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of results to return */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, identifying the result set */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, identifying the result set
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, identifying the result set */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** List of fields to return (comma-separated). If unspecified, all fields are returned */
      @com.google.api.client.util.Key
      private java.lang.String selectedFields;

      /** List of fields to return (comma-separated). If unspecified, all fields are returned
       */
      public java.lang.String getSelectedFields() {
        return selectedFields;
      }

      /** List of fields to return (comma-separated). If unspecified, all fields are returned */
      public List setSelectedFields(java.lang.String selectedFields) {
        this.selectedFields = selectedFields;
        return this;
      }

      /** Zero-based index of the starting row to read */
      @com.google.api.client.util.Key
      private java.math.BigInteger startIndex;

      /** Zero-based index of the starting row to read
       */
      public java.math.BigInteger getStartIndex() {
        return startIndex;
      }

      /** Zero-based index of the starting row to read */
      public List setStartIndex(java.math.BigInteger startIndex) {
        this.startIndex = startIndex;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Tables collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Tables.List request = bigquery.tables().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Tables tables() {
    return new Tables();
  }

  /**
   * The "tables" collection of methods.
   */
  public class Tables {

    /**
     * Deletes the table specified by tableId from the dataset. If the table contains data, all the data
     * will be deleted.
     *
     * Create a request for the method "tables.delete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the table to delete
     * @param datasetId Dataset ID of the table to delete
     * @param tableId Table ID of the table to delete
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) throws java.io.IOException {
      Delete result = new Delete(projectId, datasetId, tableId);
      initialize(result);
      return result;
    }

    public class Delete extends BigqueryRequest<Void> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";

      /**
       * Deletes the table specified by tableId from the dataset. If the table contains data, all the
       * data will be deleted.
       *
       * Create a request for the method "tables.delete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the table to delete
       * @param datasetId Dataset ID of the table to delete
       * @param tableId Table ID of the table to delete
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) {
        super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID of the table to delete */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the table to delete
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the table to delete */
      public Delete setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the table to delete */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the table to delete
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the table to delete */
      public Delete setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the table to delete */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the table to delete
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the table to delete */
      public Delete setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets the specified table resource by table ID. This method does not return the data in the table,
     * it only returns the table resource, which describes the structure of this table.
     *
     * Create a request for the method "tables.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the requested table
     * @param datasetId Dataset ID of the requested table
     * @param tableId Table ID of the requested table
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) throws java.io.IOException {
      Get result = new Get(projectId, datasetId, tableId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";

      /**
       * Gets the specified table resource by table ID. This method does not return the data in the
       * table, it only returns the table resource, which describes the structure of this table.
       *
       * Create a request for the method "tables.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the requested table
       * @param datasetId Dataset ID of the requested table
       * @param tableId Table ID of the requested table
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID of the requested table */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the requested table
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the requested table */
      public Get setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the requested table */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the requested table
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the requested table */
      public Get setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the requested table */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the requested table
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the requested table */
      public Get setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      /** List of fields to return (comma-separated). If unspecified, all fields are returned */
      @com.google.api.client.util.Key
      private java.lang.String selectedFields;

      /** List of fields to return (comma-separated). If unspecified, all fields are returned
       */
      public java.lang.String getSelectedFields() {
        return selectedFields;
      }

      /** List of fields to return (comma-separated). If unspecified, all fields are returned */
      public Get setSelectedFields(java.lang.String selectedFields) {
        this.selectedFields = selectedFields;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
     * does not have a policy set.
     *
     * Create a request for the method "tables.getIamPolicy".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
     *        the appropriate value for this field.
     * @param content the {@link com.google.api.services.bigquery.model.GetIamPolicyRequest}
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.GetIamPolicyRequest content) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends BigqueryRequest<com.google.api.services.bigquery.model.Policy> {

      private static final String REST_PATH = "{+resource}:getIamPolicy";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");

      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists
       * and does not have a policy set.
       *
       * Create a request for the method "tables.getIamPolicy".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
     *        the appropriate value for this field.
       * @param content the {@link com.google.api.services.bigquery.model.GetIamPolicyRequest}
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.GetIamPolicyRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUserIp(java.lang.String userIp) {
        return (GetIamPolicy) super.setUserIp(userIp);
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. See the operation
       * documentation for the appropriate value for this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
     the appropriate value for this field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. See the operation
       * documentation for the appropriate value for this field.
       */
      public GetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new, empty table in the dataset.
     *
     * Create a request for the method "tables.insert".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the new table
     * @param datasetId Dataset ID of the new table
     * @param content the {@link com.google.api.services.bigquery.model.Table}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Table content) throws java.io.IOException {
      Insert result = new Insert(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Insert extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";

      /**
       * Creates a new, empty table in the dataset.
       *
       * Create a request for the method "tables.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the new table
       * @param datasetId Dataset ID of the new table
       * @param content the {@link com.google.api.services.bigquery.model.Table}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Table content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID of the new table */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the new table
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the new table */
      public Insert setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the new table */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the new table
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the new table */
      public Insert setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all tables in the specified dataset. Requires the READER dataset role.
     *
     * Create a request for the method "tables.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the tables to list
     * @param datasetId Dataset ID of the tables to list
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      List result = new List(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.TableList> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";

      /**
       * Lists all tables in the specified dataset. Requires the READER dataset role.
       *
       * Create a request for the method "tables.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the tables to list
       * @param datasetId Dataset ID of the tables to list
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.TableList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the tables to list */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the tables to list
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the tables to list */
      public List setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the tables to list */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the tables to list
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the tables to list */
      public List setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Maximum number of results to return */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of results to return
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of results to return */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing table. The update method replaces the entire table resource,
     * whereas the patch method only replaces fields that are provided in the submitted table resource.
     * This method supports patch semantics.
     *
     * Create a request for the method "tables.patch".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the table to update
     * @param datasetId Dataset ID of the table to update
     * @param tableId Table ID of the table to update
     * @param content the {@link com.google.api.services.bigquery.model.Table}
     * @return the request
     */
    public Patch patch(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) throws java.io.IOException {
      Patch result = new Patch(projectId, datasetId, tableId, content);
      initialize(result);
      return result;
    }

    public class Patch extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";

      /**
       * Updates information in an existing table. The update method replaces the entire table resource,
       * whereas the patch method only replaces fields that are provided in the submitted table
       * resource. This method supports patch semantics.
       *
       * Create a request for the method "tables.patch".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the table to update
       * @param datasetId Dataset ID of the table to update
       * @param tableId Table ID of the table to update
       * @param content the {@link com.google.api.services.bigquery.model.Table}
       * @since 1.13
       */
      protected Patch(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) {
        super(Bigquery.this, "PATCH", REST_PATH, content, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the table to update
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the table to update */
      public Patch setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the table to update
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the table to update */
      public Patch setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the table to update
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the table to update */
      public Patch setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Sets the access control policy on the specified resource. Replaces any existing policy. Can
     * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
     *
     * Create a request for the method "tables.setIamPolicy".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
     *        the appropriate value for this field.
     * @param content the {@link com.google.api.services.bigquery.model.SetIamPolicyRequest}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.SetIamPolicyRequest content) throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy extends BigqueryRequest<com.google.api.services.bigquery.model.Policy> {

      private static final String REST_PATH = "{+resource}:setIamPolicy";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");

      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy. Can
       * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
       *
       * Create a request for the method "tables.setIamPolicy".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
     *        the appropriate value for this field.
       * @param content the {@link com.google.api.services.bigquery.model.SetIamPolicyRequest}
       * @since 1.13
       */
      protected SetIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.SetIamPolicyRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
      }

      @Override
      public SetIamPolicy setAlt(java.lang.String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setFields(java.lang.String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(java.lang.String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUserIp(java.lang.String userIp) {
        return (SetIamPolicy) super.setUserIp(userIp);
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. See the operation
       * documentation for the appropriate value for this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
     the appropriate value for this field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. See the operation
       * documentation for the appropriate value for this field.
       */
      public SetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource. If the resource does not exist,
     * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
     * designed to be used for building permission-aware UIs and command-line tools, not for
     * authorization checking. This operation may "fail open" without warning.
     *
     * Create a request for the method "tables.testIamPermissions".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
     *        documentation for the appropriate value for this field.
     * @param content the {@link com.google.api.services.bigquery.model.TestIamPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.bigquery.model.TestIamPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends BigqueryRequest<com.google.api.services.bigquery.model.TestIamPermissionsResponse> {

      private static final String REST_PATH = "{+resource}:testIamPermissions";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");

      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not
       * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
       * operation is designed to be used for building permission-aware UIs and command-line tools, not
       * for authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "tables.testIamPermissions".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
     *        documentation for the appropriate value for this field.
       * @param content the {@link com.google.api.services.bigquery.model.TestIamPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String resource, com.google.api.services.bigquery.model.TestIamPermissionsRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.TestIamPermissionsResponse.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUserIp(java.lang.String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. See the operation
       * documentation for the appropriate value for this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy detail is being requested. See the operation
     documentation for the appropriate value for this field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. See the operation
       * documentation for the appropriate value for this field.
       */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing table. The update method replaces the entire table resource,
     * whereas the patch method only replaces fields that are provided in the submitted table resource.
     *
     * Create a request for the method "tables.update".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the table to update
     * @param datasetId Dataset ID of the table to update
     * @param tableId Table ID of the table to update
     * @param content the {@link com.google.api.services.bigquery.model.Table}
     * @return the request
     */
    public Update update(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) throws java.io.IOException {
      Update result = new Update(projectId, datasetId, tableId, content);
      initialize(result);
      return result;
    }

    public class Update extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";

      /**
       * Updates information in an existing table. The update method replaces the entire table resource,
       * whereas the patch method only replaces fields that are provided in the submitted table
       * resource.
       *
       * Create a request for the method "tables.update".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the table to update
       * @param datasetId Dataset ID of the table to update
       * @param tableId Table ID of the table to update
       * @param content the {@link com.google.api.services.bigquery.model.Table}
       * @since 1.13
       */
      protected Update(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) {
        super(Bigquery.this, "PUT", REST_PATH, content, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the table to update
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the table to update */
      public Update setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the table to update
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the table to update */
      public Update setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the table to update
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the table to update */
      public Update setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Bigquery}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Bigquery}. */
    @Override
    public Bigquery build() {
      return new Bigquery(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link BigqueryRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setBigqueryRequestInitializer(
        BigqueryRequestInitializer bigqueryRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(bigqueryRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
