/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Global explanations containing the top most important features after training.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GlobalExplanation extends com.google.api.client.json.GenericJson {

  /**
   * Class label for this set of global explanations. Will be empty/null for binary logistic and
   * linear regression models. Sorted alphabetically in descending order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String classLabel;

  /**
   * A list of the top global explanations. Sorted by absolute value of attribution in descending
   * order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Explanation> explanations;

  static {
    // hack to force ProGuard to consider Explanation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Explanation.class);
  }

  /**
   * Class label for this set of global explanations. Will be empty/null for binary logistic and
   * linear regression models. Sorted alphabetically in descending order.
   * @return value or {@code null} for none
   */
  public java.lang.String getClassLabel() {
    return classLabel;
  }

  /**
   * Class label for this set of global explanations. Will be empty/null for binary logistic and
   * linear regression models. Sorted alphabetically in descending order.
   * @param classLabel classLabel or {@code null} for none
   */
  public GlobalExplanation setClassLabel(java.lang.String classLabel) {
    this.classLabel = classLabel;
    return this;
  }

  /**
   * A list of the top global explanations. Sorted by absolute value of attribution in descending
   * order.
   * @return value or {@code null} for none
   */
  public java.util.List<Explanation> getExplanations() {
    return explanations;
  }

  /**
   * A list of the top global explanations. Sorted by absolute value of attribution in descending
   * order.
   * @param explanations explanations or {@code null} for none
   */
  public GlobalExplanation setExplanations(java.util.List<Explanation> explanations) {
    this.explanations = explanations;
    return this;
  }

  @Override
  public GlobalExplanation set(String fieldName, Object value) {
    return (GlobalExplanation) super.set(fieldName, value);
  }

  @Override
  public GlobalExplanation clone() {
    return (GlobalExplanation) super.clone();
  }

}
