/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for DestinationTableProperties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DestinationTableProperties extends com.google.api.client.json.GenericJson {

  /**
   * [Optional] The description for the destination table. This will only be used if the destination
   * table is newly created. If the table already exists and a value different than the current
   * description is provided, the job will fail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Optional] The expiration timestamp for the destination table. If this field is set: For a new
   * table, it will set the table's expiration time (even if there is a dataset level default table
   * expiration time). For an existing table, it will update the table's expiration time. If this
   * field is not set: For a new table, if dataset level default table expiration time is present,
   * that will be applied. For an existing table, no change is made to the table's expiration time.
   * Additionally this field is only applied when data is written to an empty table (WRITE_EMPTY) or
   * data is overwritten to a table (WRITE_TRUNCATE).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expirationTimestampMillis;

  /**
   * [Optional] The friendly name for the destination table. This will only be used if the
   * destination table is newly created. If the table already exists and a value different than the
   * current friendly name is provided, the job will fail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String friendlyName;

  /**
   * [Optional] The labels associated with this table. You can use these to organize and group your
   * tables. This will only be used if the destination table is newly created. If the table already
   * exists and labels are different than the current labels are provided, the job will fail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * [Optional] The description for the destination table. This will only be used if the destination
   * table is newly created. If the table already exists and a value different than the current
   * description is provided, the job will fail.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Optional] The description for the destination table. This will only be used if the destination
   * table is newly created. If the table already exists and a value different than the current
   * description is provided, the job will fail.
   * @param description description or {@code null} for none
   */
  public DestinationTableProperties setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Optional] The expiration timestamp for the destination table. If this field is set: For a new
   * table, it will set the table's expiration time (even if there is a dataset level default table
   * expiration time). For an existing table, it will update the table's expiration time. If this
   * field is not set: For a new table, if dataset level default table expiration time is present,
   * that will be applied. For an existing table, no change is made to the table's expiration time.
   * Additionally this field is only applied when data is written to an empty table (WRITE_EMPTY) or
   * data is overwritten to a table (WRITE_TRUNCATE).
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpirationTimestampMillis() {
    return expirationTimestampMillis;
  }

  /**
   * [Optional] The expiration timestamp for the destination table. If this field is set: For a new
   * table, it will set the table's expiration time (even if there is a dataset level default table
   * expiration time). For an existing table, it will update the table's expiration time. If this
   * field is not set: For a new table, if dataset level default table expiration time is present,
   * that will be applied. For an existing table, no change is made to the table's expiration time.
   * Additionally this field is only applied when data is written to an empty table (WRITE_EMPTY) or
   * data is overwritten to a table (WRITE_TRUNCATE).
   * @param expirationTimestampMillis expirationTimestampMillis or {@code null} for none
   */
  public DestinationTableProperties setExpirationTimestampMillis(java.lang.Long expirationTimestampMillis) {
    this.expirationTimestampMillis = expirationTimestampMillis;
    return this;
  }

  /**
   * [Optional] The friendly name for the destination table. This will only be used if the
   * destination table is newly created. If the table already exists and a value different than the
   * current friendly name is provided, the job will fail.
   * @return value or {@code null} for none
   */
  public java.lang.String getFriendlyName() {
    return friendlyName;
  }

  /**
   * [Optional] The friendly name for the destination table. This will only be used if the
   * destination table is newly created. If the table already exists and a value different than the
   * current friendly name is provided, the job will fail.
   * @param friendlyName friendlyName or {@code null} for none
   */
  public DestinationTableProperties setFriendlyName(java.lang.String friendlyName) {
    this.friendlyName = friendlyName;
    return this;
  }

  /**
   * [Optional] The labels associated with this table. You can use these to organize and group your
   * tables. This will only be used if the destination table is newly created. If the table already
   * exists and labels are different than the current labels are provided, the job will fail.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * [Optional] The labels associated with this table. You can use these to organize and group your
   * tables. This will only be used if the destination table is newly created. If the table already
   * exists and labels are different than the current labels are provided, the job will fail.
   * @param labels labels or {@code null} for none
   */
  public DestinationTableProperties setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  @Override
  public DestinationTableProperties set(String fieldName, Object value) {
    return (DestinationTableProperties) super.set(fieldName, value);
  }

  @Override
  public DestinationTableProperties clone() {
    return (DestinationTableProperties) super.clone();
  }

}
