/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Information about a single training query run for the model.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TrainingRun extends com.google.api.client.json.GenericJson {

  /**
   * Global explanation contains the explanation of top features on the class level. Applies to
   * classification models only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GlobalExplanation> classLevelGlobalExplanations;

  static {
    // hack to force ProGuard to consider GlobalExplanation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GlobalExplanation.class);
  }

  /**
   * Data split result of the training run. Only set when the input data is actually split.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSplitResult dataSplitResult;

  /**
   * The evaluation metrics over training/eval data that were computed at the end of training.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EvaluationMetrics evaluationMetrics;

  /**
   * Global explanation contains the explanation of top features on the model level. Applies to both
   * regression and classification models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GlobalExplanation modelLevelGlobalExplanation;

  /**
   * Output of each iteration run, results.size() <= max_iterations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<IterationResult> results;

  static {
    // hack to force ProGuard to consider IterationResult used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(IterationResult.class);
  }

  /**
   * The start time of this training run.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * Options that were used for this training run, includes user specified and default options that
   * were used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TrainingOptions trainingOptions;

  /**
   * Global explanation contains the explanation of top features on the class level. Applies to
   * classification models only.
   * @return value or {@code null} for none
   */
  public java.util.List<GlobalExplanation> getClassLevelGlobalExplanations() {
    return classLevelGlobalExplanations;
  }

  /**
   * Global explanation contains the explanation of top features on the class level. Applies to
   * classification models only.
   * @param classLevelGlobalExplanations classLevelGlobalExplanations or {@code null} for none
   */
  public TrainingRun setClassLevelGlobalExplanations(java.util.List<GlobalExplanation> classLevelGlobalExplanations) {
    this.classLevelGlobalExplanations = classLevelGlobalExplanations;
    return this;
  }

  /**
   * Data split result of the training run. Only set when the input data is actually split.
   * @return value or {@code null} for none
   */
  public DataSplitResult getDataSplitResult() {
    return dataSplitResult;
  }

  /**
   * Data split result of the training run. Only set when the input data is actually split.
   * @param dataSplitResult dataSplitResult or {@code null} for none
   */
  public TrainingRun setDataSplitResult(DataSplitResult dataSplitResult) {
    this.dataSplitResult = dataSplitResult;
    return this;
  }

  /**
   * The evaluation metrics over training/eval data that were computed at the end of training.
   * @return value or {@code null} for none
   */
  public EvaluationMetrics getEvaluationMetrics() {
    return evaluationMetrics;
  }

  /**
   * The evaluation metrics over training/eval data that were computed at the end of training.
   * @param evaluationMetrics evaluationMetrics or {@code null} for none
   */
  public TrainingRun setEvaluationMetrics(EvaluationMetrics evaluationMetrics) {
    this.evaluationMetrics = evaluationMetrics;
    return this;
  }

  /**
   * Global explanation contains the explanation of top features on the model level. Applies to both
   * regression and classification models.
   * @return value or {@code null} for none
   */
  public GlobalExplanation getModelLevelGlobalExplanation() {
    return modelLevelGlobalExplanation;
  }

  /**
   * Global explanation contains the explanation of top features on the model level. Applies to both
   * regression and classification models.
   * @param modelLevelGlobalExplanation modelLevelGlobalExplanation or {@code null} for none
   */
  public TrainingRun setModelLevelGlobalExplanation(GlobalExplanation modelLevelGlobalExplanation) {
    this.modelLevelGlobalExplanation = modelLevelGlobalExplanation;
    return this;
  }

  /**
   * Output of each iteration run, results.size() <= max_iterations.
   * @return value or {@code null} for none
   */
  public java.util.List<IterationResult> getResults() {
    return results;
  }

  /**
   * Output of each iteration run, results.size() <= max_iterations.
   * @param results results or {@code null} for none
   */
  public TrainingRun setResults(java.util.List<IterationResult> results) {
    this.results = results;
    return this;
  }

  /**
   * The start time of this training run.
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * The start time of this training run.
   * @param startTime startTime or {@code null} for none
   */
  public TrainingRun setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Options that were used for this training run, includes user specified and default options that
   * were used.
   * @return value or {@code null} for none
   */
  public TrainingOptions getTrainingOptions() {
    return trainingOptions;
  }

  /**
   * Options that were used for this training run, includes user specified and default options that
   * were used.
   * @param trainingOptions trainingOptions or {@code null} for none
   */
  public TrainingRun setTrainingOptions(TrainingOptions trainingOptions) {
    this.trainingOptions = trainingOptions;
    return this;
  }

  @Override
  public TrainingRun set(String fieldName, Object value) {
    return (TrainingRun) super.set(fieldName, value);
  }

  @Override
  public TrainingRun clone() {
    return (TrainingRun) super.clone();
  }

}
