/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for MlStatistics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MlStatistics extends com.google.api.client.json.GenericJson {

  /**
   * Results for all completed iterations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<IterationResult> iterationResults;

  static {
    // hack to force ProGuard to consider IterationResult used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(IterationResult.class);
  }

  /**
   * Maximum number of iterations specified as max_iterations in the 'CREATE MODEL' query. The
   * actual number of iterations may be less than this number due to early stop.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxIterations;

  /**
   * Results for all completed iterations.
   * @return value or {@code null} for none
   */
  public java.util.List<IterationResult> getIterationResults() {
    return iterationResults;
  }

  /**
   * Results for all completed iterations.
   * @param iterationResults iterationResults or {@code null} for none
   */
  public MlStatistics setIterationResults(java.util.List<IterationResult> iterationResults) {
    this.iterationResults = iterationResults;
    return this;
  }

  /**
   * Maximum number of iterations specified as max_iterations in the 'CREATE MODEL' query. The
   * actual number of iterations may be less than this number due to early stop.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxIterations() {
    return maxIterations;
  }

  /**
   * Maximum number of iterations specified as max_iterations in the 'CREATE MODEL' query. The
   * actual number of iterations may be less than this number due to early stop.
   * @param maxIterations maxIterations or {@code null} for none
   */
  public MlStatistics setMaxIterations(java.lang.Long maxIterations) {
    this.maxIterations = maxIterations;
    return this;
  }

  @Override
  public MlStatistics set(String fieldName, Object value) {
    return (MlStatistics) super.set(fieldName, value);
  }

  @Override
  public MlStatistics clone() {
    return (MlStatistics) super.clone();
  }

}
