/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for DataMaskingStatistics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataMaskingStatistics extends com.google.api.client.json.GenericJson {

  /**
   * [Output-only] [Preview] Whether any accessed data was protected by data masking. The actual
   * evaluation is done by accessStats.masked_field_count > 0. Since this is only used for the
   * discovery_doc generation purpose, as long as the type (boolean) matches, client library can
   * leverage this. The actual evaluation of the variable is done else-where.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dataMaskingApplied;

  /**
   * [Output-only] [Preview] Whether any accessed data was protected by data masking. The actual
   * evaluation is done by accessStats.masked_field_count > 0. Since this is only used for the
   * discovery_doc generation purpose, as long as the type (boolean) matches, client library can
   * leverage this. The actual evaluation of the variable is done else-where.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDataMaskingApplied() {
    return dataMaskingApplied;
  }

  /**
   * [Output-only] [Preview] Whether any accessed data was protected by data masking. The actual
   * evaluation is done by accessStats.masked_field_count > 0. Since this is only used for the
   * discovery_doc generation purpose, as long as the type (boolean) matches, client library can
   * leverage this. The actual evaluation of the variable is done else-where.
   * @param dataMaskingApplied dataMaskingApplied or {@code null} for none
   */
  public DataMaskingStatistics setDataMaskingApplied(java.lang.Boolean dataMaskingApplied) {
    this.dataMaskingApplied = dataMaskingApplied;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   *[ Output-only] [Preview] Whether any accessed data was protected by data masking. The actual
[ evaluation is done by accessStats.masked_field_count > 0. Since this is only used for the
[ discovery_doc generation purpose, as long as the type (boolean) matches, client library can
[ leverage this. The actual evaluation of the variable is done else-where.
   * </p>
   */
  public boolean isDataMaskingApplied() {
    if (dataMaskingApplied == null || dataMaskingApplied == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return dataMaskingApplied;
  }

  @Override
  public DataMaskingStatistics set(String fieldName, Object value) {
    return (DataMaskingStatistics) super.set(fieldName, value);
  }

  @Override
  public DataMaskingStatistics clone() {
    return (DataMaskingStatistics) super.clone();
  }

}
