/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * This is used for defining User Defined Function (UDF) resources only when using legacy SQL. Users
 * of Standard SQL should leverage either DDL (e.g. CREATE [TEMPORARY] FUNCTION ... ) or the
 * Routines API to define UDF resources. For additional information on migrating, see:
 * https://cloud.google.com/bigquery/docs/reference/standard-sql/migrating-from-legacy-sql
 * #differences_in_user-defined_javascript_functions
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserDefinedFunctionResource extends com.google.api.client.json.GenericJson {

  /**
   * [Pick one] An inline resource that contains code for a user-defined function (UDF). Providing a
   * inline code resource is equivalent to providing a URI for a file containing the same code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String inlineCode;

  /**
   * [Pick one] A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourceUri;

  /**
   * [Pick one] An inline resource that contains code for a user-defined function (UDF). Providing a
   * inline code resource is equivalent to providing a URI for a file containing the same code.
   * @return value or {@code null} for none
   */
  public java.lang.String getInlineCode() {
    return inlineCode;
  }

  /**
   * [Pick one] An inline resource that contains code for a user-defined function (UDF). Providing a
   * inline code resource is equivalent to providing a URI for a file containing the same code.
   * @param inlineCode inlineCode or {@code null} for none
   */
  public UserDefinedFunctionResource setInlineCode(java.lang.String inlineCode) {
    this.inlineCode = inlineCode;
    return this;
  }

  /**
   * [Pick one] A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
   * @return value or {@code null} for none
   */
  public java.lang.String getResourceUri() {
    return resourceUri;
  }

  /**
   * [Pick one] A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
   * @param resourceUri resourceUri or {@code null} for none
   */
  public UserDefinedFunctionResource setResourceUri(java.lang.String resourceUri) {
    this.resourceUri = resourceUri;
    return this;
  }

  @Override
  public UserDefinedFunctionResource set(String fieldName, Object value) {
    return (UserDefinedFunctionResource) super.set(fieldName, value);
  }

  @Override
  public UserDefinedFunctionResource clone() {
    return (UserDefinedFunctionResource) super.clone();
  }

}
