/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Options for a user-defined Spark routine.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SparkOptions extends com.google.api.client.json.GenericJson {

  /**
   * Archive files to be extracted into the working directory of each executor. For more information
   * about Apache Spark, see [Apache Spark](https://spark.apache.org/docs/latest/index.html).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> archiveUris;

  /**
   * Fully qualified name of the user-provided Spark connection object. Format:
   * ```"projects/{project_id}/locations/{location_id}/connections/{connection_id}"```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String connection;

  /**
   * Custom container image for the runtime environment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String containerImage;

  /**
   * Files to be placed in the working directory of each executor. For more information about Apache
   * Spark, see [Apache Spark](https://spark.apache.org/docs/latest/index.html).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> fileUris;

  /**
   * JARs to include on the driver and executor CLASSPATH. For more information about Apache Spark,
   * see [Apache Spark](https://spark.apache.org/docs/latest/index.html).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> jarUris;

  /**
   * The fully qualified name of a class in jar_uris, for example, com.example.wordcount. Exactly
   * one of main_class and main_jar_uri field should be set for Java/Scala language type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mainClass;

  /**
   * The main file/jar URI of the Spark application. Exactly one of the definition_body field and
   * the main_file_uri field must be set for Python.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mainFileUri;

  /**
   * Configuration properties as a set of key/value pairs, which will be passed on to the Spark
   * application. For more information, see [Apache
   * Spark](https://spark.apache.org/docs/latest/index.html) and the [procedure option
   * list](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-
   * language#procedure_option_list).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> properties;

  /**
   * Python files to be placed on the PYTHONPATH for PySpark application. Supported file types:
   * `.py`, `.egg`, and `.zip`. For more information about Apache Spark, see [Apache
   * Spark](https://spark.apache.org/docs/latest/index.html).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> pyFileUris;

  /**
   * Runtime version. If not specified, the default runtime version is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String runtimeVersion;

  /**
   * Archive files to be extracted into the working directory of each executor. For more information
   * about Apache Spark, see [Apache Spark](https://spark.apache.org/docs/latest/index.html).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getArchiveUris() {
    return archiveUris;
  }

  /**
   * Archive files to be extracted into the working directory of each executor. For more information
   * about Apache Spark, see [Apache Spark](https://spark.apache.org/docs/latest/index.html).
   * @param archiveUris archiveUris or {@code null} for none
   */
  public SparkOptions setArchiveUris(java.util.List<java.lang.String> archiveUris) {
    this.archiveUris = archiveUris;
    return this;
  }

  /**
   * Fully qualified name of the user-provided Spark connection object. Format:
   * ```"projects/{project_id}/locations/{location_id}/connections/{connection_id}"```
   * @return value or {@code null} for none
   */
  public java.lang.String getConnection() {
    return connection;
  }

  /**
   * Fully qualified name of the user-provided Spark connection object. Format:
   * ```"projects/{project_id}/locations/{location_id}/connections/{connection_id}"```
   * @param connection connection or {@code null} for none
   */
  public SparkOptions setConnection(java.lang.String connection) {
    this.connection = connection;
    return this;
  }

  /**
   * Custom container image for the runtime environment.
   * @return value or {@code null} for none
   */
  public java.lang.String getContainerImage() {
    return containerImage;
  }

  /**
   * Custom container image for the runtime environment.
   * @param containerImage containerImage or {@code null} for none
   */
  public SparkOptions setContainerImage(java.lang.String containerImage) {
    this.containerImage = containerImage;
    return this;
  }

  /**
   * Files to be placed in the working directory of each executor. For more information about Apache
   * Spark, see [Apache Spark](https://spark.apache.org/docs/latest/index.html).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getFileUris() {
    return fileUris;
  }

  /**
   * Files to be placed in the working directory of each executor. For more information about Apache
   * Spark, see [Apache Spark](https://spark.apache.org/docs/latest/index.html).
   * @param fileUris fileUris or {@code null} for none
   */
  public SparkOptions setFileUris(java.util.List<java.lang.String> fileUris) {
    this.fileUris = fileUris;
    return this;
  }

  /**
   * JARs to include on the driver and executor CLASSPATH. For more information about Apache Spark,
   * see [Apache Spark](https://spark.apache.org/docs/latest/index.html).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getJarUris() {
    return jarUris;
  }

  /**
   * JARs to include on the driver and executor CLASSPATH. For more information about Apache Spark,
   * see [Apache Spark](https://spark.apache.org/docs/latest/index.html).
   * @param jarUris jarUris or {@code null} for none
   */
  public SparkOptions setJarUris(java.util.List<java.lang.String> jarUris) {
    this.jarUris = jarUris;
    return this;
  }

  /**
   * The fully qualified name of a class in jar_uris, for example, com.example.wordcount. Exactly
   * one of main_class and main_jar_uri field should be set for Java/Scala language type.
   * @return value or {@code null} for none
   */
  public java.lang.String getMainClass() {
    return mainClass;
  }

  /**
   * The fully qualified name of a class in jar_uris, for example, com.example.wordcount. Exactly
   * one of main_class and main_jar_uri field should be set for Java/Scala language type.
   * @param mainClass mainClass or {@code null} for none
   */
  public SparkOptions setMainClass(java.lang.String mainClass) {
    this.mainClass = mainClass;
    return this;
  }

  /**
   * The main file/jar URI of the Spark application. Exactly one of the definition_body field and
   * the main_file_uri field must be set for Python.
   * @return value or {@code null} for none
   */
  public java.lang.String getMainFileUri() {
    return mainFileUri;
  }

  /**
   * The main file/jar URI of the Spark application. Exactly one of the definition_body field and
   * the main_file_uri field must be set for Python.
   * @param mainFileUri mainFileUri or {@code null} for none
   */
  public SparkOptions setMainFileUri(java.lang.String mainFileUri) {
    this.mainFileUri = mainFileUri;
    return this;
  }

  /**
   * Configuration properties as a set of key/value pairs, which will be passed on to the Spark
   * application. For more information, see [Apache
   * Spark](https://spark.apache.org/docs/latest/index.html) and the [procedure option
   * list](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-
   * language#procedure_option_list).
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getProperties() {
    return properties;
  }

  /**
   * Configuration properties as a set of key/value pairs, which will be passed on to the Spark
   * application. For more information, see [Apache
   * Spark](https://spark.apache.org/docs/latest/index.html) and the [procedure option
   * list](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-
   * language#procedure_option_list).
   * @param properties properties or {@code null} for none
   */
  public SparkOptions setProperties(java.util.Map<String, java.lang.String> properties) {
    this.properties = properties;
    return this;
  }

  /**
   * Python files to be placed on the PYTHONPATH for PySpark application. Supported file types:
   * `.py`, `.egg`, and `.zip`. For more information about Apache Spark, see [Apache
   * Spark](https://spark.apache.org/docs/latest/index.html).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPyFileUris() {
    return pyFileUris;
  }

  /**
   * Python files to be placed on the PYTHONPATH for PySpark application. Supported file types:
   * `.py`, `.egg`, and `.zip`. For more information about Apache Spark, see [Apache
   * Spark](https://spark.apache.org/docs/latest/index.html).
   * @param pyFileUris pyFileUris or {@code null} for none
   */
  public SparkOptions setPyFileUris(java.util.List<java.lang.String> pyFileUris) {
    this.pyFileUris = pyFileUris;
    return this;
  }

  /**
   * Runtime version. If not specified, the default runtime version is used.
   * @return value or {@code null} for none
   */
  public java.lang.String getRuntimeVersion() {
    return runtimeVersion;
  }

  /**
   * Runtime version. If not specified, the default runtime version is used.
   * @param runtimeVersion runtimeVersion or {@code null} for none
   */
  public SparkOptions setRuntimeVersion(java.lang.String runtimeVersion) {
    this.runtimeVersion = runtimeVersion;
    return this;
  }

  @Override
  public SparkOptions set(String fieldName, Object value) {
    return (SparkOptions) super.set(fieldName, value);
  }

  @Override
  public SparkOptions clone() {
    return (SparkOptions) super.clone();
  }

}
