/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Aggregate metrics for classification/classifier models. For multi-class models, the metrics are
 * either macro-averaged or micro-averaged. When macro-averaged, the metrics are calculated for each
 * label and then an unweighted average is taken of those values. When micro-averaged, the metric is
 * calculated globally by counting the total number of correctly predicted rows.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AggregateClassificationMetrics extends com.google.api.client.json.GenericJson {

  /**
   * Accuracy is the fraction of predictions given the correct label. For multiclass this is a
   * micro-averaged metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double accuracy;

  /**
   * The F1 score is an average of recall and precision. For multiclass this is a macro-averaged
   * metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double f1Score;

  /**
   * Logarithmic Loss. For multiclass this is a macro-averaged metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double logLoss;

  /**
   * Precision is the fraction of actual positive predictions that had positive actual labels. For
   * multiclass this is a macro-averaged metric treating each class as a binary classifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double precision;

  /**
   * Recall is the fraction of actual positive labels that were given a positive prediction. For
   * multiclass this is a macro-averaged metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double recall;

  /**
   * Area Under a ROC Curve. For multiclass this is a macro-averaged metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double rocAuc;

  /**
   * Threshold at which the metrics are computed. For binary classification models this is the
   * positive class threshold. For multi-class classfication models this is the confidence
   * threshold.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double threshold;

  /**
   * Accuracy is the fraction of predictions given the correct label. For multiclass this is a
   * micro-averaged metric.
   * @return value or {@code null} for none
   */
  public java.lang.Double getAccuracy() {
    return accuracy;
  }

  /**
   * Accuracy is the fraction of predictions given the correct label. For multiclass this is a
   * micro-averaged metric.
   * @param accuracy accuracy or {@code null} for none
   */
  public AggregateClassificationMetrics setAccuracy(java.lang.Double accuracy) {
    this.accuracy = accuracy;
    return this;
  }

  /**
   * The F1 score is an average of recall and precision. For multiclass this is a macro-averaged
   * metric.
   * @return value or {@code null} for none
   */
  public java.lang.Double getF1Score() {
    return f1Score;
  }

  /**
   * The F1 score is an average of recall and precision. For multiclass this is a macro-averaged
   * metric.
   * @param f1Score f1Score or {@code null} for none
   */
  public AggregateClassificationMetrics setF1Score(java.lang.Double f1Score) {
    this.f1Score = f1Score;
    return this;
  }

  /**
   * Logarithmic Loss. For multiclass this is a macro-averaged metric.
   * @return value or {@code null} for none
   */
  public java.lang.Double getLogLoss() {
    return logLoss;
  }

  /**
   * Logarithmic Loss. For multiclass this is a macro-averaged metric.
   * @param logLoss logLoss or {@code null} for none
   */
  public AggregateClassificationMetrics setLogLoss(java.lang.Double logLoss) {
    this.logLoss = logLoss;
    return this;
  }

  /**
   * Precision is the fraction of actual positive predictions that had positive actual labels. For
   * multiclass this is a macro-averaged metric treating each class as a binary classifier.
   * @return value or {@code null} for none
   */
  public java.lang.Double getPrecision() {
    return precision;
  }

  /**
   * Precision is the fraction of actual positive predictions that had positive actual labels. For
   * multiclass this is a macro-averaged metric treating each class as a binary classifier.
   * @param precision precision or {@code null} for none
   */
  public AggregateClassificationMetrics setPrecision(java.lang.Double precision) {
    this.precision = precision;
    return this;
  }

  /**
   * Recall is the fraction of actual positive labels that were given a positive prediction. For
   * multiclass this is a macro-averaged metric.
   * @return value or {@code null} for none
   */
  public java.lang.Double getRecall() {
    return recall;
  }

  /**
   * Recall is the fraction of actual positive labels that were given a positive prediction. For
   * multiclass this is a macro-averaged metric.
   * @param recall recall or {@code null} for none
   */
  public AggregateClassificationMetrics setRecall(java.lang.Double recall) {
    this.recall = recall;
    return this;
  }

  /**
   * Area Under a ROC Curve. For multiclass this is a macro-averaged metric.
   * @return value or {@code null} for none
   */
  public java.lang.Double getRocAuc() {
    return rocAuc;
  }

  /**
   * Area Under a ROC Curve. For multiclass this is a macro-averaged metric.
   * @param rocAuc rocAuc or {@code null} for none
   */
  public AggregateClassificationMetrics setRocAuc(java.lang.Double rocAuc) {
    this.rocAuc = rocAuc;
    return this;
  }

  /**
   * Threshold at which the metrics are computed. For binary classification models this is the
   * positive class threshold. For multi-class classfication models this is the confidence
   * threshold.
   * @return value or {@code null} for none
   */
  public java.lang.Double getThreshold() {
    return threshold;
  }

  /**
   * Threshold at which the metrics are computed. For binary classification models this is the
   * positive class threshold. For multi-class classfication models this is the confidence
   * threshold.
   * @param threshold threshold or {@code null} for none
   */
  public AggregateClassificationMetrics setThreshold(java.lang.Double threshold) {
    this.threshold = threshold;
    return this;
  }

  @Override
  public AggregateClassificationMetrics set(String fieldName, Object value) {
    return (AggregateClassificationMetrics) super.set(fieldName, value);
  }

  @Override
  public AggregateClassificationMetrics clone() {
    return (AggregateClassificationMetrics) super.clone();
  }

}
