/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for TableConstraints.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableConstraints extends com.google.api.client.json.GenericJson {

  /**
   * [Optional] The foreign keys of the tables.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("foreign_keys")
  private java.util.List<ForeignKeys> foreignKeys;

  static {
    // hack to force ProGuard to consider ForeignKeys used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ForeignKeys.class);
  }

  /**
   * [Optional] The primary key of the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("primary_key")
  private PrimaryKey primaryKey;

  /**
   * [Optional] The foreign keys of the tables.
   * @return value or {@code null} for none
   */
  public java.util.List<ForeignKeys> getForeignKeys() {
    return foreignKeys;
  }

  /**
   * [Optional] The foreign keys of the tables.
   * @param foreignKeys foreignKeys or {@code null} for none
   */
  public TableConstraints setForeignKeys(java.util.List<ForeignKeys> foreignKeys) {
    this.foreignKeys = foreignKeys;
    return this;
  }

  /**
   * [Optional] The primary key of the table.
   * @return value or {@code null} for none
   */
  public PrimaryKey getPrimaryKey() {
    return primaryKey;
  }

  /**
   * [Optional] The primary key of the table.
   * @param primaryKey primaryKey or {@code null} for none
   */
  public TableConstraints setPrimaryKey(PrimaryKey primaryKey) {
    this.primaryKey = primaryKey;
    return this;
  }

  @Override
  public TableConstraints set(String fieldName, Object value) {
    return (TableConstraints) super.set(fieldName, value);
  }

  @Override
  public TableConstraints clone() {
    return (TableConstraints) super.clone();
  }

  /**
   * Model definition for TableConstraintsForeignKeys.
   */
  public static final class ForeignKeys extends com.google.api.client.json.GenericJson {

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("column_references")
    private java.util.List<ColumnReferences> columnReferences;

    static {
      // hack to force ProGuard to consider ColumnReferences used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(ColumnReferences.class);
    }

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String name;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("referenced_table")
    private ReferencedTable referencedTable;

    /**
     * @return value or {@code null} for none
     */
    public java.util.List<ColumnReferences> getColumnReferences() {
      return columnReferences;
    }

    /**
     * @param columnReferences columnReferences or {@code null} for none
     */
    public ForeignKeys setColumnReferences(java.util.List<ColumnReferences> columnReferences) {
      this.columnReferences = columnReferences;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.String getName() {
      return name;
    }

    /**
     * @param name name or {@code null} for none
     */
    public ForeignKeys setName(java.lang.String name) {
      this.name = name;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public ReferencedTable getReferencedTable() {
      return referencedTable;
    }

    /**
     * @param referencedTable referencedTable or {@code null} for none
     */
    public ForeignKeys setReferencedTable(ReferencedTable referencedTable) {
      this.referencedTable = referencedTable;
      return this;
    }

    @Override
    public ForeignKeys set(String fieldName, Object value) {
      return (ForeignKeys) super.set(fieldName, value);
    }

    @Override
    public ForeignKeys clone() {
      return (ForeignKeys) super.clone();
    }

    /**
     * Model definition for TableConstraintsForeignKeysColumnReferences.
     */
    public static final class ColumnReferences extends com.google.api.client.json.GenericJson {

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key("referenced_column")
      private java.lang.String referencedColumn;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key("referencing_column")
      private java.lang.String referencingColumn;

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getReferencedColumn() {
        return referencedColumn;
      }

      /**
       * @param referencedColumn referencedColumn or {@code null} for none
       */
      public ColumnReferences setReferencedColumn(java.lang.String referencedColumn) {
        this.referencedColumn = referencedColumn;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getReferencingColumn() {
        return referencingColumn;
      }

      /**
       * @param referencingColumn referencingColumn or {@code null} for none
       */
      public ColumnReferences setReferencingColumn(java.lang.String referencingColumn) {
        this.referencingColumn = referencingColumn;
        return this;
      }

      @Override
      public ColumnReferences set(String fieldName, Object value) {
        return (ColumnReferences) super.set(fieldName, value);
      }

      @Override
      public ColumnReferences clone() {
        return (ColumnReferences) super.clone();
      }

    }
    /**
     * Model definition for TableConstraintsForeignKeysReferencedTable.
     */
    public static final class ReferencedTable extends com.google.api.client.json.GenericJson {

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /**
       * @param datasetId datasetId or {@code null} for none
       */
      public ReferencedTable setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /**
       * @param projectId projectId or {@code null} for none
       */
      public ReferencedTable setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /**
       * @param tableId tableId or {@code null} for none
       */
      public ReferencedTable setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      @Override
      public ReferencedTable set(String fieldName, Object value) {
        return (ReferencedTable) super.set(fieldName, value);
      }

      @Override
      public ReferencedTable clone() {
        return (ReferencedTable) super.clone();
      }

    }
  }

  /**
   * [Optional] The primary key of the table.
   */
  public static final class PrimaryKey extends com.google.api.client.json.GenericJson {

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> columns;

    /**
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getColumns() {
      return columns;
    }

    /**
     * @param columns columns or {@code null} for none
     */
    public PrimaryKey setColumns(java.util.List<java.lang.String> columns) {
      this.columns = columns;
      return this;
    }

    @Override
    public PrimaryKey set(String fieldName, Object value) {
      return (PrimaryKey) super.set(fieldName, value);
    }

    @Override
    public PrimaryKey clone() {
      return (PrimaryKey) super.clone();
    }

  }
}
