/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Remote Model Info
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RemoteModelInfo extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Fully qualified name of the user-provided connection object of the remote model.
   * Format: ```"projects/{project_id}/locations/{location_id}/connections/{connection_id}"```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String connection;

  /**
   * Output only. The endpoint for remote model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endpoint;

  /**
   * Output only. Max number of rows in each batch sent to the remote service. If unset, the number
   * of rows in each batch is set dynamically.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxBatchingRows;

  /**
   * Output only. The model version for LLM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String remoteModelVersion;

  /**
   * Output only. The remote service type for remote model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String remoteServiceType;

  /**
   * Output only. Fully qualified name of the user-provided connection object of the remote model.
   * Format: ```"projects/{project_id}/locations/{location_id}/connections/{connection_id}"```
   * @return value or {@code null} for none
   */
  public java.lang.String getConnection() {
    return connection;
  }

  /**
   * Output only. Fully qualified name of the user-provided connection object of the remote model.
   * Format: ```"projects/{project_id}/locations/{location_id}/connections/{connection_id}"```
   * @param connection connection or {@code null} for none
   */
  public RemoteModelInfo setConnection(java.lang.String connection) {
    this.connection = connection;
    return this;
  }

  /**
   * Output only. The endpoint for remote model.
   * @return value or {@code null} for none
   */
  public java.lang.String getEndpoint() {
    return endpoint;
  }

  /**
   * Output only. The endpoint for remote model.
   * @param endpoint endpoint or {@code null} for none
   */
  public RemoteModelInfo setEndpoint(java.lang.String endpoint) {
    this.endpoint = endpoint;
    return this;
  }

  /**
   * Output only. Max number of rows in each batch sent to the remote service. If unset, the number
   * of rows in each batch is set dynamically.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxBatchingRows() {
    return maxBatchingRows;
  }

  /**
   * Output only. Max number of rows in each batch sent to the remote service. If unset, the number
   * of rows in each batch is set dynamically.
   * @param maxBatchingRows maxBatchingRows or {@code null} for none
   */
  public RemoteModelInfo setMaxBatchingRows(java.lang.Long maxBatchingRows) {
    this.maxBatchingRows = maxBatchingRows;
    return this;
  }

  /**
   * Output only. The model version for LLM.
   * @return value or {@code null} for none
   */
  public java.lang.String getRemoteModelVersion() {
    return remoteModelVersion;
  }

  /**
   * Output only. The model version for LLM.
   * @param remoteModelVersion remoteModelVersion or {@code null} for none
   */
  public RemoteModelInfo setRemoteModelVersion(java.lang.String remoteModelVersion) {
    this.remoteModelVersion = remoteModelVersion;
    return this;
  }

  /**
   * Output only. The remote service type for remote model.
   * @return value or {@code null} for none
   */
  public java.lang.String getRemoteServiceType() {
    return remoteServiceType;
  }

  /**
   * Output only. The remote service type for remote model.
   * @param remoteServiceType remoteServiceType or {@code null} for none
   */
  public RemoteModelInfo setRemoteServiceType(java.lang.String remoteServiceType) {
    this.remoteServiceType = remoteServiceType;
    return this;
  }

  @Override
  public RemoteModelInfo set(String fieldName, Object value) {
    return (RemoteModelInfo) super.set(fieldName, value);
  }

  @Override
  public RemoteModelInfo clone() {
    return (RemoteModelInfo) super.clone();
  }

}
