/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Options for a remote user-defined function.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RemoteFunctionOptions extends com.google.api.client.json.GenericJson {

  /**
   * Fully qualified name of the user-provided connection object which holds the authentication
   * information to send requests to the remote service. Format:
   * ```"projects/{projectId}/locations/{locationId}/connections/{connectionId}"```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String connection;

  /**
   * Endpoint of the user-provided remote service, e.g. ```https://us-
   * east1-my_gcf_project.cloudfunctions.net/remote_add```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endpoint;

  /**
   * Max number of rows in each batch sent to the remote service. If absent or if 0, BigQuery
   * dynamically decides the number of rows in a batch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxBatchingRows;

  /**
   * User-defined context as a set of key/value pairs, which will be sent as function invocation
   * context together with batched arguments in the requests to the remote service. The total number
   * of bytes of keys and values must be less than 8KB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> userDefinedContext;

  /**
   * Fully qualified name of the user-provided connection object which holds the authentication
   * information to send requests to the remote service. Format:
   * ```"projects/{projectId}/locations/{locationId}/connections/{connectionId}"```
   * @return value or {@code null} for none
   */
  public java.lang.String getConnection() {
    return connection;
  }

  /**
   * Fully qualified name of the user-provided connection object which holds the authentication
   * information to send requests to the remote service. Format:
   * ```"projects/{projectId}/locations/{locationId}/connections/{connectionId}"```
   * @param connection connection or {@code null} for none
   */
  public RemoteFunctionOptions setConnection(java.lang.String connection) {
    this.connection = connection;
    return this;
  }

  /**
   * Endpoint of the user-provided remote service, e.g. ```https://us-
   * east1-my_gcf_project.cloudfunctions.net/remote_add```
   * @return value or {@code null} for none
   */
  public java.lang.String getEndpoint() {
    return endpoint;
  }

  /**
   * Endpoint of the user-provided remote service, e.g. ```https://us-
   * east1-my_gcf_project.cloudfunctions.net/remote_add```
   * @param endpoint endpoint or {@code null} for none
   */
  public RemoteFunctionOptions setEndpoint(java.lang.String endpoint) {
    this.endpoint = endpoint;
    return this;
  }

  /**
   * Max number of rows in each batch sent to the remote service. If absent or if 0, BigQuery
   * dynamically decides the number of rows in a batch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxBatchingRows() {
    return maxBatchingRows;
  }

  /**
   * Max number of rows in each batch sent to the remote service. If absent or if 0, BigQuery
   * dynamically decides the number of rows in a batch.
   * @param maxBatchingRows maxBatchingRows or {@code null} for none
   */
  public RemoteFunctionOptions setMaxBatchingRows(java.lang.Long maxBatchingRows) {
    this.maxBatchingRows = maxBatchingRows;
    return this;
  }

  /**
   * User-defined context as a set of key/value pairs, which will be sent as function invocation
   * context together with batched arguments in the requests to the remote service. The total number
   * of bytes of keys and values must be less than 8KB.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getUserDefinedContext() {
    return userDefinedContext;
  }

  /**
   * User-defined context as a set of key/value pairs, which will be sent as function invocation
   * context together with batched arguments in the requests to the remote service. The total number
   * of bytes of keys and values must be less than 8KB.
   * @param userDefinedContext userDefinedContext or {@code null} for none
   */
  public RemoteFunctionOptions setUserDefinedContext(java.util.Map<String, java.lang.String> userDefinedContext) {
    this.userDefinedContext = userDefinedContext;
    return this;
  }

  @Override
  public RemoteFunctionOptions set(String fieldName, Object value) {
    return (RemoteFunctionOptions) super.set(fieldName, value);
  }

  @Override
  public RemoteFunctionOptions clone() {
    return (RemoteFunctionOptions) super.clone();
  }

}
