/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Information about a single transform column.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TransformColumn extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Name of the column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The SQL expression used in the column transform.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String transformSql;

  /**
   * Output only. Data type of the column after the transform.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StandardSqlDataType type;

  /**
   * Output only. Name of the column.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Name of the column.
   * @param name name or {@code null} for none
   */
  public TransformColumn setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The SQL expression used in the column transform.
   * @return value or {@code null} for none
   */
  public java.lang.String getTransformSql() {
    return transformSql;
  }

  /**
   * Output only. The SQL expression used in the column transform.
   * @param transformSql transformSql or {@code null} for none
   */
  public TransformColumn setTransformSql(java.lang.String transformSql) {
    this.transformSql = transformSql;
    return this;
  }

  /**
   * Output only. Data type of the column after the transform.
   * @return value or {@code null} for none
   */
  public StandardSqlDataType getType() {
    return type;
  }

  /**
   * Output only. Data type of the column after the transform.
   * @param type type or {@code null} for none
   */
  public TransformColumn setType(StandardSqlDataType type) {
    this.type = type;
    return this;
  }

  @Override
  public TransformColumn set(String fieldName, Object value) {
    return (TransformColumn) super.set(fieldName, value);
  }

  @Override
  public TransformColumn clone() {
    return (TransformColumn) super.clone();
  }

}
