/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Describes the definition of a logical view.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ViewDefinition extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Foreign view representations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ForeignViewDefinition> foreignDefinitions;

  static {
    // hack to force ProGuard to consider ForeignViewDefinition used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ForeignViewDefinition.class);
  }

  /**
   * Optional. Specifices the privacy policy for the view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PrivacyPolicy privacyPolicy;

  /**
   * Required. A query that BigQuery executes when the view is referenced.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String query;

  /**
   * True if the column names are explicitly specified. For example by using the 'CREATE VIEW v(c1,
   * c2) AS ...' syntax. Can only be set for GoogleSQL views.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useExplicitColumnNames;

  /**
   * Specifies whether to use BigQuery's legacy SQL for this view. The default value is true. If set
   * to false, the view will use BigQuery's GoogleSQL: https://cloud.google.com/bigquery/sql-
   * reference/ Queries and views that reference this view must use the same flag value. A wrapper
   * is used here because the default value is True.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useLegacySql;

  /**
   * Describes user-defined function resources used in the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UserDefinedFunctionResource> userDefinedFunctionResources;

  static {
    // hack to force ProGuard to consider UserDefinedFunctionResource used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(UserDefinedFunctionResource.class);
  }

  /**
   * Optional. Foreign view representations.
   * @return value or {@code null} for none
   */
  public java.util.List<ForeignViewDefinition> getForeignDefinitions() {
    return foreignDefinitions;
  }

  /**
   * Optional. Foreign view representations.
   * @param foreignDefinitions foreignDefinitions or {@code null} for none
   */
  public ViewDefinition setForeignDefinitions(java.util.List<ForeignViewDefinition> foreignDefinitions) {
    this.foreignDefinitions = foreignDefinitions;
    return this;
  }

  /**
   * Optional. Specifices the privacy policy for the view.
   * @return value or {@code null} for none
   */
  public PrivacyPolicy getPrivacyPolicy() {
    return privacyPolicy;
  }

  /**
   * Optional. Specifices the privacy policy for the view.
   * @param privacyPolicy privacyPolicy or {@code null} for none
   */
  public ViewDefinition setPrivacyPolicy(PrivacyPolicy privacyPolicy) {
    this.privacyPolicy = privacyPolicy;
    return this;
  }

  /**
   * Required. A query that BigQuery executes when the view is referenced.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuery() {
    return query;
  }

  /**
   * Required. A query that BigQuery executes when the view is referenced.
   * @param query query or {@code null} for none
   */
  public ViewDefinition setQuery(java.lang.String query) {
    this.query = query;
    return this;
  }

  /**
   * True if the column names are explicitly specified. For example by using the 'CREATE VIEW v(c1,
   * c2) AS ...' syntax. Can only be set for GoogleSQL views.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseExplicitColumnNames() {
    return useExplicitColumnNames;
  }

  /**
   * True if the column names are explicitly specified. For example by using the 'CREATE VIEW v(c1,
   * c2) AS ...' syntax. Can only be set for GoogleSQL views.
   * @param useExplicitColumnNames useExplicitColumnNames or {@code null} for none
   */
  public ViewDefinition setUseExplicitColumnNames(java.lang.Boolean useExplicitColumnNames) {
    this.useExplicitColumnNames = useExplicitColumnNames;
    return this;
  }

  /**
   * Specifies whether to use BigQuery's legacy SQL for this view. The default value is true. If set
   * to false, the view will use BigQuery's GoogleSQL: https://cloud.google.com/bigquery/sql-
   * reference/ Queries and views that reference this view must use the same flag value. A wrapper
   * is used here because the default value is True.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseLegacySql() {
    return useLegacySql;
  }

  /**
   * Specifies whether to use BigQuery's legacy SQL for this view. The default value is true. If set
   * to false, the view will use BigQuery's GoogleSQL: https://cloud.google.com/bigquery/sql-
   * reference/ Queries and views that reference this view must use the same flag value. A wrapper
   * is used here because the default value is True.
   * @param useLegacySql useLegacySql or {@code null} for none
   */
  public ViewDefinition setUseLegacySql(java.lang.Boolean useLegacySql) {
    this.useLegacySql = useLegacySql;
    return this;
  }

  /**
   * Describes user-defined function resources used in the query.
   * @return value or {@code null} for none
   */
  public java.util.List<UserDefinedFunctionResource> getUserDefinedFunctionResources() {
    return userDefinedFunctionResources;
  }

  /**
   * Describes user-defined function resources used in the query.
   * @param userDefinedFunctionResources userDefinedFunctionResources or {@code null} for none
   */
  public ViewDefinition setUserDefinedFunctionResources(java.util.List<UserDefinedFunctionResource> userDefinedFunctionResources) {
    this.userDefinedFunctionResources = userDefinedFunctionResources;
    return this;
  }

  @Override
  public ViewDefinition set(String fieldName, Object value) {
    return (ViewDefinition) super.set(fieldName, value);
  }

  @Override
  public ViewDefinition clone() {
    return (ViewDefinition) super.clone();
  }

}
