/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Contains information about how a table's data is stored and accessed by open source query
 * engines.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StorageDescriptor extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Specifies the fully qualified class name of the InputFormat (e.g.
   * "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat"). The maximum length is 128 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String inputFormat;

  /**
   * Optional. The physical location of the table (e.g. 'gs://spark-dataproc-data/pangea-
   * data/case_sensitive/' or 'gs://spark-dataproc-data/pangea-data'). The maximum length is 2056
   * bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationUri;

  /**
   * Optional. Specifies the fully qualified class name of the OutputFormat (e.g.
   * "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat"). The maximum length is 128 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String outputFormat;

  /**
   * Optional. Serializer and deserializer information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SerDeInfo serdeInfo;

  /**
   * Optional. Specifies the fully qualified class name of the InputFormat (e.g.
   * "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat"). The maximum length is 128 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getInputFormat() {
    return inputFormat;
  }

  /**
   * Optional. Specifies the fully qualified class name of the InputFormat (e.g.
   * "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat"). The maximum length is 128 characters.
   * @param inputFormat inputFormat or {@code null} for none
   */
  public StorageDescriptor setInputFormat(java.lang.String inputFormat) {
    this.inputFormat = inputFormat;
    return this;
  }

  /**
   * Optional. The physical location of the table (e.g. 'gs://spark-dataproc-data/pangea-
   * data/case_sensitive/' or 'gs://spark-dataproc-data/pangea-data'). The maximum length is 2056
   * bytes.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationUri() {
    return locationUri;
  }

  /**
   * Optional. The physical location of the table (e.g. 'gs://spark-dataproc-data/pangea-
   * data/case_sensitive/' or 'gs://spark-dataproc-data/pangea-data'). The maximum length is 2056
   * bytes.
   * @param locationUri locationUri or {@code null} for none
   */
  public StorageDescriptor setLocationUri(java.lang.String locationUri) {
    this.locationUri = locationUri;
    return this;
  }

  /**
   * Optional. Specifies the fully qualified class name of the OutputFormat (e.g.
   * "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat"). The maximum length is 128 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getOutputFormat() {
    return outputFormat;
  }

  /**
   * Optional. Specifies the fully qualified class name of the OutputFormat (e.g.
   * "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat"). The maximum length is 128 characters.
   * @param outputFormat outputFormat or {@code null} for none
   */
  public StorageDescriptor setOutputFormat(java.lang.String outputFormat) {
    this.outputFormat = outputFormat;
    return this;
  }

  /**
   * Optional. Serializer and deserializer information.
   * @return value or {@code null} for none
   */
  public SerDeInfo getSerdeInfo() {
    return serdeInfo;
  }

  /**
   * Optional. Serializer and deserializer information.
   * @param serdeInfo serdeInfo or {@code null} for none
   */
  public StorageDescriptor setSerdeInfo(SerDeInfo serdeInfo) {
    this.serdeInfo = serdeInfo;
    return this;
  }

  @Override
  public StorageDescriptor set(String fieldName, Object value) {
    return (StorageDescriptor) super.set(fieldName, value);
  }

  @Override
  public StorageDescriptor clone() {
    return (StorageDescriptor) super.clone();
  }

}
