/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Metadata for value generation for an identity column.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IdentityColumnInfo extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Dictates when system generated values are used to populate the field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String generatedMode;

  /**
   * Optional. The minimum difference between two successive generated values. Should be INTEGER
   * compatible. Can be negative or positive but not 0. The default value is 1 if the field is not
   * specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String increment;

  /**
   * Optional. The first generated value. Should be INTEGER compatible. The default value is 1 if
   * the field is not specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String start;

  /**
   * Optional. Dictates when system generated values are used to populate the field.
   * @return value or {@code null} for none
   */
  public java.lang.String getGeneratedMode() {
    return generatedMode;
  }

  /**
   * Optional. Dictates when system generated values are used to populate the field.
   * @param generatedMode generatedMode or {@code null} for none
   */
  public IdentityColumnInfo setGeneratedMode(java.lang.String generatedMode) {
    this.generatedMode = generatedMode;
    return this;
  }

  /**
   * Optional. The minimum difference between two successive generated values. Should be INTEGER
   * compatible. Can be negative or positive but not 0. The default value is 1 if the field is not
   * specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getIncrement() {
    return increment;
  }

  /**
   * Optional. The minimum difference between two successive generated values. Should be INTEGER
   * compatible. Can be negative or positive but not 0. The default value is 1 if the field is not
   * specified.
   * @param increment increment or {@code null} for none
   */
  public IdentityColumnInfo setIncrement(java.lang.String increment) {
    this.increment = increment;
    return this;
  }

  /**
   * Optional. The first generated value. Should be INTEGER compatible. The default value is 1 if
   * the field is not specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getStart() {
    return start;
  }

  /**
   * Optional. The first generated value. Should be INTEGER compatible. The default value is 1 if
   * the field is not specified.
   * @param start start or {@code null} for none
   */
  public IdentityColumnInfo setStart(java.lang.String start) {
    this.start = start;
    return this;
  }

  @Override
  public IdentityColumnInfo set(String fieldName, Object value) {
    return (IdentityColumnInfo) super.set(fieldName, value);
  }

  @Override
  public IdentityColumnInfo clone() {
    return (IdentityColumnInfo) super.clone();
  }

}
