/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * System variables given to a query.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SystemVariables extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Data type for each system variable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, StandardSqlDataType> types;

  static {
    // hack to force ProGuard to consider StandardSqlDataType used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(StandardSqlDataType.class);
  }

  /**
   * Output only. Value for each system variable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> values;

  /**
   * Output only. Data type for each system variable.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, StandardSqlDataType> getTypes() {
    return types;
  }

  /**
   * Output only. Data type for each system variable.
   * @param types types or {@code null} for none
   */
  public SystemVariables setTypes(java.util.Map<String, StandardSqlDataType> types) {
    this.types = types;
    return this;
  }

  /**
   * Output only. Value for each system variable.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getValues() {
    return values;
  }

  /**
   * Output only. Value for each system variable.
   * @param values values or {@code null} for none
   */
  public SystemVariables setValues(java.util.Map<String, java.lang.Object> values) {
    this.values = values;
    return this;
  }

  @Override
  public SystemVariables set(String fieldName, Object value) {
    return (SystemVariables) super.set(fieldName, value);
  }

  @Override
  public SystemVariables clone() {
    return (SystemVariables) super.clone();
  }

}
