/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Configures the access a dataset defined in an external metadata storage.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExternalDatasetReference extends com.google.api.client.json.GenericJson {

  /**
   * Required. The connection id that is used to access the external_source. Format:
   * projects/{project_id}/locations/{location_id}/connections/{connection_id}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String connection;

  /**
   * Required. External source that backs this dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalSource;

  /**
   * Required. The connection id that is used to access the external_source. Format:
   * projects/{project_id}/locations/{location_id}/connections/{connection_id}
   * @return value or {@code null} for none
   */
  public java.lang.String getConnection() {
    return connection;
  }

  /**
   * Required. The connection id that is used to access the external_source. Format:
   * projects/{project_id}/locations/{location_id}/connections/{connection_id}
   * @param connection connection or {@code null} for none
   */
  public ExternalDatasetReference setConnection(java.lang.String connection) {
    this.connection = connection;
    return this;
  }

  /**
   * Required. External source that backs this dataset.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalSource() {
    return externalSource;
  }

  /**
   * Required. External source that backs this dataset.
   * @param externalSource externalSource or {@code null} for none
   */
  public ExternalDatasetReference setExternalSource(java.lang.String externalSource) {
    this.externalSource = externalSource;
    return this;
  }

  @Override
  public ExternalDatasetReference set(String fieldName, Object value) {
    return (ExternalDatasetReference) super.set(fieldName, value);
  }

  @Override
  public ExternalDatasetReference clone() {
    return (ExternalDatasetReference) super.clone();
  }

}
