/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Schema of a table
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableSchema extends com.google.api.client.json.GenericJson {

  /**
   * Describes the fields in a table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TableFieldSchema> fields;

  static {
    // hack to force ProGuard to consider TableFieldSchema used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TableFieldSchema.class);
  }

  /**
   * Optional. Specifies metadata of the foreign data type definition in field schema
   * (TableFieldSchema.foreign_type_definition).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ForeignTypeInfo foreignTypeInfo;

  /**
   * Describes the fields in a table.
   * @return value or {@code null} for none
   */
  public java.util.List<TableFieldSchema> getFields() {
    return fields;
  }

  /**
   * Describes the fields in a table.
   * @param fields fields or {@code null} for none
   */
  public TableSchema setFields(java.util.List<TableFieldSchema> fields) {
    this.fields = fields;
    return this;
  }

  /**
   * Optional. Specifies metadata of the foreign data type definition in field schema
   * (TableFieldSchema.foreign_type_definition).
   * @return value or {@code null} for none
   */
  public ForeignTypeInfo getForeignTypeInfo() {
    return foreignTypeInfo;
  }

  /**
   * Optional. Specifies metadata of the foreign data type definition in field schema
   * (TableFieldSchema.foreign_type_definition).
   * @param foreignTypeInfo foreignTypeInfo or {@code null} for none
   */
  public TableSchema setForeignTypeInfo(ForeignTypeInfo foreignTypeInfo) {
    this.foreignTypeInfo = foreignTypeInfo;
    return this;
  }

  @Override
  public TableSchema set(String fieldName, Object value) {
    return (TableSchema) super.set(fieldName, value);
  }

  @Override
  public TableSchema clone() {
    return (TableSchema) super.clone();
  }

}
