/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * A connection-level property to customize query behavior. Under JDBC, these correspond directly to
 * connection properties passed to the DriverManager. Under ODBC, these correspond to properties in
 * the connection string. Currently supported connection properties: * **dataset_project_id**:
 * represents the default project for datasets that are used in the query. Setting the system
 * variable `@@dataset_project_id` achieves the same behavior. For more information about system
 * variables, see: https://cloud.google.com/bigquery/docs/reference/system-variables *
 * **time_zone**: represents the default timezone used to run the query. * **session_id**:
 * associates the query with a given session. * **query_label**: associates the query with a given
 * job label. If set, all subsequent queries in a script or session will have this label. For the
 * format in which a you can specify a query label, see labels in the JobConfiguration resource
 * type: https://cloud.google.com/bigquery/docs/reference/rest/v2/Job#jobconfiguration *
 * **service_account**: indicates the service account to use to run a continuous query. If set, the
 * query job uses the service account to access Google Cloud resources. Service account access is
 * bounded by the IAM permissions that you have granted to the service account. Additional
 * properties are allowed, but ignored. Specifying multiple connection properties with the same key
 * returns an error.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConnectionProperty extends com.google.api.client.json.GenericJson {

  /**
   * The key of the property to set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * The value of the property to set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The key of the property to set.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * The key of the property to set.
   * @param key key or {@code null} for none
   */
  public ConnectionProperty setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * The value of the property to set.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The value of the property to set.
   * @param value value or {@code null} for none
   */
  public ConnectionProperty setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public ConnectionProperty set(String fieldName, Object value) {
    return (ConnectionProperty) super.set(fieldName, value);
  }

  @Override
  public ConnectionProperty clone() {
    return (ConnectionProperty) super.clone();
  }

}
