/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Detailed statistics for DML statements
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DmlStatistics extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Number of deleted Rows. populated by DML DELETE, MERGE and TRUNCATE statements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long deletedRowCount;

  /**
   * Output only. Number of inserted Rows. Populated by DML INSERT and MERGE statements
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long insertedRowCount;

  /**
   * Output only. Number of updated Rows. Populated by DML UPDATE and MERGE statements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long updatedRowCount;

  /**
   * Output only. Number of deleted Rows. populated by DML DELETE, MERGE and TRUNCATE statements.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDeletedRowCount() {
    return deletedRowCount;
  }

  /**
   * Output only. Number of deleted Rows. populated by DML DELETE, MERGE and TRUNCATE statements.
   * @param deletedRowCount deletedRowCount or {@code null} for none
   */
  public DmlStatistics setDeletedRowCount(java.lang.Long deletedRowCount) {
    this.deletedRowCount = deletedRowCount;
    return this;
  }

  /**
   * Output only. Number of inserted Rows. Populated by DML INSERT and MERGE statements
   * @return value or {@code null} for none
   */
  public java.lang.Long getInsertedRowCount() {
    return insertedRowCount;
  }

  /**
   * Output only. Number of inserted Rows. Populated by DML INSERT and MERGE statements
   * @param insertedRowCount insertedRowCount or {@code null} for none
   */
  public DmlStatistics setInsertedRowCount(java.lang.Long insertedRowCount) {
    this.insertedRowCount = insertedRowCount;
    return this;
  }

  /**
   * Output only. Number of updated Rows. Populated by DML UPDATE and MERGE statements.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUpdatedRowCount() {
    return updatedRowCount;
  }

  /**
   * Output only. Number of updated Rows. Populated by DML UPDATE and MERGE statements.
   * @param updatedRowCount updatedRowCount or {@code null} for none
   */
  public DmlStatistics setUpdatedRowCount(java.lang.Long updatedRowCount) {
    this.updatedRowCount = updatedRowCount;
    return this;
  }

  @Override
  public DmlStatistics set(String fieldName, Object value) {
    return (DmlStatistics) super.set(fieldName, value);
  }

  @Override
  public DmlStatistics clone() {
    return (DmlStatistics) super.clone();
  }

}
